/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.common;

import java.math.BigInteger;

public class Arithmetic {
    public static final BigInteger ZERO = BigInteger.valueOf(0L);
    public static final BigInteger ONE = BigInteger.valueOf(1L);
    public static final BigInteger TWO = BigInteger.valueOf(2L);
    public static final BigInteger FOUR = BigInteger.valueOf(4L);
    private static final int[] jacobiTable = new int[]{0, 1, 0, -1, 0, -1, 0, 1};

    public static int jacobi(BigInteger A, BigInteger B) {
        long k = 1L;
        k = 1L;
        if (B.equals(ZERO)) {
            BigInteger a = A.abs();
            return a.equals(ONE) ? 1 : 0;
        }
        if (!A.testBit(0) && !B.testBit(0)) {
            return 0;
        }
        BigInteger a = A;
        BigInteger b = B;
        if (b.signum() == -1) {
            b = b.negate();
            if (a.signum() == -1) {
                k = -1L;
            }
        }
        BigInteger v = ZERO;
        while (!b.testBit(0)) {
            v = v.add(ONE);
            b = b.divide(TWO);
        }
        if (v.testBit(0)) {
            k *= (long)jacobiTable[a.intValue() & 7];
        }
        if (a.signum() < 0) {
            if (b.testBit(1)) {
                k = -k;
            }
            a = a.negate();
        }
        while (a.signum() != 0) {
            v = ZERO;
            while (!a.testBit(0)) {
                v = v.add(ONE);
                a = a.divide(TWO);
            }
            if (v.testBit(0)) {
                k *= (long)jacobiTable[b.intValue() & 7];
            }
            if (a.compareTo(b) < 0) {
                BigInteger x = a;
                a = b;
                b = x;
                if (a.testBit(1) && b.testBit(1)) {
                    k = -k;
                }
            }
            a = a.subtract(b);
        }
        return b.equals(ONE) ? (int)k : 0;
    }

    public static BigInteger sqrtP(BigInteger a, BigInteger p) throws IllegalArgumentException {
        BigInteger v = null;
        if (a.compareTo(ZERO) < 0) {
            a = a.add(p);
        }
        if (a.equals(ZERO)) {
            return ZERO;
        }
        if (p.equals(TWO)) {
            return a;
        }
        if (p.testBit(0) && p.testBit(1)) {
            if (Arithmetic.jacobi(a, p) == 1) {
                v = p.add(ONE);
                v = v.shiftRight(2);
                return a.modPow(v, p);
            }
            throw new IllegalArgumentException("No quadratic residue: " + a + ", " + p);
        }
        long t = 0L;
        BigInteger k = p.subtract(ONE);
        long s = 0L;
        while (!k.testBit(0)) {
            ++s;
            k = k.shiftRight(1);
        }
        k = k.subtract(ONE);
        k = k.shiftRight(1);
        BigInteger r = a.modPow(k, p);
        BigInteger n = r.multiply(r).remainder(p);
        n = n.multiply(a).remainder(p);
        r = r.multiply(a).remainder(p);
        if (n.equals(ONE)) {
            return r;
        }
        BigInteger z = TWO;
        while (Arithmetic.jacobi(z, p) == 1) {
            z = z.add(ONE);
        }
        v = k;
        v = v.multiply(TWO);
        v = v.add(ONE);
        BigInteger c = z.modPow(v, p);
        while (n.compareTo(ONE) == 1) {
            k = n;
            t = s;
            s = 0L;
            while (!k.equals(ONE)) {
                k = k.multiply(k).mod(p);
                ++s;
            }
            if ((t -= s) == 0L) {
                throw new IllegalArgumentException("No quadratic residue: " + a + ", " + p);
            }
            v = ONE;
            for (long i = 0L; i < t - 1L; ++i) {
                v = v.shiftLeft(1);
            }
            c = c.modPow(v, p);
            r = r.multiply(c).remainder(p);
            c = c.multiply(c).remainder(p);
            n = n.multiply(c).mod(p);
        }
        return r;
    }

    public static BigInteger subP(BigInteger a, BigInteger b, BigInteger p) {
        if (a.compareTo(b) >= 0) {
            return a.subtract(b);
        }
        return a.add(p).subtract(b);
    }

    public static BigInteger divP(BigInteger a, BigInteger b, BigInteger p) {
        return a.multiply(b.modInverse(p)).mod(p);
    }
}

