/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.common;

import java.io.File;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.prefs.Preferences;

public class Config {
    public static boolean isWindows = System.getProperty("os.name").startsWith("Windows");
    private static ConcurrentHashMap<String, String> log = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, String> ekm = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, String> sdk = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, String> ekp = new ConcurrentHashMap();

    public static boolean getBool(String part, String name, boolean defaultValue) {
        String s = Config.getStr(part, name);
        if (s == null || s.isEmpty()) {
            return defaultValue;
        }
        return 0 == s.compareTo("1") || 0 == s.compareToIgnoreCase("true") || 0 == s.compareToIgnoreCase("yes") || 0 == s.compareToIgnoreCase("on");
    }

    public static boolean getBool(String part, String name) {
        return Config.getBool(part, name, false);
    }

    public static int getInt(String part, String name, int defaultValue) {
        String s = Config.getStr(part, name);
        if (s == null || s.isEmpty()) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static int getInt(String part, String name) {
        return Config.getInt(part, name, 0);
    }

    public static String getStr(String part, String name, String defaultValue) {
        ConcurrentHashMap<String, String> map = Config.getMap(part);
        String s = map.get(name);
        if (s == null) {
            if (isWindows) {
                s = WindowsRegistryHandle.readStr(part, name);
            } else {
                Config.readConfigUnix(part, map);
                s = map.get(name);
            }
            if (s == null) {
                s = defaultValue;
            }
            map.put(name, s);
        }
        return s;
    }

    public static String getStr(String part, String name) {
        return Config.getStr(part, name, "");
    }

    private static ConcurrentHashMap<String, String> getMap(String part) {
        if (0 == part.compareToIgnoreCase("log")) {
            return log;
        }
        if (0 == part.compareToIgnoreCase("ekm")) {
            return ekm;
        }
        if (0 == part.compareToIgnoreCase("sdk")) {
            return sdk;
        }
        if (0 == part.compareToIgnoreCase("ekp")) {
            return ekp;
        }
        throw new IllegalArgumentException("Unsupported configuration " + part);
    }

    private static void readConfigUnix(String part, ConcurrentHashMap<String, String> map) {
        String path = "/etc/ekm/client.conf";
        if (0 == part.compareToIgnoreCase("log")) {
            path = "/etc/dylog.conf";
        }
        if (0 == part.compareToIgnoreCase("ekp")) {
            path = "/etc/ekm/client.conf";
        }
        Map<String, String> temp = Config.readFile(path);
        map.putAll(temp);
    }

    public static Map<String, String> readFile(String path) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            Scanner input = new Scanner(new File(path));
            while (input.hasNextLine()) {
                String line = input.nextLine();
                if (line.isEmpty() || line.charAt(0) < 'A') continue;
                int equ = line.indexOf(61);
                if (equ < 0) {
                    equ = line.indexOf(58);
                }
                if (equ < 0) continue;
                String name = line.substring(0, equ).trim();
                String value = line.substring(equ + 1).trim();
                if (name.isEmpty() || value.isEmpty()) continue;
                map.put(name, value);
            }
            input.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return map;
    }

    private static final class WindowsRegistryHandle {
        private static final int HKEY_CURRENT_USER = -2147483647;
        private static final int HKEY_LOCAL_MACHINE = -2147483646;
        private static final int REG_SUCCESS = 0;
        private static final int KEY_READ = 131097;
        private static Preferences userRoot = Preferences.userRoot();
        private static Method regOpenKey = null;
        private static Method regCloseKey = null;
        private static Method regQueryValueEx = null;

        private WindowsRegistryHandle() {
        }

        private static byte[] toCstr(String str) {
            byte[] result = new byte[str.length() + 1];
            for (int i = 0; i < str.length(); ++i) {
                result[i] = (byte)str.charAt(i);
            }
            result[str.length()] = 0;
            return result;
        }

        private static Integer open(int hkey, String key) {
            int[] handles = null;
            try {
                handles = (int[])regOpenKey.invoke((Object)userRoot, hkey, WindowsRegistryHandle.toCstr(key), 131097);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (handles != null && handles[1] == false) {
                return (int)handles[0];
            }
            return null;
        }

        private static void close(Integer key) {
            try {
                regCloseKey.invoke((Object)userRoot, key);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private static String read(Integer key, String name) {
            try {
                byte[] valb = (byte[])regQueryValueEx.invoke((Object)userRoot, key, WindowsRegistryHandle.toCstr(name));
                if (valb == null || valb.length == 0) {
                    return null;
                }
                return new String(valb, StandardCharsets.UTF_8).trim();
            }
            catch (Exception e) {
                return null;
            }
        }

        static String readStr(String part, String name) {
            Integer machine;
            String path = "SOFTWARE\\DyadicSec\\" + part;
            Integer user = WindowsRegistryHandle.open(-2147483647, path);
            if (user != null) {
                String value = WindowsRegistryHandle.read(user, name);
                WindowsRegistryHandle.close(user);
                if (value != null) {
                    return value;
                }
            }
            if ((machine = WindowsRegistryHandle.open(-2147483646, path)) == null) {
                return null;
            }
            String value = WindowsRegistryHandle.read(machine, name);
            WindowsRegistryHandle.close(machine);
            return value;
        }

        static {
            try {
                Class<?> userClass = userRoot.getClass();
                regOpenKey = userClass.getDeclaredMethod("WindowsRegOpenKey", Integer.TYPE, byte[].class, Integer.TYPE);
                regOpenKey.setAccessible(true);
                regCloseKey = userClass.getDeclaredMethod("WindowsRegCloseKey", Integer.TYPE);
                regCloseKey.setAccessible(true);
                regQueryValueEx = userClass.getDeclaredMethod("WindowsRegQueryValueEx", Integer.TYPE, byte[].class);
                regQueryValueEx.setAccessible(true);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }
}

