/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.common;

import com.unbound.common.HEX;
import java.math.BigInteger;
import java.nio.BufferOverflowException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;

public final class Converter {
    private static HashMap<Long, Class<IConvertable>> codeTypes = new HashMap();
    private boolean write;
    private byte[] pointer;
    private int offset;
    private int length;

    public static void registerCodeType(Class clazz, long codeType) {
        codeTypes.put(codeType, clazz);
    }

    private static IConvertable dynamicCreate(byte[] binary, int offset) {
        Converter.checkLength(binary.length >= offset + 8);
        long codeType = Converter.getBE8(binary, offset);
        Class<IConvertable> clazz = codeTypes.get(codeType);
        if (clazz == null) {
            throw new IllegalArgumentException("Unknown IConvertable 0x" + HEX.toString(codeType));
        }
        IConvertable object = null;
        try {
            object = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("IConvertable newInstance error for " + clazz.getName(), e);
        }
        return object;
    }

    public <T extends IConvertable> T convert(T value) {
        if (!this.write) {
            value = Converter.dynamicCreate(this.pointer, this.offset);
        }
        value.convert(this);
        return value;
    }

    private Converter(boolean write, byte[] pointer) {
        this.write = write;
        this.pointer = pointer;
        this.offset = 0;
        this.length = pointer == null ? 0 : pointer.length;
    }

    Converter(byte[] pointer) {
        this(false, pointer);
    }

    Converter() {
        this(true, null);
    }

    void setPointer(byte[] pointer) {
        this.offset = 0;
        this.length = pointer.length;
        this.pointer = pointer;
    }

    public boolean isWrite() {
        return this.write;
    }

    public static void checkLength(boolean ok) {
        if (!ok) {
            throw new IllegalArgumentException("Convertor length error");
        }
    }

    public byte[] getPointer() {
        return this.pointer;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.write ? this.offset : this.length;
    }

    public void checkAtLeast(int n) {
        if (this.write) {
            return;
        }
        Converter.checkLength(this.length >= this.offset + n);
    }

    public void forward(int n) {
        this.checkAtLeast(n);
        this.offset += n;
    }

    public boolean convert(boolean value) {
        return 0 != this.convert((byte)(value ? 1 : 0));
    }

    public byte convert(byte value) {
        this.forward(1);
        if (this.write) {
            if (this.pointer != null) {
                this.pointer[this.offset - 1] = value;
            }
        } else {
            value = this.pointer[this.offset - 1];
        }
        return value;
    }

    public short convert(short value) {
        this.forward(2);
        if (this.write) {
            if (this.pointer != null) {
                Converter.setBE2(this.pointer, this.offset - 2, value);
            }
        } else {
            value = Converter.getBE2(this.pointer, this.offset - 2);
        }
        return value;
    }

    public int convert(int value) {
        this.forward(4);
        if (this.write) {
            if (this.pointer != null) {
                Converter.setBE4(this.pointer, this.offset - 4, value);
            }
        } else {
            value = Converter.getBE4(this.pointer, this.offset - 4);
        }
        return value;
    }

    public long convert(long value) {
        this.forward(8);
        if (this.write) {
            if (this.pointer != null) {
                Converter.setBE8(this.pointer, this.offset - 8, value);
            }
        } else {
            value = Converter.getBE8(this.pointer, this.offset - 8);
        }
        return value;
    }

    public int beginStruct() {
        int begin = this.offset;
        this.forward(2);
        return begin;
    }

    public void endStruct(int begin) {
        if (this.write) {
            if (this.pointer != null) {
                Converter.setBE2(this.pointer, begin, (short)(this.offset - begin - 2));
            }
        } else {
            short length = Converter.getBE2(this.pointer, begin);
            this.offset = begin;
            this.forward(length);
        }
    }

    public byte convertVersion(byte version) {
        return this.convert(version);
    }

    public String convert(String value) {
        byte[] encoded = null;
        short valueLength = 0;
        if (this.write && value != null) {
            encoded = value.getBytes(StandardCharsets.UTF_8);
            valueLength = (short)encoded.length;
        }
        valueLength = this.convert(valueLength);
        this.forward(valueLength);
        if (this.write) {
            if (this.pointer != null && encoded != null) {
                System.arraycopy(encoded, 0, this.pointer, this.offset - valueLength, valueLength);
            }
        } else {
            value = new String(this.pointer, this.offset - valueLength, (int)valueLength, StandardCharsets.UTF_8);
        }
        return value;
    }

    public int convertLen(int len) {
        short hi = 0;
        short lo = 0;
        if (this.write) {
            if (len < 32768) {
                lo = (short)len;
            } else {
                hi = (short)(len >> 16 | 0x8000);
                lo = (short)len;
                this.convert(hi);
            }
            this.convert(lo);
        } else if (((hi = this.convert(hi)) & 0x8000) != 0) {
            lo = this.convert(lo);
            len = (hi & Short.MAX_VALUE) << 16 | lo & 0xFFFF;
        } else {
            len = hi;
        }
        return len;
    }

    public byte[] convert(byte[] value) {
        int valueLength = value != null ? value.length : 0;
        valueLength = this.convertLen(valueLength);
        this.forward(valueLength);
        if (this.write) {
            if (this.pointer != null && value != null) {
                System.arraycopy(value, 0, this.pointer, this.offset - valueLength, valueLength);
            }
        } else {
            value = Arrays.copyOfRange(this.pointer, this.offset - valueLength, this.offset);
        }
        return value;
    }

    public BigInteger convert(BigInteger value) {
        if (this.write) {
            byte sign = (byte)value.signum();
            this.convert(sign);
            byte[] bytes = (sign >= 0 ? value : value.negate()).toByteArray();
            this.convert(bytes);
        } else {
            byte sign = this.convert((byte)0);
            byte[] bytes = this.convert((byte[])null);
            value = new BigInteger((int)sign, bytes);
        }
        return value;
    }

    public static short getBE2(byte[] in, int offset) {
        return (short)((short)in[offset + 0] << 8 | in[offset + 1] & 0xFF);
    }

    public static short getLE2(byte[] in, int offset) {
        return (short)((short)in[offset + 1] << 8 | in[offset + 0] & 0xFF);
    }

    public static int getBE4(byte[] in, int offset) {
        return Converter.getBE2(in, offset + 0) << 16 | Converter.getBE2(in, offset + 2) & 0xFFFF;
    }

    public static int getLE4(byte[] in, int offset) {
        return Converter.getLE2(in, offset + 2) << 16 | Converter.getLE2(in, offset + 0) & 0xFFFF;
    }

    public static long getBE8(byte[] in, int offset) {
        return (long)Converter.getBE4(in, offset + 0) << 32 | (long)(Converter.getBE4(in, offset + 4) & 0xFFFFFFFF);
    }

    public static long getLE8(byte[] in, int offset) {
        return (long)Converter.getLE4(in, offset + 4) << 16 | (long)(Converter.getLE4(in, offset + 0) & 0xFFFFFFFF);
    }

    public static void setBE2(byte[] out, int offset, short v) {
        out[offset + 0] = (byte)(v >> 8);
        out[offset + 1] = (byte)v;
    }

    public static void setLE2(byte[] out, int offset, short v) {
        out[offset + 1] = (byte)(v >> 8);
        out[offset + 0] = (byte)v;
    }

    public static void setBE4(byte[] out, int offset, int v) {
        Converter.setBE2(out, offset + 0, (short)(v >> 16));
        Converter.setBE2(out, offset + 2, (short)v);
    }

    public static void setLE4(byte[] out, int offset, int v) {
        Converter.setLE2(out, offset + 2, (short)(v >> 16));
        Converter.setLE2(out, offset + 0, (short)v);
    }

    public static void setBE8(byte[] out, int offset, long v) {
        Converter.setBE4(out, offset + 0, (int)(v >> 32));
        Converter.setBE4(out, offset + 4, (int)v);
    }

    public static void setLE8(byte[] out, int offset, long v) {
        Converter.setLE4(out, offset + 4, (int)(v >> 32));
        Converter.setLE4(out, offset + 0, (int)v);
    }

    public static int bigNumSize(BigInteger in) {
        return in.bitLength() / 8;
    }

    public static void bigNumToBin(BigInteger in, byte[] out, int offset, int length) {
        byte[] bin = in.toByteArray();
        int binLength = bin.length;
        int padding = binLength > 0 && bin[0] == 0 ? 1 : 0;
        binLength -= padding;
        if (length < 0) {
            length = binLength;
        } else if (length < binLength) {
            throw new BufferOverflowException();
        }
        int outPadding = binLength - length;
        for (int i = 0; i < outPadding; ++i) {
            out[offset++] = 0;
        }
        System.arraycopy(bin, padding, out, offset, binLength);
    }

    public static byte[] bigNumToBin(BigInteger in, int length) {
        if (length < 0) {
            length = Converter.bigNumSize(in);
        }
        byte[] out = new byte[length];
        Converter.bigNumToBin(in, out, 0, length);
        return out;
    }

    public static byte[] bigNumToBin(BigInteger in) {
        return Converter.bigNumToBin(in, -1);
    }

    public static BigInteger binToBigNum(byte[] in) {
        return Converter.binToBigNum(in, 0, in.length);
    }

    public static BigInteger binToBigNum(byte[] in, int offset, int length) {
        if (offset != 0 || length != in.length) {
            in = Arrays.copyOfRange(in, offset, offset + length);
        }
        return new BigInteger(1, in);
    }

    public static interface IConvertable {
        public void convert(Converter var1);
    }
}

