/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.common;

import com.unbound.common.Config;
import com.unbound.common.Converter;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.HashMap;
import javax.crypto.ShortBufferException;

public class Log {
    private static boolean enabled = false;
    private static Log disabled = new DisabledLog();
    private static final ThreadLocal<Log> thread = new ThreadLocal();
    private static Clock clock = Clock.systemUTC();
    private static final int DYLOG_SIGNATURE = 1854372641;
    private static final int DYLOG_BLOCK_CONTROL = 0;
    private static final int DYLOG_BLOCK_ENTER = 1;
    private static final int DYLOG_BLOCK_LEAVE = 2;
    private static final int DYLOG_BLOCK_PRINT = 3;
    private static final int DYLOG_CTRL_STRING = 0;
    private static final int DYLOG_CTRL_LABEL = 1;
    private static final int DYLOG_DEC = 0;
    private static final int DYLOG_HEX = 1;
    private static final int DYLOG_CHARS = 2;
    private static final int DYLOG_ARR_1 = 3;
    private static final int DYLOG_ARR_2 = 4;
    private static final int DYLOG_ARR_4 = 5;
    private static final int DYLOG_CHARS_ID = 6;
    private static String dir;
    private static long pid;
    private FileOutputStream file;
    private long timerMs;
    private HashMap<String, Integer> strings = new HashMap();
    private byte[] paramsBuf = new byte[64];
    private int paramsLength = 0;
    private int stringsCount = 0;
    private byte[] tempBuf = new byte[32];
    private int tempBufLength = 0;
    private int printId = 0;
    private int funcId = 0;
    private Exception failed = null;
    private static final int E_GENERAL = -16711679;
    private static final int E_BADARG = -16711678;
    private static final int E_TOO_SMALL = -16711672;

    public static Log func(String name) {
        Log log = Log.getInstance();
        log.beginFunc(name);
        return log;
    }

    public void failed(Exception e) {
        this.failed = e;
    }

    public Log leavePrint() {
        if (this.failed == null) {
            return this;
        }
        String message = this.failed.getMessage();
        if (message == null) {
            message = this.failed.toString();
        }
        this.log("Error", message);
        this.end();
        return disabled;
    }

    public void leave() {
        this.leavePrint().end();
    }

    public static Log print(String label) {
        Log log = Log.getInstance();
        log.beginPrint(label);
        return log;
    }

    public Log log(String name, boolean value) {
        return this.logLong(name, value ? 1L : 0L, false);
    }

    public Log log(String name, long value) {
        return this.logLong(name, value, false);
    }

    public Log logHex(String name, long value) {
        return this.logLong(name, value, true);
    }

    public Log log(String name, int value) {
        return this.logLong(name, (long)value & 0xFFFFFFFFL, false);
    }

    public Log logHex(String name, int value) {
        return this.logLong(name, (long)value & 0xFFFFFFFFL, true);
    }

    public Log log(String name, short value) {
        return this.logLong(name, (long)value & 0xFFFFL, false);
    }

    public Log logHex(String name, short value) {
        return this.logLong(name, (long)value & 0xFFFFL, true);
    }

    public Log log(String name, byte value) {
        return this.logLong(name, (long)value & 0xFFL, false);
    }

    public Log logHex(String name, byte value) {
        return this.logLong(name, (long)value & 0xFFL, true);
    }

    public Log log(String name, String value) {
        if (!enabled) {
            return disabled;
        }
        byte[] bytes = value == null ? null : value.getBytes(StandardCharsets.UTF_8);
        return this.logBytes(name, bytes, true);
    }

    public Log log(String name, byte[] value) {
        return this.logBytes(name, value, false);
    }

    protected void init() throws Exception {
        String path = dir + "/java_P" + pid + "_T" + Thread.currentThread().getId() + ".dylog";
        this.file = new FileOutputStream(path);
        Instant now = Instant.now();
        ZoneOffset offset = ZoneOffset.systemDefault().getRules().getOffset(now);
        long localTimeMs = now.toEpochMilli() + (long)(offset.getTotalSeconds() * 1000);
        this.timerMs = clock.millis();
        this.outLabel(localTimeMs);
    }

    private void setParamsCapacity(int capacity) {
        if (capacity <= this.paramsLength) {
            return;
        }
        if (capacity < this.paramsLength * 2) {
            capacity = this.paramsLength * 2;
        }
        byte[] newBuf = new byte[capacity];
        System.arraycopy(this.paramsBuf, 0, newBuf, 0, this.paramsLength);
        this.paramsBuf = newBuf;
    }

    private static int getValueLengthCode(int value) {
        if (value < 0) {
            return 3;
        }
        if (value == 0) {
            return 0;
        }
        if (value <= 255) {
            return 1;
        }
        if (value <= 65535) {
            return 2;
        }
        return 3;
    }

    private void outByte(byte value) {
        this.tempBuf[this.tempBufLength++] = value;
    }

    private void outValue(int value) {
        if (value < 0 || value >= 65536) {
            this.outByte((byte)(value >> 24));
            this.outByte((byte)(value >> 16));
        }
        if (value < 0 || value >= 256) {
            this.outByte((byte)(value >> 8));
        }
        if (value != 0) {
            this.outByte((byte)value);
        }
    }

    private void outBlockHeader(int code, int length, int id, int timer) {
        byte header = (byte)(code << 6 | Log.getValueLengthCode(length) << 4 | Log.getValueLengthCode(id) << 2 | Log.getValueLengthCode(timer));
        this.tempBufLength = 0;
        this.outByte(header);
        this.outValue(length);
        this.outValue(id);
        this.outValue(timer);
        this.out(this.tempBuf, this.tempBufLength);
    }

    private void out(byte[] in, int length) {
        try {
            this.file.write(in, 0, length);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void outLabel(long localTimeMs) {
        this.outBlockHeader(0, 8, 1, 1854372641);
        Converter.setBE8(this.tempBuf, 0, localTimeMs);
        this.out(this.tempBuf, 8);
    }

    private void outString(String str) {
        byte[] data = str.getBytes(StandardCharsets.UTF_8);
        this.outBlockHeader(0, data.length, 0, 0);
        this.out(data, data.length);
    }

    private void outFuncEnter(long newTimerMs, int id) {
        this.outBlockHeader(1, this.paramsLength, id, (int)(newTimerMs - this.timerMs));
        this.out(this.paramsBuf, this.paramsLength);
    }

    private void outFuncLeave(long newTimerMs, int rv) {
        this.outBlockHeader(2, this.paramsLength, rv, (int)(newTimerMs - this.timerMs));
        this.out(this.paramsBuf, this.paramsLength);
    }

    private void outPrint(long newTimerMs, int id) {
        this.outBlockHeader(3, this.paramsLength, id, (int)(newTimerMs - this.timerMs));
        this.out(this.paramsBuf, this.paramsLength);
    }

    private int getStringId(String str) {
        Integer i = this.strings.get(str);
        if (i != null) {
            return i;
        }
        ++this.stringsCount;
        this.strings.put(str, this.stringsCount);
        this.outString(str);
        return this.stringsCount;
    }

    private void cleanParams() {
        this.paramsLength = 0;
    }

    private static Log getInstance() {
        if (!enabled) {
            return disabled;
        }
        Log log = thread.get();
        if (log == null) {
            log = new Log();
            try {
                log.init();
            }
            catch (Exception e) {
                log = disabled;
            }
            thread.set(log);
        }
        return log;
    }

    protected void beginFunc(String name) {
        this.funcId = this.getStringId(name);
    }

    protected void beginPrint(String label) {
        this.printId = this.getStringId(label);
    }

    public Log end() {
        long newTimerMs = clock.millis();
        if (this.funcId != 0) {
            this.outFuncEnter(newTimerMs, this.funcId);
            this.funcId = 0;
        } else if (this.printId != 0) {
            this.outPrint(newTimerMs, this.printId);
            this.printId = 0;
        } else {
            this.outFuncLeave(newTimerMs, Log.exceptionToRv(this.failed));
        }
        this.failed = null;
        this.timerMs = newTimerMs;
        this.cleanParams();
        return this;
    }

    private int getParamLengthCode(int length) {
        if (length <= 5) {
            return length;
        }
        if (length <= 255) {
            return 6;
        }
        return 7;
    }

    private int getParamValueLength(long value) {
        int length = 0;
        while (value != 0L) {
            ++length;
            value >>>= 8;
        }
        return length;
    }

    private void outParamValue(long value) {
        int length = 0;
        while (value != 0L) {
            this.tempBuf[length++] = (byte)value;
            value >>>= 8;
        }
        while (length != 0) {
            this.paramsBuf[this.paramsLength++] = this.tempBuf[--length];
        }
    }

    private void outParamByte(byte value) {
        this.setParamsCapacity(this.paramsLength + 1);
        this.paramsBuf[this.paramsLength++] = value;
    }

    private void outParamHeader(int code, int length, int id) {
        int paramLengthCode = this.getParamLengthCode(length);
        int idLengthCode = Log.getValueLengthCode(id);
        byte header = (byte)(code << 5 | paramLengthCode << 2 | idLengthCode);
        this.outParamByte(header);
        if (length > 5) {
            if (length >= 255) {
                this.outParamByte((byte)(length >> 8));
            }
            this.outParamByte((byte)length);
        }
        if (id > 65535 || id < 0) {
            this.outParamByte((byte)(id >> 24));
            this.outParamByte((byte)(length >> 16));
        }
        if (id > 255) {
            this.outParamByte((byte)(id >> 8));
        }
        if (id > 0) {
            this.outParamByte((byte)id);
        }
    }

    private Log logLong(String name, long value, boolean hex) {
        int id = this.getStringId(name);
        if (value == 0L) {
            hex = false;
        }
        int code = hex ? 1 : 0;
        int outLength = this.getParamValueLength(value);
        this.outParamHeader(code, outLength, id);
        this.setParamsCapacity(this.paramsLength + outLength);
        this.outParamValue(value);
        return this;
    }

    private Log logBytes(String name, byte[] value, boolean chars) {
        if (value == null) {
            return this.logLong(name, 0L, false);
        }
        int id = this.getStringId(name);
        int code = chars ? 2 : 3;
        this.outParamHeader(code, value.length, id);
        this.setParamsCapacity(this.paramsLength + value.length);
        System.arraycopy(value, 0, this.paramsBuf, this.paramsLength, value.length);
        this.paramsLength += value.length;
        return this;
    }

    public Log log(String name, short[] value) {
        if (value == null) {
            return this.logLong(name, 0L, false);
        }
        int id = this.getStringId(name);
        this.outParamHeader(4, value.length * 2, id);
        this.setParamsCapacity(this.paramsLength + value.length * 2);
        for (short v : value) {
            this.paramsBuf[this.paramsLength++] = (byte)(v >> 8);
            this.paramsBuf[this.paramsLength++] = (byte)v;
        }
        return this;
    }

    public Log log(String name, int[] value) {
        if (value == null) {
            return this.logLong(name, 0L, false);
        }
        int id = this.getStringId(name);
        this.outParamHeader(5, value.length * 4, id);
        this.setParamsCapacity(this.paramsLength + value.length * 4);
        for (int v : value) {
            this.paramsBuf[this.paramsLength++] = (byte)(v >> 24);
            this.paramsBuf[this.paramsLength++] = (byte)(v >> 16);
            this.paramsBuf[this.paramsLength++] = (byte)(v >> 8);
            this.paramsBuf[this.paramsLength++] = (byte)v;
        }
        return this;
    }

    public Log log(String name, char[] value) {
        if (value == null) {
            return this.logLong(name, 0L, false);
        }
        int id = this.getStringId(name);
        this.outParamHeader(2, value.length, id);
        this.setParamsCapacity(this.paramsLength + value.length);
        for (char v : value) {
            this.paramsBuf[this.paramsLength++] = (byte)v;
        }
        return this;
    }

    private static int exceptionToRv(Exception e) {
        if (e == null) {
            return 0;
        }
        if (e instanceof IllegalArgumentException) {
            return -16711678;
        }
        if (e instanceof ShortBufferException) {
            return -16711672;
        }
        return -16711679;
    }

    static {
        try {
            String e = System.getenv("DYLOG_ENABLED");
            boolean bl = enabled = e != null && 0 == e.compareTo("1");
            if (enabled) {
                RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
                String root = Config.isWindows ? "C:\\Windows\\Temp" : "/tmp";
                dir = root + "/dy.log";
                new File(dir).mkdirs();
                String jvmName = runtime.getName();
                pid = Long.parseLong(jvmName.split("@")[0]);
            }
        }
        catch (Exception e) {
            enabled = false;
        }
    }

    private static final class DisabledLog
    extends Log {
        private DisabledLog() {
        }

        @Override
        public void failed(Exception e) {
        }

        @Override
        public Log log(String name, long value) {
            return this;
        }

        @Override
        public Log logHex(String name, long value) {
            return this;
        }

        @Override
        public Log log(String name, int value) {
            return this;
        }

        @Override
        public Log log(String name, boolean value) {
            return this;
        }

        @Override
        public Log log(String name, short value) {
            return this;
        }

        @Override
        public Log log(String name, byte value) {
            return this;
        }

        @Override
        public Log logHex(String name, short value) {
            return this;
        }

        @Override
        public Log logHex(String name, byte value) {
            return this;
        }

        @Override
        public Log logHex(String name, int value) {
            return this;
        }

        @Override
        public Log log(String name, byte[] value) {
            return this;
        }

        @Override
        public Log log(String name, short[] value) {
            return this;
        }

        @Override
        public Log log(String name, int[] value) {
            return this;
        }

        @Override
        public Log log(String name, char[] value) {
            return this;
        }

        @Override
        public Log log(String name, String value) {
            return this;
        }

        @Override
        protected void beginPrint(String label) {
        }

        @Override
        protected void beginFunc(String name) {
        }

        @Override
        public Log leavePrint() {
            return this;
        }

        @Override
        public Log end() {
            return this;
        }
    }
}

