/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.common.crypto;

import com.unbound.common.crypto.SystemProvider;
import java.security.Key;
import javax.crypto.AEADBadTagException;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class AES {
    private Cipher cipher;
    byte[] key;

    public AES(byte[] key) {
        this.key = key;
        this.cipher = SystemProvider.Cipher.getInstance("AES/ECB/NoPadding");
    }

    private void checkInit(int mode) {
        try {
            if (this.key != null) {
                this.cipher.init(mode, new SecretKeySpec(this.key, "AES"));
                this.key = null;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public byte[] encrypt(byte[] in) {
        this.checkInit(1);
        return this.cipher.update(in);
    }

    public AES encrypt(byte[] in, int inOffset, int inLength, byte[] out, int outOffset) {
        try {
            this.checkInit(1);
            this.cipher.update(in, inOffset, inLength, out, outOffset);
            return this;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public byte[] decrypt(byte[] in) {
        this.checkInit(2);
        return this.cipher.update(in);
    }

    public AES decrypt(byte[] in, int inOffset, int inLength, byte[] out, int outOffset) {
        try {
            this.checkInit(2);
            this.cipher.update(in, inOffset, inLength, out, outOffset);
            return this;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    static byte[] encrypt(byte[] key, byte[] in) {
        return new AES(key).encrypt(in);
    }

    static byte[] decrypt(byte[] key, byte[] in) {
        return new AES(key).decrypt(in);
    }

    public static final class GCM {
        public static byte[] encrypt(byte[] key, byte[] iv, int tagLen, byte[] in) {
            try {
                byte[] out = new byte[in.length + tagLen];
                GCMParameterSpec params = new GCMParameterSpec(tagLen * 8, iv);
                Cipher cipher = SystemProvider.Cipher.getInstance("AES/GCM/NoPadding");
                cipher.init(1, (Key)new SecretKeySpec(key, "AES"), params);
                int tempSize = cipher.update(in, 0, in.length, out, 0);
                cipher.doFinal(out, tempSize);
                return out;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }

        public static byte[] decrypt(byte[] key, byte[] iv, int tagLen, byte[] in) throws AEADBadTagException {
            try {
                byte[] out = new byte[in.length - tagLen];
                GCMParameterSpec params = new GCMParameterSpec(tagLen * 8, iv);
                Cipher cipher = SystemProvider.Cipher.getInstance("AES/GCM/NoPadding");
                cipher.init(2, (Key)new SecretKeySpec(key, "AES"), params);
                int tempSize = cipher.update(in, 0, in.length, out, 0);
                cipher.doFinal(out, tempSize);
                return out;
            }
            catch (AEADBadTagException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
    }
}

