/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.common.crypto;

import com.unbound.common.HEX;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Stack;

public final class DER {
    public static final byte TAG_BOOLEAN = 1;
    public static final byte TAG_INTEGER = 2;
    public static final byte TAG_BIT_STRING = 3;
    public static final byte TAG_OCTET_STRING = 4;
    public static final byte TAG_NULL = 5;
    public static final byte TAG_OID = 6;
    public static final byte TAG_EXTERNAL = 8;
    public static final byte TAG_ENUMERATED = 10;
    public static final byte TAG_SEQUENCE = 48;
    public static final byte TAG_SET = 49;
    public static final byte TAG_UTF8_STRING = 12;
    public static final byte TAG_NUMERIC_STRING = 18;
    public static final byte TAG_PRINTABLE_STRING = 19;
    public static final byte TAG_T61_STRING = 20;
    public static final byte TAG_VIDEOTEX_STRING = 21;
    public static final byte TAG_IA5_STRING = 22;
    public static final byte TAG_UTC_TIME = 23;
    public static final byte TAG_GENERALIZED_TIME = 24;
    public static final byte TAG_GRAPHIC_STRING = 25;
    public static final byte TAG_VISIBLE_STRING = 26;
    public static final byte TAG_GENERAL_STRING = 27;
    public static final byte TAG_UNIVERSAL_STRING = 28;
    public static final byte TAG_BMP_STRING = 30;

    private DER() {
    }

    private static void checkLength(boolean ok) {
        if (!ok) {
            throw new IllegalArgumentException("DER length error");
        }
    }

    private static void checkTag(byte expected, byte tag) {
        if (expected != tag) {
            throw new IllegalArgumentException("Unexpected DER tag " + HEX.toString(tag));
        }
    }

    private static int lengthOfInt(int length) {
        if (length <= 127) {
            return 1;
        }
        if (length <= Short.MAX_VALUE) {
            return 2;
        }
        if (length <= 0x7FFFFF) {
            return 3;
        }
        if (length > 0) {
            return 4;
        }
        return 5;
    }

    private static int lengthOfLength(int length) {
        if (length < 128) {
            return 1;
        }
        return 1 + DER.lengthOfInt(length);
    }

    public static final class Builder {
        private byte[] bytes = new byte[128];
        private int length = 0;
        private Stack<Integer> stack = new Stack();

        public Builder begin(byte tag) {
            int padding = tag == 3 ? 1 : 0;
            this.ensureCapacity(this.length + 2 + padding);
            this.stack.push(this.length);
            this.bytes[this.length++] = tag;
            this.length += 1 + padding;
            return this;
        }

        public byte[] toByteArray() {
            if (this.length == this.bytes.length) {
                return this.bytes;
            }
            return Arrays.copyOfRange(this.bytes, 0, this.length);
        }

        private void ensureCapacity(int capacity) {
            if (capacity <= this.bytes.length) {
                return;
            }
            if (capacity < this.bytes.length * 2) {
                capacity = this.bytes.length * 2;
            }
            byte[] newBytes = new byte[capacity];
            System.arraycopy(this.bytes, 0, newBytes, 0, this.length);
            this.bytes = newBytes;
        }

        private void encodeLength(int offset, int length) {
            if (length < 128) {
                this.bytes[offset] = (byte)length;
            } else {
                int l = DER.lengthOfInt(length);
                this.bytes[offset] = (byte)(0x80 | l);
                this.encodeInt(offset + 1, length);
            }
        }

        private void encodeInt(int offset, int value) {
            if (value < 0) {
                value = 0;
            }
            int l = DER.lengthOfInt(value);
            offset += l;
            while (value != 0) {
                this.bytes[--offset] = (byte)value;
                value >>>= 8;
            }
        }

        public Builder add(byte tag, byte[] data) {
            return this.add(tag, data, 0, data == null ? 0 : data.length);
        }

        private Builder add(byte tag, byte[] in, int inOffset, int inLength) {
            int padding = tag == 3 ? 1 : 0;
            int l = DER.lengthOfLength(padding + inLength);
            this.ensureCapacity(this.length + 1 + l + padding + inLength);
            this.bytes[this.length++] = tag;
            this.encodeLength(this.length, padding + inLength);
            this.length += l;
            if (padding != 0) {
                this.bytes[this.length++] = 0;
            }
            if (inLength > 0) {
                System.arraycopy(in, inOffset, this.bytes, this.length, inLength);
            }
            this.length += inLength;
            return this;
        }

        public Builder end() {
            int blockLength;
            int l;
            int offset = this.stack.pop();
            if ((l = DER.lengthOfLength(blockLength = this.length - ++offset - 1)) == 1) {
                this.bytes[offset] = (byte)blockLength;
            } else {
                this.ensureCapacity(this.length + l - 1);
                System.arraycopy(this.bytes, offset + 1, this.bytes, offset + l, blockLength);
                this.encodeLength(offset, blockLength);
                this.length += l - 1;
            }
            return this;
        }

        public Builder beginSet() {
            return this.begin((byte)49);
        }

        public Builder beginSequence() {
            return this.begin((byte)48);
        }

        public Builder beginOctetString() {
            return this.begin((byte)4);
        }

        public Builder beginBitString() {
            return this.begin((byte)3);
        }

        public Builder addBitString(byte[] in) {
            return this.add((byte)3, in);
        }

        public Builder addNull() {
            return this.add((byte)5, (byte[])null);
        }

        public Builder add(BigInteger bn) {
            return this.add((byte)2, bn.toByteArray());
        }

        public Builder addInteger(long value) {
            return this.add((byte)2, BigInteger.valueOf(value).toByteArray());
        }

        public Builder add(byte tag, String value) {
            Charset charset = StandardCharsets.UTF_8;
            switch (tag) {
                case 18: 
                case 19: 
                case 20: 
                case 22: 
                case 23: 
                case 24: 
                case 26: {
                    charset = StandardCharsets.US_ASCII;
                    break;
                }
                case 30: {
                    charset = StandardCharsets.ISO_8859_1;
                    break;
                }
                case 28: {
                    charset = Charset.forName("UTF-32");
                    break;
                }
                case 12: {
                    charset = StandardCharsets.UTF_8;
                    break;
                }
                default: {
                    charset = StandardCharsets.US_ASCII;
                }
            }
            return this.add(tag, value.getBytes(charset));
        }

        public Builder add(String value) {
            return this.add((byte)12, value);
        }

        public Builder addOid(String oid) {
            this.ensureCapacity(this.length + oid.length());
            this.bytes[this.length++] = 6;
            ++this.length;
            int oldLength = this.length;
            int value = 0;
            int index = 0;
            int firstValue = 0;
            for (int i = 0; i <= oid.length(); ++i) {
                int c;
                int n = c = i == oid.length() ? 46 : (int)oid.charAt(i);
                if (c >= 48 && c <= 57) {
                    value = value * 10 + c - 48;
                    continue;
                }
                if (c == 46) {
                    if (value >= 128) {
                        int v1 = value >> 21 & 0x7F;
                        if (v1 != 0) {
                            this.bytes[this.length++] = (byte)(v1 | 0x80);
                        }
                        int v2 = value >> 14 & 0x7F;
                        if (v1 != 0 || v2 != 0) {
                            this.bytes[this.length++] = (byte)(v2 | 0x80);
                        }
                        int v3 = value >> 7 & 0x7F;
                        if (v1 != 0 || v2 != 0 || v3 != 0) {
                            this.bytes[this.length++] = (byte)(v3 | 0x80);
                        }
                        value &= 0x7F;
                    }
                    if (index == 0) {
                        firstValue = value;
                    } else {
                        this.bytes[this.length++] = index == 1 ? (byte)(firstValue * 40 + value) : (byte)value;
                    }
                    value = 0;
                    ++index;
                    continue;
                }
                throw new IllegalArgumentException("Invalid OID " + oid);
            }
            this.bytes[oldLength - 1] = (byte)(this.length - oldLength);
            return this;
        }
    }

    public static final class Parser {
        private byte[] bytes;
        private int offset;
        private Stack<Integer> stack = new Stack();
        private int blockEnd = 0;

        public Parser(byte[] bytes) {
            this.bytes = bytes;
            this.blockEnd = bytes.length;
        }

        private byte getTag() {
            DER.checkLength(this.offset < this.blockEnd);
            return this.bytes[this.offset];
        }

        private int parseLength() {
            DER.checkLength(this.offset < this.blockEnd);
            int length = this.bytes[this.offset++] & 0xFF;
            if (length >= 128) {
                int l = length & 0x7F;
                DER.checkLength(l <= 4);
                DER.checkLength(this.offset + l <= this.blockEnd);
                length = 0;
                for (int i = 0; i < l; ++i) {
                    length = length << 8 | this.bytes[this.offset++] & 0xFF;
                }
            }
            DER.checkLength(this.offset + length <= this.blockEnd);
            return length;
        }

        private int parseTag(byte tag) {
            DER.checkLength(this.offset + 2 <= this.blockEnd);
            DER.checkTag(tag, this.bytes[this.offset++]);
            return this.parseLength();
        }

        public void begin(byte tag) {
            int length = this.parseTag(tag);
            this.stack.push(this.blockEnd);
            this.blockEnd = this.offset + length;
        }

        public void beginSequence() {
            this.begin((byte)48);
        }

        public void beginSet() {
            this.begin((byte)49);
        }

        public void end() {
            DER.checkLength(this.offset == this.blockEnd);
            this.blockEnd = this.stack.pop();
        }

        public boolean endOfBlock() {
            return this.offset == this.blockEnd;
        }

        public BigInteger parseBigInteger() {
            int length = this.parseTag((byte)2);
            this.offset += length;
            return new BigInteger(Arrays.copyOfRange(this.bytes, this.offset - length, length));
        }

        public String parseOid() {
            int length = this.parseTag((byte)6);
            int end = this.offset + length;
            int item = this.bytes[this.offset++] & 0xFF;
            StringBuilder sb = new StringBuilder();
            sb.append(item / 40);
            sb.append('.');
            sb.append(item % 40);
            while (this.offset < end) {
                sb.append('.');
                long value = 0L;
                do {
                    item = this.bytes[this.offset++] & 0xFF;
                    value = (value << 7) + (long)(item & 0x7F);
                } while ((item & 0x80) != 0);
                sb.append(value);
            }
            return sb.toString();
        }

        public String parseString() {
            byte tag = this.getTag();
            Charset charset = null;
            switch (tag) {
                case 18: 
                case 19: 
                case 20: 
                case 22: 
                case 23: 
                case 24: 
                case 26: {
                    charset = StandardCharsets.US_ASCII;
                    break;
                }
                case 30: {
                    charset = StandardCharsets.ISO_8859_1;
                    break;
                }
                case 28: {
                    charset = Charset.forName("UTF-32");
                    break;
                }
                case 12: {
                    charset = StandardCharsets.UTF_8;
                    break;
                }
                default: {
                    DER.checkTag((byte)12, tag);
                }
            }
            int length = this.parseTag(tag);
            this.offset += length;
            return new String(this.bytes, this.offset - length, length, charset);
        }
    }
}

