/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.common.crypto;

import com.unbound.common.STR;
import com.unbound.common.crypto.SystemProvider;
import javax.crypto.Mac;

public class HMAC {
    private Mac mac;

    protected HMAC(String type, byte[] key) {
        this.mac = SystemProvider.Mac.getInstance(type);
    }

    public byte[] end() {
        return this.mac.doFinal();
    }

    public HMAC update(byte[] in) {
        this.mac.update(in);
        return this;
    }

    public HMAC update(String in) {
        this.mac.update(STR.utf8(in));
        return this;
    }

    public static final class SHA512
    extends HMAC {
        public SHA512(byte[] key) {
            super("HmacSHA512", key);
        }

        public static byte[] hmac(byte[] key, byte[] in) {
            return new SHA512(key).update(in).end();
        }

        public static byte[] hmac(byte[] key, String in) {
            return new SHA512(key).update(in).end();
        }
    }

    public static final class SHA256
    extends HMAC {
        public SHA256(byte[] key) {
            super("HmacSHA256", key);
        }

        public static byte[] hmac(byte[] key, byte[] in) {
            return new SHA256(key).update(in).end();
        }

        public static byte[] hmac(byte[] key, String in) {
            return new SHA256(key).update(in).end();
        }
    }
}

