/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.common.crypto;

import com.unbound.common.crypto.DER;
import com.unbound.common.crypto.RSA;
import com.unbound.common.crypto.X509;
import java.net.InetAddress;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.HashMap;
import java.util.Map;

public class PKCS10 {
    private RSAPublicKey publicKey;
    private String[] dns;
    private InetAddress[] ip;
    private String challengePassword;
    private byte[] signature;
    private String signHashOid;
    private Map<String, String> subject = new HashMap<String, String>();

    public PKCS10(RSAPublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public void setAlternativeSubjectName(String[] dns, InetAddress[] ip) {
        this.dns = dns;
        this.ip = ip;
    }

    public void setSubjectName(String type, String name) {
        this.subject.put(type, name);
    }

    public void setChallengePassword(String challengePassword) {
        this.challengePassword = challengePassword;
    }

    public void sign(RSAPrivateKey key, String hashType) {
        if (hashType.equals("SHA256")) {
            this.signHashOid = "1.2.840.113549.1.1.11";
        } else if (hashType.equals("SHA1")) {
            this.signHashOid = "1.2.840.113549.1.1.5";
        } else {
            throw new IllegalArgumentException("Unsupported hash type");
        }
        this.signature = RSA.signPkcs1(key, hashType, this.toBeSigned());
    }

    private DER.Builder encodeCertificationRequestInfo(DER.Builder builder) {
        builder.beginSequence().addInteger(0L);
        X509.encode(builder, this.subject).beginSequence().beginSequence().addOid("1.2.840.113549.1.1.1").addNull().end().beginBitString().beginSequence().add(this.publicKey.getModulus()).add(this.publicKey.getPublicExponent()).end().end().end();
        if (this.challengePassword != null || this.dns != null || this.ip != null) {
            builder.begin((byte)-96);
            if (this.dns != null || this.ip != null) {
                builder.beginSequence().addOid("1.2.840.113549.1.9.14").beginSet().beginSequence().beginSequence().addOid("2.5.29.17").beginOctetString().beginSequence();
                if (this.dns != null) {
                    for (String s : this.dns) {
                        builder.add((byte)-126, s);
                    }
                }
                if (this.ip != null) {
                    for (InetAddress i : this.ip) {
                        builder.add((byte)-121, i.getAddress());
                    }
                }
                builder.end().end().end().end().end().end();
            }
            if (this.challengePassword != null) {
                builder.beginSequence().addOid("1.2.840.113549.1.9.7").beginSet().add((byte)19, this.challengePassword).end().end();
            }
            builder.end();
        }
        return builder.end();
    }

    private byte[] toBeSigned() {
        return this.encodeCertificationRequestInfo(new DER.Builder()).toByteArray();
    }

    public byte[] exportDer() {
        DER.Builder builder = new DER.Builder();
        builder.beginSequence();
        this.encodeCertificationRequestInfo(builder).beginSequence().addOid(this.signHashOid).addNull().end().addBitString(this.signature).end();
        return builder.toByteArray();
    }
}

