/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.common.crypto;

import com.unbound.common.STR;
import com.unbound.common.crypto.SystemProvider;
import java.security.MessageDigest;

public final class SHA256 {
    private MessageDigest md = SystemProvider.MessageDigest.getInstance("SHA-256");

    public SHA256 update(byte[] in) {
        this.md.update(in);
        return this;
    }

    public SHA256 update(byte[] in, int offset, int length) {
        this.md.update(in, offset, length);
        return this;
    }

    public SHA256 update(String in) {
        this.md.update(STR.utf8(in));
        return this;
    }

    public byte[] end() {
        return this.md.digest();
    }

    public static byte[] hash(byte[] in) {
        return new SHA256().update(in).end();
    }

    public static byte[] hash(String in) {
        return new SHA256().update(in).end();
    }
}

