/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.common.crypto;

import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.ProviderException;
import java.security.Security;
import java.security.Signature;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;

public final class SystemProvider {
    private static ArrayList<Provider> providers = new ArrayList();
    public static final Base<Cipher> Cipher;
    public static final Base<Signature> Signature;
    public static final Base<MessageDigest> MessageDigest;
    public static final Base<Mac> Mac;
    public static final Base<KeyFactory> KeyFactory;
    public static final Base<KeyAgreement> KeyAgreement;
    public static final Base<KeyPairGenerator> KeyPairGenerator;
    public static final Base<KeyStore> KeyStore;

    private SystemProvider() {
    }

    private static void addProvider(String name) {
        providers.add(Security.getProvider(name));
    }

    static {
        SystemProvider.addProvider("SUN");
        SystemProvider.addProvider("SunEC");
        SystemProvider.addProvider("SunJCE");
        SystemProvider.addProvider("SunRsaSign");
        SystemProvider.addProvider("SunJSSE");
        SystemProvider.addProvider("IBMJCE");
        SystemProvider.addProvider("IBMJSSE2");
        Cipher = new Base<Cipher>(){

            @Override
            protected Cipher getInstance(String alg, Provider provider) throws Exception {
                return javax.crypto.Cipher.getInstance(alg, provider);
            }
        };
        Signature = new Base<Signature>(){

            @Override
            protected Signature getInstance(String alg, Provider provider) throws Exception {
                return java.security.Signature.getInstance(alg, provider);
            }
        };
        MessageDigest = new Base<MessageDigest>(){

            @Override
            protected MessageDigest getInstance(String alg, Provider provider) throws Exception {
                return java.security.MessageDigest.getInstance(alg, provider);
            }
        };
        Mac = new Base<Mac>(){

            @Override
            protected Mac getInstance(String alg, Provider provider) throws Exception {
                return javax.crypto.Mac.getInstance(alg, provider);
            }
        };
        KeyFactory = new Base<KeyFactory>(){

            @Override
            protected KeyFactory getInstance(String alg, Provider provider) throws Exception {
                return java.security.KeyFactory.getInstance(alg, provider);
            }
        };
        KeyAgreement = new Base<KeyAgreement>(){

            @Override
            protected KeyAgreement getInstance(String alg, Provider provider) throws Exception {
                return javax.crypto.KeyAgreement.getInstance(alg, provider);
            }
        };
        KeyPairGenerator = new Base<KeyPairGenerator>(){

            @Override
            protected KeyPairGenerator getInstance(String alg, Provider provider) throws Exception {
                return java.security.KeyPairGenerator.getInstance(alg, provider);
            }
        };
        KeyStore = new Base<KeyStore>(){

            @Override
            protected KeyStore getInstance(String alg, Provider provider) throws Exception {
                return java.security.KeyStore.getInstance(alg, provider);
            }
        };
    }

    public static abstract class Base<T> {
        private ConcurrentHashMap<String, Provider> map = new ConcurrentHashMap();

        protected abstract T getInstance(String var1, Provider var2) throws Exception;

        public T getInstance(String alg) {
            Provider provider = this.map.get(alg);
            if (provider == null) {
                for (Provider p : providers) {
                    try {
                        T result = this.getInstance(alg, p);
                        if (result == null) continue;
                        this.map.put(alg, p);
                        return result;
                    }
                    catch (Exception exception) {
                    }
                }
            }
            try {
                T result = this.getInstance(alg, provider);
                if (result != null) {
                    return result;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ProviderException("Provider not found for " + alg);
        }
    }
}

