/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.common.crypto;

import com.unbound.common.crypto.DER;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.security.auth.x500.X500Principal;

public final class X509 {
    private X509() {
    }

    public static X509Certificate get(byte[] value) throws CertificateException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        return (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(value));
    }

    public static String getRdnOid(String type) {
        if (type.equals("CN")) {
            return "2.5.4.3";
        }
        if (type.equals("SN")) {
            return "2.5.4.4";
        }
        if (type.equals("SERIALNUMBER")) {
            return "2.5.4.5";
        }
        if (type.equals("C")) {
            return "2.5.4.6";
        }
        if (type.equals("L")) {
            return "2.5.4.7";
        }
        if (type.equals("ST") | type.equals("SP") | type.equals("S")) {
            return "2.5.4.8";
        }
        if (type.equals("STREET")) {
            return "2.5.4.9";
        }
        if (type.equals("O")) {
            return "2.5.4.10";
        }
        if (type.equals("OU")) {
            return "2.5.4.11";
        }
        if (type.equals("T") | type.equals("TITLE")) {
            return "2.5.4.12";
        }
        if (type.equals("G") | type.equals("GN")) {
            return "2.5.4.42";
        }
        if (type.equals("E") | type.equals("MAIL")) {
            return "1.2.840.113549.1.9.1";
        }
        if (type.equals("UNSTRUCTUREDNAME")) {
            return "1.2.840.113549.1.9.2";
        }
        if (type.equals("UNSTRUCTUREDADDRESS")) {
            return "1.2.840.113549.1.9.8";
        }
        if (type.equals("UID")) {
            return "0.9.2342.19200300.100.1.1";
        }
        if (type.equals("DC")) {
            return "0.9.2342.19200300.100.1.25";
        }
        return null;
    }

    public static String getName(X500Principal principal, String type) {
        String rdnOid = X509.getRdnOid(type);
        DER.Parser parser = new DER.Parser(principal.getEncoded());
        parser.beginSequence();
        do {
            parser.beginSet();
            parser.beginSequence();
            String oid = parser.parseOid();
            String value = parser.parseString();
            if (oid.equals(type) || oid.equals(rdnOid)) {
                return value;
            }
            parser.end();
            parser.end();
        } while (!parser.endOfBlock());
        return null;
    }

    public static DER.Builder encode(DER.Builder builder, Map<String, String> map) {
        builder.beginSequence();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            builder.beginSet().beginSequence().addOid(X509.getRdnOid(entry.getKey())).add(entry.getValue()).end().end();
        }
        return builder.end();
    }
}

