/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider;

import com.unbound.common.Log;
import com.unbound.common.crypto.PKCS10;
import com.unbound.common.crypto.SystemProvider;
import com.unbound.common.crypto.X509;
import com.unbound.provider.Partition;
import com.unbound.provider.Server;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.request.RequestItem;
import com.unbound.provider.kmip.request.RequestMessage;
import com.unbound.provider.kmip.request.dy.DyRegisterClientRequest;
import com.unbound.provider.kmip.response.ResponseItem;
import com.unbound.provider.kmip.response.ResponseMessage;
import com.unbound.provider.kmip.response.dy.DyRegisterClientResponse;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Enumeration;

public class Client {
    public static Partition register(String partitionName, String clientName, String templateName, String activationCode) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, IOException, CertificateException {
        Log log = Log.func("Client.register").log("partitionName", partitionName).log("clientName", clientName).log("templateName", templateName).log("activationCode", activationCode).end();
        try {
            InetAddress[] ip;
            ArrayList<InetAddress> ipList = new ArrayList<InetAddress>();
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface n = e.nextElement();
                Enumeration<InetAddress> ee = n.getInetAddresses();
                while (ee.hasMoreElements()) {
                    InetAddress i = ee.nextElement();
                    if (!(i instanceof Inet4Address)) continue;
                    ipList.add(i);
                }
            }
            InetAddress[] inetAddressArray = ip = ipList.isEmpty() ? null : ipList.toArray(new InetAddress[ipList.size()]);
            if (clientName == null) {
                clientName = InetAddress.getLocalHost().getHostName();
            }
            KeyPairGenerator rsaGen = SystemProvider.KeyPairGenerator.getInstance("RSA");
            rsaGen.initialize(2048);
            KeyPair rsaKeyPair = rsaGen.generateKeyPair();
            PKCS10 pkcs10 = new PKCS10((RSAPublicKey)rsaKeyPair.getPublic());
            pkcs10.setSubjectName("CN", clientName);
            pkcs10.setSubjectName("OU", partitionName);
            pkcs10.setChallengePassword(activationCode);
            pkcs10.setAlternativeSubjectName(new String[]{clientName}, ip);
            pkcs10.sign((RSAPrivateKey)rsaKeyPair.getPrivate(), "SHA256");
            byte[] csr = pkcs10.exportDer();
            DyRegisterClientRequest req = new DyRegisterClientRequest();
            req.csr = csr;
            req.name = clientName;
            req.partitionName = partitionName;
            req.template = templateName;
            DyRegisterClientResponse resp = (DyRegisterClientResponse)Client.transmit(null, req);
            Certificate[] chain = new X509Certificate[]{X509.get(resp.clientCertificate), X509.get(resp.rootCaCertificate)};
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(null, null);
            String pfxPassword = "UNBOUND";
            keyStore.setKeyEntry(clientName, rsaKeyPair.getPrivate(), pfxPassword.toCharArray(), chain);
            Partition partition = Partition.registerPfx(keyStore, pfxPassword);
            return partition;
        }
        catch (Exception e) {
            log.failed(e);
            throw e;
        }
        finally {
            log.leave();
        }
    }

    static byte[] transmit(Partition partition, byte[] in) throws IOException {
        Server[] servers = Server.getList();
        int retry = servers.length;
        for (Server server : servers) {
            try {
                return server.transmit(partition, in);
            }
            catch (Exception e) {
                if (--retry != 0) continue;
                throw e;
            }
        }
        throw new IOException("No servers found");
    }

    static ResponseMessage transmit(Partition partition, RequestMessage req) throws IOException {
        Log log = Log.func("Client.transmit").end();
        try {
            byte[] in = KMIPConverter.convert(req);
            byte[] out = Client.transmit(partition, in);
            ResponseMessage resp = KMIPConverter.convertResponseMessage(out);
            if (resp.header.batchCount == 0) {
                throw new KMIPConvertException("Invalid KMIP response");
            }
            ResponseItem item = resp.batch.get(0);
            if (item.result_status != 0) {
                throw new ProviderException("KMIP error " + item.reason + " " + item.resultMsg);
            }
            ResponseMessage responseMessage = resp;
            return responseMessage;
        }
        catch (Exception e) {
            try {
                throw new ProviderException(e);
            }
            catch (Exception e2) {
                log.failed(e2);
                throw e2;
            }
        }
        finally {
            log.leave();
        }
    }

    static ResponseItem transmit(Partition partition, RequestItem req) throws IOException {
        RequestMessage reqMsg = new RequestMessage();
        reqMsg.batch.add(req);
        ResponseMessage respMsg = Client.transmit(partition, reqMsg);
        return respMsg.batch.get(0);
    }
}

