/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider;

import com.unbound.common.HEX;
import com.unbound.common.Log;
import com.unbound.common.crypto.SHA256;
import com.unbound.common.crypto.SystemProvider;
import com.unbound.provider.Partition;
import com.unbound.provider.Server;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

class Connection {
    private static TrustManager[] trustManagers = null;
    private static boolean hasHeaders = false;
    private static String hdrHostName = "";
    private static String hdrClientIP = "";
    private static String hdrUserName = "";
    private static String hdrClientID = "";
    private HttpURLConnection conn;
    private Server server;
    private Partition partition;

    static synchronized void initialize(KeyStore trusted) throws NoSuchAlgorithmException, KeyStoreException {
        if (trusted == null) {
            return;
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(trusted);
        trustManagers = tmf.getTrustManagers();
    }

    static synchronized void initialize(String caFileName) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Log log = Log.func("Connections.initialize").log("caFileName", caFileName).end();
        try {
            if (caFileName == null) {
                return;
            }
            KeyStore trusted = SystemProvider.KeyStore.getInstance("JKS");
            trusted.load(null, null);
            FileInputStream fis = new FileInputStream(caFileName);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> collection = cf.generateCertificates(fis);
            for (Certificate certificate : collection) {
                X509Certificate cert = (X509Certificate)certificate;
                String alias = cert.getSubjectDN().getName();
                trusted.setCertificateEntry(alias, cert);
            }
            Connection.initialize(trusted);
        }
        catch (Exception e) {
            log.failed(e);
            throw e;
        }
        finally {
            log.leave();
        }
    }

    private static synchronized void getHeaders() throws UnknownHostException {
        if (hasHeaders) {
            return;
        }
        hdrUserName = System.getProperty("user.name");
        InetAddress inetAddress = InetAddress.getLocalHost();
        hdrHostName = inetAddress.getHostName();
        hdrClientIP = inetAddress.getHostAddress();
        hdrClientID = HEX.toString(new SHA256().update("AA09AE54-ED04-40E6-9237-F4865C630387").update(hdrHostName).end());
        hasHeaders = true;
    }

    Connection(Server server, Partition partition) throws IOException {
        Connection.getHeaders();
        this.server = server;
        this.partition = partition;
        this.conn = (HttpURLConnection)server.url.openConnection();
        if (this.conn instanceof HttpsURLConnection) {
            try {
                SSLContext ctx = SSLContext.getInstance("TLSv1.2");
                KeyManager[] keyManagers = partition == null ? null : partition.keyManagers;
                ctx.init(keyManagers, trustManagers, new SecureRandom());
                HttpsURLConnection https = (HttpsURLConnection)this.conn;
                https.setSSLSocketFactory(ctx.getSocketFactory());
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new ProviderException(e);
            }
        }
    }

    byte[] transmit(byte[] in) throws IOException {
        Log log = Log.func("Connection.transmit").end();
        try {
            int len;
            this.conn.setRequestMethod("POST");
            this.conn.addRequestProperty("Host", this.server.url.getHost());
            this.conn.addRequestProperty("Accept", "*/*");
            this.conn.setRequestProperty("User-Agent", "Unbound Java Provider");
            this.conn.setRequestProperty("Content-Type", "application/octet-stream");
            this.conn.addRequestProperty("Connection", "Keep-Alive");
            this.conn.addRequestProperty("EKM-Host-Name", hdrHostName);
            this.conn.addRequestProperty("EKM-User-Name", hdrUserName);
            this.conn.addRequestProperty("EKM-Client-ID", hdrClientID);
            this.conn.addRequestProperty("EKM-Client-IP", hdrClientIP);
            if (this.partition != null) {
                this.conn.addRequestProperty("EKM-Partition-Name", this.partition.name);
            }
            this.conn.addRequestProperty("EKM-Client-Version", "2.0.2001.0");
            this.conn.setDoOutput(true);
            DataOutputStream outputStream = new DataOutputStream(this.conn.getOutputStream());
            outputStream.write(in);
            outputStream.flush();
            outputStream.close();
            int responseCode = this.conn.getResponseCode();
            if (responseCode != 200) {
                this.close();
                throw new IOException("HTTP response code = " + responseCode);
            }
            InputStream input = this.conn.getInputStream();
            ByteArrayOutputStream temp = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            while ((len = input.read(buffer)) != -1) {
                temp.write(buffer, 0, len);
            }
            this.close();
            byte[] byArray = temp.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            log.failed(e);
            throw e;
        }
        finally {
            log.leave();
        }
    }

    private void close() {
        if (this.conn != null) {
            this.conn.disconnect();
        }
        this.conn = null;
        this.server = null;
        this.partition = null;
    }
}

