/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider;

import com.unbound.common.crypto.EC;
import com.unbound.common.crypto.SystemProvider;
import com.unbound.provider.RSASignature;
import com.unbound.provider.UBECPrivateKey;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.ECPublicKey;
import java.util.Arrays;

public class ECDSASignature
extends SignatureSpi {
    private Signature pubSignature = null;
    private int hashBitSize;
    private MessageDigest md = null;
    private byte[] buffer = new byte[66];
    private int bufferOffset = 0;
    private UBECPrivateKey prvKey = null;

    ECDSASignature(int hashBitSize) {
        this.hashBitSize = hashBitSize;
    }

    private static int hashBitSizeToKmipAlg(int hashBitSize) {
        switch (hashBitSize) {
            case 160: {
                return 12;
            }
            case 256: {
                return 14;
            }
            case 384: {
                return 15;
            }
            case 512: {
                return 16;
            }
        }
        return 0;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof ECPublicKey)) {
            throw new InvalidKeyException("Invalid key type");
        }
        try {
            this.pubSignature = Signature.getInstance(RSASignature.hashBitSizeToName(this.hashBitSize) + "withECDSA", "SunEC");
        }
        catch (Exception e) {
            throw new InvalidKeyException("engineInitVerify failed");
        }
        this.pubSignature.initVerify(publicKey);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof UBECPrivateKey)) {
            throw new InvalidKeyException("Invalid key type");
        }
        this.prvKey = (UBECPrivateKey)privateKey;
        this.bufferOffset = 0;
        try {
            this.md = this.hashBitSize == 0 ? null : SystemProvider.MessageDigest.getInstance(RSASignature.hashBitSizeToDigestName(this.hashBitSize));
        }
        catch (Exception e) {
            throw new ProviderException(e);
        }
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        if (this.pubSignature != null) {
            this.pubSignature.update(b);
            return;
        }
        byte[] in = new byte[]{b};
        this.engineUpdate(in, 0, 1);
    }

    @Override
    protected void engineUpdate(byte[] in, int inOffset, int inLen) throws SignatureException {
        if (this.pubSignature != null) {
            this.pubSignature.update(in, inOffset, inLen);
            return;
        }
        if (this.md == null) {
            int size = this.prvKey.size();
            if (this.bufferOffset + inLen > size) {
                inLen = size - this.bufferOffset;
            }
            System.arraycopy(in, inOffset, this.buffer, this.bufferOffset, inLen);
            this.bufferOffset += inLen;
        } else {
            this.md.update(in, inOffset, inLen);
        }
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] in;
        EC.Curve curve = this.prvKey.getCurve();
        if (this.md == null) {
            in = Arrays.copyOfRange(this.buffer, 0, this.bufferOffset);
        } else {
            in = this.md.digest();
            if (in.length > curve.size) {
                in = Arrays.copyOfRange(in, 0, curve.size);
            }
        }
        int kmipAlg = ECDSASignature.hashBitSizeToKmipAlg(this.hashBitSize);
        try {
            byte[] bin = this.prvKey.sign(in, 26, kmipAlg);
            return curve.sigBinToDer(bin);
        }
        catch (IOException e) {
            throw new ProviderException(e);
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        return this.pubSignature.verify(sigBytes);
    }

    @Override
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new UnsupportedOperationException("setParameter() not supported");
    }

    @Override
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        throw new UnsupportedOperationException("getParameter() not supported");
    }

    public static final class SHA512
    extends ECDSASignature {
        public SHA512() {
            super(512);
        }
    }

    public static final class SHA384
    extends ECDSASignature {
        public SHA384() {
            super(384);
        }
    }

    public static final class SHA256
    extends ECDSASignature {
        public SHA256() {
            super(256);
        }
    }

    public static final class SHA1
    extends ECDSASignature {
        public SHA1() {
            super(160);
        }
    }

    public static final class Raw
    extends ECDSASignature {
        public Raw() {
            super(0);
        }
    }
}

