/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider;

import com.unbound.common.crypto.SystemProvider;
import com.unbound.provider.Partition;
import com.unbound.provider.UBECPrivateKey;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public final class ECKeyFactory
extends KeyFactorySpi {
    private Partition partition;

    ECKeyFactory(Partition partition) {
        this.partition = partition;
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        return SystemProvider.KeyFactory.getInstance("EC").generatePublic(keySpec);
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec == null) {
            throw new InvalidKeySpecException("keySpec == null");
        }
        if (keySpec instanceof ECPrivateKeySpec || keySpec instanceof PKCS8EncodedKeySpec) {
            try {
                return new UBECPrivateKey(this.partition, keySpec);
            }
            catch (Exception e) {
                throw new InvalidKeySpecException(e);
            }
        }
        throw new InvalidKeySpecException("Must use ECPrivateKeySpec or PKCS8EncodedKeySpec; was " + keySpec.getClass().getName());
    }

    @Override
    protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> keySpec) throws InvalidKeySpecException {
        if (key == null || keySpec == null) {
            throw new InvalidKeySpecException("key and keySpec must not be null");
        }
        if (key instanceof ECPublicKey && X509EncodedKeySpec.class.isAssignableFrom(keySpec)) {
            return SystemProvider.KeyFactory.getInstance("EC").getKeySpec(key, keySpec);
        }
        if (key instanceof ECPublicKey && ECPublicKeySpec.class.isAssignableFrom(keySpec)) {
            return (T)new ECPublicKeySpec(((ECPublicKey)key).getW(), ((ECPublicKey)key).getParams());
        }
        throw new InvalidKeySpecException("Could not encode key");
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        return key;
    }
}

