/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider;

import com.unbound.common.Base64;
import com.unbound.common.JSON;
import com.unbound.common.Log;
import com.unbound.common.STR;
import com.unbound.common.crypto.X509;
import com.unbound.provider.Client;
import com.unbound.provider.UBKeyStore;
import com.unbound.provider.UBObject;
import com.unbound.provider.kmip.attribute.Authentication;
import com.unbound.provider.kmip.request.GetAttributesRequest;
import com.unbound.provider.kmip.request.GetRequest;
import com.unbound.provider.kmip.request.LocateRequest;
import com.unbound.provider.kmip.request.RequestItem;
import com.unbound.provider.kmip.request.RequestMessage;
import com.unbound.provider.kmip.request.dy.DyLoginRequest;
import com.unbound.provider.kmip.response.LocateResponse;
import com.unbound.provider.kmip.response.ResponseItem;
import com.unbound.provider.kmip.response.ResponseMessage;
import com.unbound.provider.kmip.response.dy.DyLoginResponse;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Clock;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.security.auth.x500.X500Principal;

public class Partition {
    private static HashMap<String, Partition> partitions = new HashMap();
    private static final Clock clock = Clock.systemUTC();
    KeyManager[] keyManagers;
    String name;
    UBKeyStore keyStore;
    private byte[] jwt = null;
    private long jwtValidityClock;

    private Partition(String name, KeyStore pfx, String pfxPass) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        Log log = Log.func("Partition").log("name", name).end();
        try {
            this.name = name;
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(pfx, pfxPass.toCharArray());
            this.keyManagers = kmf.getKeyManagers();
            this.keyStore = new UBKeyStore(this);
        }
        catch (Exception e) {
            log.failed(e);
            throw e;
        }
        finally {
            log.leave();
        }
    }

    private static KeyStore loadPfx(String pfxFileName, String pass) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        Log log = Log.func("Partition.loadPfx").log("pfxFileName", pfxFileName).log("pass", pass != null).end();
        try {
            char[] passChars = pass == null ? null : pass.toCharArray();
            KeyStore ks = KeyStore.getInstance("pkcs12");
            ks.load(new FileInputStream(pfxFileName), passChars);
            KeyStore keyStore = ks;
            return keyStore;
        }
        catch (Exception e) {
            log.failed(e);
            throw e;
        }
        finally {
            log.leave();
        }
    }

    private static String getNameFromPfx(KeyStore pfx, String type) throws KeyStoreException {
        Enumeration<String> aliases = pfx.aliases();
        if (!aliases.hasMoreElements()) {
            throw new ProviderException("Empty store");
        }
        X509Certificate cert = (X509Certificate)pfx.getCertificate(aliases.nextElement());
        if (cert == null) {
            throw new ProviderException("Empty store");
        }
        X500Principal principal = cert.getSubjectX500Principal();
        if (principal == null) {
            throw new ProviderException("Invalid prinicpal");
        }
        String ou = X509.getName(principal, type);
        if (ou == null) {
            throw new ProviderException("Invalid prinicpal");
        }
        return ou;
    }

    static synchronized Partition registerPfx(String pfxFileName, String pass) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, UnrecoverableKeyException {
        KeyStore pfx = Partition.loadPfx(pfxFileName, pass);
        return Partition.registerPfx(pfx, pass);
    }

    static synchronized Partition registerPfx(KeyStore pfx, String pass) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException {
        String name = Partition.getNameFromPfx(pfx, "OU");
        Partition partition = partitions.get(name);
        if (partition == null) {
            partition = new Partition(name, pfx, pass);
            partitions.put(name, partition);
        }
        return partition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResponseMessage transmit(RequestMessage req) throws IOException {
        Log log = Log.func("Partition.transmit").end();
        try {
            long jwtValidityClock;
            byte[] jwt;
            Object object = this;
            synchronized (object) {
                jwt = this.jwt;
                jwtValidityClock = this.jwtValidityClock;
            }
            if (req.header.auth == null && jwt != null) {
                if (jwtValidityClock < clock.millis()) {
                    this.loginRenew();
                }
                req.header.auth = new Authentication();
                req.header.auth.credType = 3;
                req.header.auth.attestationType = -2147483647;
                req.header.auth.attestationAssertion = jwt;
            }
            object = Client.transmit(this, req);
            return object;
        }
        catch (Exception e) {
            log.failed(e);
            throw e;
        }
        finally {
            log.leave();
        }
    }

    ResponseItem transmit(RequestItem req) throws IOException {
        RequestMessage reqMsg = new RequestMessage();
        reqMsg.batch.add(req);
        ResponseMessage respMsg = this.transmit(reqMsg);
        return respMsg.batch.get(0);
    }

    private static GetAttributesRequest prepareGetAttrRequest(long uid) {
        GetAttributesRequest getAttr = new GetAttributesRequest();
        getAttr.uid = UBObject.uidToStr(uid);
        getAttr.names.add("Object Type");
        getAttr.names.add("Cryptographic Algorithm");
        getAttr.names.add("Name");
        getAttr.names.add("Initial Date");
        return getAttr;
    }

    ResponseMessage read(long[] uids) throws IOException {
        RequestMessage reqMsg = new RequestMessage();
        for (long uid : uids) {
            GetAttributesRequest getAttr = Partition.prepareGetAttrRequest(uid);
            GetRequest get = new GetRequest();
            get.uid = UBObject.uidToStr(uid);
            get.formatType = 5;
            reqMsg.batch.add(getAttr);
            reqMsg.batch.add(get);
        }
        return this.transmit(reqMsg);
    }

    ResponseMessage read(long uid) throws IOException {
        RequestMessage reqMsg = new RequestMessage();
        GetAttributesRequest getAttr = Partition.prepareGetAttrRequest(uid);
        GetRequest get = new GetRequest();
        get.uid = UBObject.uidToStr(uid);
        get.formatType = 5;
        reqMsg.batch.add(getAttr);
        reqMsg.batch.add(get);
        return this.transmit(reqMsg);
    }

    long[] locate(int objectType, int algType) throws IOException {
        Log log = Log.func("Partition.locate").log("objectType", objectType).log("algType", algType).end();
        try {
            LocateRequest req = UBObject.locateRequest(objectType, algType, null);
            req.maxItems = 1024;
            LocateResponse resp = (LocateResponse)this.transmit(req);
            long[] result = new long[resp.list.size()];
            int index = 0;
            for (String s : resp.list) {
                long uid = UBObject.strToUid(s);
                Log.print("Object").logHex("uid", uid).end();
                result[index++] = uid;
            }
            Object object = result;
            return object;
        }
        catch (Exception e) {
            log.failed(e);
            throw e;
        }
        finally {
            log.leave();
        }
    }

    long locate(LocateRequest req) throws IOException {
        LocateResponse resp = (LocateResponse)this.transmit(req);
        if (resp.list.isEmpty()) {
            return 0L;
        }
        return UBObject.strToUid(resp.list.get(0));
    }

    long locate(int objectType, int algType, String alias) throws IOException {
        long uid = 0L;
        Log log = Log.func("Partition.locate").log("objectType", objectType).log("algType", algType).log("alias", alias).end();
        try {
            LocateRequest req = UBObject.locateRequest(objectType, algType, alias);
            long l = uid = this.locate(req);
            return l;
        }
        catch (Exception e) {
            log.failed(e);
            throw e;
        }
        finally {
            log.leavePrint().logHex("uid", uid).end();
        }
    }

    void login(String password) throws IOException {
        this.loginOrRenew(password, false);
    }

    private void loginRenew() throws IOException {
        this.loginOrRenew(null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loginOrRenew(String password, boolean renewWjt) throws IOException {
        block18: {
            Log log = Log.func("Partition.login").log("renewWjt", renewWjt).log("password", password != null && !password.isEmpty()).end();
            try {
                RequestMessage reqMsg = new RequestMessage();
                reqMsg.header.auth = new Authentication();
                if (renewWjt) {
                    reqMsg.header.auth = new Authentication();
                    reqMsg.header.auth.credType = 3;
                    reqMsg.header.auth.attestationType = -2147483647;
                    reqMsg.header.auth.attestationAssertion = this.jwt;
                } else {
                    reqMsg.header.auth.credType = 1;
                    reqMsg.header.auth.username = "user";
                    reqMsg.header.auth.password = "";
                    if (password != null) {
                        String user;
                        try {
                            Map json = (Map)JSON.convert(password);
                            user = (String)json.get("username");
                            password = (String)json.get("password");
                        }
                        catch (Exception e) {
                            user = "user";
                        }
                        reqMsg.header.auth.password = password;
                        reqMsg.header.auth.username = user;
                    }
                }
                DyLoginRequest req = new DyLoginRequest();
                req.doCreateWjt = true;
                reqMsg.batch.add(req);
                try {
                    int validity;
                    ResponseMessage respMsg = this.transmit(reqMsg);
                    DyLoginResponse resp = (DyLoginResponse)respMsg.batch.get(0);
                    if (resp.jwt == null || (validity = Partition.jwtTokenValidity(STR.utf8(resp.jwt))) <= 0) break block18;
                    Partition partition = this;
                    synchronized (partition) {
                        long now = clock.millis();
                        this.jwt = resp.jwt;
                        this.jwtValidityClock = now + (long)(validity * 1000);
                    }
                }
                catch (Exception e) {
                    Partition partition = this;
                    synchronized (partition) {
                        this.jwt = null;
                    }
                    throw e;
                }
            }
            catch (Exception e) {
                log.failed(e);
                throw e;
            }
            finally {
                log.leave();
            }
        }
    }

    private static int jwtTokenValidity(String jwt) throws IOException {
        String[] t = jwt.split("\\.");
        if (t.length != 3) {
            return 0;
        }
        byte[] t1 = Base64.decodeUrl(t[1]);
        String s = STR.utf8(t1);
        Map root = (Map)JSON.convert(s);
        Long iat = (Long)root.get("iat");
        Long exp = (Long)root.get("exp");
        return (int)(exp - iat - 30L);
    }
}

