/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider;

import com.unbound.provider.Partition;
import com.unbound.provider.UBRSAPrivateKey;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.ProviderException;
import java.security.SecureRandom;

public final class RSAKeyPairGenerator
extends KeyPairGeneratorSpi {
    private Partition partition;
    private int bitSize;

    RSAKeyPairGenerator(Partition partition) {
        this.partition = partition;
    }

    @Override
    public void initialize(int bitSize, SecureRandom random) {
        this.bitSize = bitSize;
        if (bitSize != 2048 && bitSize != 3072 && bitSize != 4096) {
            throw new InvalidParameterException("Unsupported RSA key size " + bitSize);
        }
    }

    @Override
    public KeyPair generateKeyPair() {
        UBRSAPrivateKey key = new UBRSAPrivateKey(this.partition);
        try {
            key.generate(this.bitSize, null);
        }
        catch (Exception e) {
            throw new ProviderException(e);
        }
        return new KeyPair(key.pub, key);
    }
}

