/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider;

import com.unbound.common.crypto.SystemProvider;
import com.unbound.provider.UBRSAPrivateKey;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;

public class RSASignature
extends SignatureSpi {
    private Signature pubSignature = null;
    private UBRSAPrivateKey prvKey = null;
    private int hashBitSize;
    private MessageDigest md = null;
    private byte[] buffer = new byte[501];
    private int bufferOffset = 0;

    static String hashBitSizeToName(int hashBitSize) throws InvalidAlgorithmParameterException {
        switch (hashBitSize) {
            case 0: {
                return "NONE";
            }
            case 160: {
                return "SHA1";
            }
            case 256: {
                return "SHA256";
            }
            case 384: {
                return "SHA384";
            }
            case 512: {
                return "SHA512";
            }
        }
        throw new InvalidAlgorithmParameterException("Unsupported hash algorithm");
    }

    static String hashBitSizeToDigestName(int hashBitSize) throws InvalidAlgorithmParameterException {
        switch (hashBitSize) {
            case 160: {
                return "SHA-1";
            }
            case 256: {
                return "SHA-256";
            }
            case 384: {
                return "SHA-384";
            }
            case 512: {
                return "SHA-512";
            }
        }
        throw new InvalidAlgorithmParameterException("Unsupported hash algorithm");
    }

    private static int hashBitSizeToKmipAlg(int hashBitSize) {
        switch (hashBitSize) {
            case 160: {
                return 3;
            }
            case 256: {
                return 5;
            }
            case 384: {
                return 6;
            }
            case 512: {
                return 7;
            }
        }
        return 0;
    }

    RSASignature(int hashBitSize) {
        this.hashBitSize = hashBitSize;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new InvalidKeyException("Invalid key type");
        }
        try {
            this.pubSignature = SystemProvider.Signature.getInstance(RSASignature.hashBitSizeToName(this.hashBitSize) + "WithRSA");
        }
        catch (Throwable e) {
            throw new InvalidKeyException("engineInitVerify failed");
        }
        this.pubSignature.initVerify(publicKey);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof UBRSAPrivateKey)) {
            throw new InvalidKeyException("Invalid key type");
        }
        this.prvKey = (UBRSAPrivateKey)privateKey;
        this.bufferOffset = 0;
        try {
            this.md = this.hashBitSize == 0 ? null : SystemProvider.MessageDigest.getInstance(RSASignature.hashBitSizeToDigestName(this.hashBitSize));
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new ProviderException(e);
        }
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        if (this.pubSignature != null) {
            this.pubSignature.update(b);
            return;
        }
        byte[] in = new byte[]{b};
        this.engineUpdate(in, 0, 1);
    }

    @Override
    protected void engineUpdate(byte[] in, int inOffset, int inLen) throws SignatureException {
        if (this.pubSignature != null) {
            this.pubSignature.update(in, inOffset, inLen);
            return;
        }
        if (this.md == null) {
            System.arraycopy(in, inOffset, this.buffer, this.bufferOffset, inLen);
            this.bufferOffset += inLen;
        } else {
            this.md.update(in, inOffset, inLen);
        }
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] in = this.md == null ? Arrays.copyOfRange(this.buffer, 0, this.bufferOffset) : this.md.digest();
        int kmipAlg = RSASignature.hashBitSizeToKmipAlg(this.hashBitSize);
        try {
            return this.prvKey.sign(in, 4, kmipAlg);
        }
        catch (IOException e) {
            throw new ProviderException(e);
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        return this.pubSignature.verify(sigBytes);
    }

    @Override
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new UnsupportedOperationException("setParameter() not supported");
    }

    @Override
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        throw new UnsupportedOperationException("getParameter() not supported");
    }

    public static final class SHA512withRSA
    extends RSASignature {
        public SHA512withRSA() {
            super(512);
        }
    }

    public static final class SHA384withRSA
    extends RSASignature {
        public SHA384withRSA() {
            super(384);
        }
    }

    public static final class SHA256withRSA
    extends RSASignature {
        public SHA256withRSA() {
            super(256);
        }
    }

    public static final class SHA1withRSA
    extends RSASignature {
        public SHA1withRSA() {
            super(160);
        }
    }

    public static final class NONEwithRSA
    extends RSASignature {
        public NONEwithRSA() {
            super(0);
        }
    }
}

