/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider;

import com.unbound.common.Log;
import com.unbound.provider.Connection;
import com.unbound.provider.Partition;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Clock;
import java.util.Random;

class Server {
    private static final int CHECK_DISCONNECTED_TIMEOUT = 3000;
    private static final Clock clock = Clock.systemUTC();
    private static Server[] servers = null;
    private static Random randomPicker = new Random();
    URL url;
    private String name;
    private long checkDisconnectedClock = 0L;

    private Server(String name) throws MalformedURLException {
        Log log = Log.func("Server").log("Name", name).end();
        try {
            URL host;
            int port;
            this.name = name;
            if (name.startsWith("https://")) {
                name = name.substring(8);
            }
            if ((port = (host = new URL("https://" + name)).getPort()) <= 0) {
                port = 443;
            }
            this.url = new URL("https", host.getHost(), port, "/kmip", null);
        }
        catch (Exception e) {
            log.failed(e);
            throw e;
        }
        finally {
            log.leave();
        }
    }

    static synchronized void initialize(String servers) throws MalformedURLException {
        Log log = Log.func("Servers.initialize").log("servers", servers).end();
        try {
            Server.initialize(servers.split(","));
        }
        catch (Exception e) {
            log.failed(e);
            throw e;
        }
        finally {
            log.leave();
        }
    }

    static synchronized void initialize(String[] serverNames) throws MalformedURLException {
        if (serverNames.length == 0) {
            throw new IllegalArgumentException("Server list is empty");
        }
        Server[] temp = new Server[serverNames.length];
        int index = 0;
        for (String name : serverNames) {
            temp[index++] = new Server(name);
        }
        servers = temp;
    }

    static synchronized Server[] getList() {
        long now = clock.millis();
        int count = 0;
        for (Server server : servers) {
            if (now < server.checkDisconnectedClock + 3000L) continue;
            ++count;
        }
        if (count == 0) {
            Server server = servers[randomPicker.nextInt(servers.length)];
            Server[] list = new Server[]{server};
            return list;
        }
        Server[] list = new Server[count];
        count = 0;
        for (Server server : servers) {
            if (now < server.checkDisconnectedClock + 3000L) continue;
            list[count++] = server;
        }
        for (int i = 0; i < count - 1; ++i) {
            int j = i + randomPicker.nextInt(count - i);
            Server temp = list[i];
            list[i] = list[j];
            list[j] = temp;
        }
        return list;
    }

    byte[] transmit(Partition partition, byte[] in) throws IOException {
        try {
            Connection connection = new Connection(this, partition);
            byte[] out = connection.transmit(in);
            this.checkDisconnectedClock = 0L;
            return out;
        }
        catch (Exception e) {
            this.checkDisconnectedClock = clock.millis();
            throw e;
        }
    }
}

