/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider;

import com.unbound.common.Config;
import com.unbound.common.Log;
import com.unbound.provider.Client;
import com.unbound.provider.Connection;
import com.unbound.provider.ECKeyFactory;
import com.unbound.provider.ECKeyPairGenerator;
import com.unbound.provider.Partition;
import com.unbound.provider.RSAKeyFactory;
import com.unbound.provider.RSAKeyPairGenerator;
import com.unbound.provider.Server;
import java.io.IOException;
import java.net.MalformedURLException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.ProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Map;

public final class UBCryptoProvider
extends Provider {
    private static final String NAME = "UNBOUND";
    private static final double VERSION = 1.0;
    private static final String INFO = "UnboundTech UKC security provider";
    private static final String ENV_SERVERS = "UKC_SERVERS";
    private static final String ENV_PFX = "UKC_PFX";
    private static final String ENV_PFX_PASS = "UKC_PFX_PASS";
    private static final String ENV_CA = "UKC_CA";
    private static final String ENV_CLIENT_NAME = "UKC_CLIENT_NAME";
    private static final String ENV_TEMPLATE_NAME = "UKC_TEMPLATE_NAME";
    private static final String ENV_PARTITION_NAME = "UKC_PARTITION_NAME";
    private static final String ENV_ACTIVATION_CODE = "UKC_ACTIVATION_CODE";
    private static boolean initialized = false;
    private static final int SERVICE_KEY_STORE = 0;
    private static final int SERVICE_RSA_GEN = 1;
    private static final int SERVICE_RSA_IMPORT = 2;
    private static final int SERVICE_EC_GEN = 3;
    private static final int SERVICE_EC_IMPORT = 4;
    private Partition partition;

    public static synchronized void initialize(String[] servers, KeyStore trusted) throws MalformedURLException, KeyStoreException, NoSuchAlgorithmException {
        Server.initialize(servers);
        Connection.initialize(trusted);
        initialized = true;
    }

    private static synchronized void initialize(Map<String, String> map) throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        if ((map == null || map.isEmpty()) && initialized) {
            return;
        }
        String servers = UBCryptoProvider.getConfig(map, ENV_SERVERS);
        String ca = UBCryptoProvider.getConfig(map, ENV_CA);
        Server.initialize(servers);
        Connection.initialize(ca);
        initialized = true;
    }

    private UBCryptoProvider(String name, double version, String info) {
        super(name, version, info);
    }

    public UBCryptoProvider() {
        this((String)null);
    }

    public static UBCryptoProvider proxy(Provider parent, String configArg) {
        UBCryptoProvider provider = new UBCryptoProvider(parent.getName(), parent.getVersion(), parent.getInfo());
        try {
            provider.init(configArg);
        }
        catch (Exception e) {
            if (configArg == null) {
                return null;
            }
            throw new ProviderException(e);
        }
        return provider;
    }

    public static UBCryptoProvider getInstance(KeyStore pfx, String pfxPass) {
        UBCryptoProvider provider = new UBCryptoProvider(NAME, 1.0, INFO);
        try {
            UBCryptoProvider.initialize(null);
            provider.partition = Partition.registerPfx(pfx, pfxPass);
            provider.register(provider);
        }
        catch (ProviderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProviderException(e);
        }
        return provider;
    }

    public UBCryptoProvider(String partitionName, String clientName, String templateName, String activationCode) {
        super(NAME, 1.0, INFO);
        try {
            UBCryptoProvider.initialize(null);
            this.partition = Client.register(partitionName, clientName, templateName, activationCode);
            this.register(this);
        }
        catch (ProviderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProviderException(e);
        }
    }

    public UBCryptoProvider(String configArg) {
        super(NAME, 1.0, INFO);
        boolean hasConfig;
        boolean bl = hasConfig = configArg != null;
        if (!hasConfig) {
            boolean bl2 = hasConfig = System.getenv(ENV_SERVERS) != null && System.getenv(ENV_CA) != null;
        }
        if (!hasConfig) {
            return;
        }
        try {
            this.init(configArg);
            this.register(this);
        }
        catch (ProviderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProviderException(e);
        }
    }

    private static String getConfig(Map<String, String> map, String name) {
        String result = null;
        if (map != null) {
            result = map.get(name);
        }
        if (result == null) {
            result = System.getenv(name);
        }
        return result;
    }

    private void init(String configArg) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, UnrecoverableKeyException {
        Log log = Log.func("UBCryptoProvider.init").log("configArg", configArg).end();
        try {
            Map<String, String> map = configArg == null ? null : Config.readFile(configArg);
            String pfx = UBCryptoProvider.getConfig(map, ENV_PFX);
            String pfxPass = UBCryptoProvider.getConfig(map, ENV_PFX_PASS);
            String partitionName = UBCryptoProvider.getConfig(map, ENV_PARTITION_NAME);
            String clientName = UBCryptoProvider.getConfig(map, ENV_CLIENT_NAME);
            String templateName = UBCryptoProvider.getConfig(map, ENV_TEMPLATE_NAME);
            String activationCode = UBCryptoProvider.getConfig(map, ENV_ACTIVATION_CODE);
            UBCryptoProvider.initialize(map);
            this.partition = pfx == null ? Client.register(partitionName, clientName, templateName, activationCode) : Partition.registerPfx(pfx, pfxPass);
        }
        catch (Exception e) {
            log.failed(e);
            throw e;
        }
        finally {
            log.leave();
        }
    }

    @Override
    public Provider configure(String configArg) {
        return new UBCryptoProvider(configArg);
    }

    public Provider.Service[] register(Provider provider) {
        String prefix = this.getClass().getPackage().getName() + ".";
        String rsaKeyClasses = "java.security.interfaces.RSAPublicKey|java.security.interfaces.RSAPrivateKey";
        provider.put("KeyFactory.RSA", prefix + "RSAKeyFactory");
        provider.put("KeyPairGenerator.RSA", prefix + "RSAKeyPairGenerator");
        provider.put("Alg.Alias.KeyPairGenerator.1.2.840.113549.1.1", "RSA");
        provider.put("Alg.Alias.KeyPairGenerator.OID.1.2.840.113549.1.1", "RSA");
        StringBuffer modes = new StringBuffer();
        UBCryptoProvider.appendMode(modes, "PKCS1PADDING");
        UBCryptoProvider.appendMode(modes, "NOPADDING");
        UBCryptoProvider.appendMode(modes, "OAEPPADDING|OAEPWITHSHA1ANDMGF1PADDING|OAEPWITHSHA-1ANDMGF1PADDING|OAEPWITHSHA-256ANDMGF1PADDING|OAEPWITHSHA-384ANDMGF1PADDING|OAEPWITHSHA-512ANDMGF1PADDING");
        if (modes.length() > 0) {
            provider.put("Cipher.RSA", prefix + "RSACipher");
            provider.put("Cipher.RSA SupportedModes", "ECB");
            provider.put("Cipher.RSA SupportedKeyClasses", "java.security.interfaces.RSAPublicKey|java.security.interfaces.RSAPrivateKey");
            provider.put("Cipher.RSA SupportedPaddings", modes.toString());
        }
        provider.put("Signature.NONEwithRSA SupportedKeyClasses", "java.security.interfaces.RSAPublicKey|java.security.interfaces.RSAPrivateKey");
        provider.put("Signature.NONEwithRSA", prefix + "RSASignature$NONEwithRSA");
        provider.put("Signature.SHA1withRSA SupportedKeyClasses", "java.security.interfaces.RSAPublicKey|java.security.interfaces.RSAPrivateKey");
        provider.put("Signature.SHA1withRSA", prefix + "RSASignature$SHA1withRSA");
        provider.put("Alg.Alias.Signature.1.2.840.113549.1.1.5", "SHA1withRSA");
        provider.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.5", "SHA1withRSA");
        provider.put("Alg.Alias.Signature.1.3.14.3.2.29", "SHA1withRSA");
        provider.put("Signature.SHA256withRSA SupportedKeyClasses", "java.security.interfaces.RSAPublicKey|java.security.interfaces.RSAPrivateKey");
        provider.put("Signature.SHA256withRSA", prefix + "RSASignature$SHA256withRSA");
        provider.put("Alg.Alias.Signature.1.2.840.113549.1.1.11", "SHA256withRSA");
        provider.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.11", "SHA256withRSA");
        provider.put("Signature.SHA384withRSA SupportedKeyClasses", "java.security.interfaces.RSAPublicKey|java.security.interfaces.RSAPrivateKey");
        provider.put("Signature.SHA384withRSA", prefix + "RSASignature$SHA384withRSA");
        provider.put("Alg.Alias.Signature.1.2.840.113549.1.1.12", "SHA384withRSA");
        provider.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.12", "SHA384withRSA");
        provider.put("Signature.SHA512withRSA SupportedKeyClasses", "java.security.interfaces.RSAPublicKey|java.security.interfaces.RSAPrivateKey");
        provider.put("Signature.SHA512withRSA", prefix + "RSASignature$SHA512withRSA");
        provider.put("Alg.Alias.Signature.1.2.840.113549.1.1.13", "SHA512withRSA");
        provider.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.13", "SHA512withRSA");
        String ecKeyClasses = "java.security.interfaces.ECPublicKey|java.security.interfaces.ECPrivateKey";
        provider.put("Alg.Alias.KeyFactory.EllipticCurve", "EC");
        provider.put("Signature.NONEwithECDSA", prefix + "ECDSASignature$Raw");
        provider.put("Signature.NONEwithECDSA SupportedKeyClasses", ecKeyClasses);
        provider.put("Signature.SHA1withECDSA", prefix + "ECDSASignature$SHA1");
        provider.put("Signature.SHA1withECDSA SupportedKeyClasses", ecKeyClasses);
        provider.put("Signature.SHA256withECDSA", prefix + "ECDSASignature$SHA256");
        provider.put("Signature.SHA256withECDSA SupportedKeyClasses", ecKeyClasses);
        provider.put("Signature.SHA384withECDSA", prefix + "ECDSASignature$SHA384");
        provider.put("Signature.SHA384withECDSA SupportedKeyClasses", ecKeyClasses);
        provider.put("Signature.SHA512withECDSA", prefix + "ECDSASignature$SHA512");
        provider.put("Signature.SHA512withECDSA SupportedKeyClasses", ecKeyClasses);
        Provider.Service[] services = new Provider.Service[]{new UBProviderService(provider, "KeyStore", "PKCS11", prefix + "UBKeyStore", this.partition, 0), new UBProviderService(provider, "KeyFactory", "RSA", prefix + "RSAKeyFactory", this.partition, 2), new UBProviderService(provider, "KeyPairGenerator", "RSA", prefix + "RSAKeyPairGenerator", this.partition, 1), new UBProviderService(provider, "KeyFactory", "EC", prefix + "ECKeyFactory", this.partition, 4), new UBProviderService(provider, "KeyPairGenerator", "EC", prefix + "ECKeyPairGenerator", this.partition, 3)};
        if (this == provider) {
            for (Provider.Service service : services) {
                this.putService(service);
            }
            return null;
        }
        return services;
    }

    private static void appendMode(StringBuffer buf, String a) {
        if (buf.length() > 0) {
            buf.append("|");
        }
        buf.append(a);
    }

    static final class UBProviderService
    extends Provider.Service {
        private Partition partition;
        int mode;

        UBProviderService(Provider provider, String type, String algorithm, String className, Partition partition, int mode) {
            super(provider, type, algorithm, className, null, null);
            this.partition = partition;
            this.mode = mode;
        }

        @Override
        public boolean supportsParameter(Object param) {
            return false;
        }

        @Override
        public Object newInstance(Object param) {
            switch (this.mode) {
                case 0: {
                    return this.partition.keyStore;
                }
                case 1: {
                    return new RSAKeyPairGenerator(this.partition);
                }
                case 2: {
                    return new RSAKeyFactory(this.partition);
                }
                case 3: {
                    return new ECKeyPairGenerator(this.partition);
                }
                case 4: {
                    return new ECKeyFactory(this.partition);
                }
            }
            return null;
        }
    }
}

