/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider;

import com.unbound.common.Log;
import com.unbound.provider.Partition;
import com.unbound.provider.UBCertificate;
import com.unbound.provider.UBObject;
import com.unbound.provider.UBPrivateKey;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.time.Clock;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public final class UBKeyStore
extends KeyStoreSpi {
    private static final int CACHE_TIMEOUT = 30000;
    private static final Clock clock = Clock.systemUTC();
    private Partition partition;
    private Map<String, Entry> cache = new HashMap<String, Entry>();
    private long lastCacheClock = 0L;

    UBKeyStore(Partition partition) {
        this.partition = partition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry findEntry(String alias) throws InvalidKeySpecException, CertificateException, IOException {
        Entry entry = null;
        Log log = Log.func("UBKeyStore.findEntry").log("alias", alias).end();
        try {
            UBCertificate cert;
            Object object = this;
            synchronized (object) {
                entry = this.cache.get(alias.toUpperCase());
            }
            if (entry != null) {
                object = entry;
                return object;
            }
            UBPrivateKey key = UBPrivateKey.locate(this.partition, alias);
            if (key == null) {
                cert = UBCertificate.locate(this.partition, alias);
                if (cert == null) {
                    Entry entry2 = null;
                    return entry2;
                }
                entry = new Entry(cert);
            } else {
                cert = UBCertificate.locateByKeyUid(this.partition, key.uid);
                if (cert == null) {
                    Entry entry3 = null;
                    return entry3;
                }
                entry = new Entry(key, cert, null);
            }
            Object object2 = this;
            synchronized (object2) {
                this.cache.put(entry.getName().toUpperCase(), entry);
            }
            object2 = entry;
            return object2;
        }
        catch (Exception e) {
            log.failed(e);
            throw e;
        }
        finally {
            log = log.leavePrint();
            if (entry != null) {
                log.log("entry", entry.getName());
            }
            log.end();
        }
    }

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        Entry entry;
        try {
            if (password != null && password.length != 0) {
                this.partition.login(new String(password));
            }
            entry = this.findEntry(alias);
        }
        catch (IOException | CertificateException | InvalidKeySpecException e) {
            throw new ProviderException(e);
        }
        if (entry == null) {
            return null;
        }
        return entry.key;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        Entry entry;
        try {
            entry = this.findEntry(alias);
        }
        catch (Exception e) {
            throw new ProviderException(e);
        }
        if (entry == null) {
            return null;
        }
        return entry.chain;
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        Entry entry;
        try {
            entry = this.findEntry(alias);
        }
        catch (Exception e) {
            throw new ProviderException(e);
        }
        if (entry == null) {
            return null;
        }
        return entry.cert.x509;
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        long initialDate;
        Entry entry;
        try {
            entry = this.findEntry(alias);
        }
        catch (Exception e) {
            throw new ProviderException(e);
        }
        if (entry == null) {
            return null;
        }
        long l = initialDate = entry.isTrustedCert() ? entry.cert.initialDate : entry.key.initialDate;
        if (initialDate < 0L) {
            return null;
        }
        return new Date(initialDate * 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        try {
            if (password != null && password.length != 0) {
                this.partition.login(new String(password));
            }
            UBPrivateKey privateKey = key instanceof UBPrivateKey ? (UBPrivateKey)key : null;
            Entry entry = this.findEntry(alias);
            if (entry != null) {
                if (entry.isTrustedCert()) {
                    throw new KeyStoreException("Trusted certificate entry present");
                }
                if (privateKey == null) {
                    this.engineDeleteEntry(alias);
                }
            }
            if (privateKey == null) {
                privateKey = UBPrivateKey.newPrivateKey(this.partition, alias, key);
            } else {
                privateKey.setName(alias);
            }
            X509Certificate x509 = (X509Certificate)chain[0];
            UBCertificate cert = UBCertificate.locate(this.partition, x509);
            if (cert == null) {
                cert = new UBCertificate(this.partition, alias, x509);
            } else {
                cert.setName(alias);
            }
            for (int i = 1; i < chain.length; ++i) {
                x509 = (X509Certificate)chain[1];
                UBCertificate chainCert = UBCertificate.locate(this.partition, x509);
                if (chainCert != null) continue;
                new UBCertificate(this.partition, alias, x509);
            }
            entry = new Entry(privateKey, cert, chain);
            UBKeyStore uBKeyStore = this;
            synchronized (uBKeyStore) {
                this.cache.put(alias, entry);
            }
        }
        catch (IOException | CertificateException | InvalidKeySpecException e) {
            throw new KeyStoreException(e);
        }
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        throw new KeyStoreException("Not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        try {
            Entry entry = this.findEntry(alias);
            if (entry != null) {
                if (!entry.isTrustedCert()) {
                    throw new KeyStoreException("Private key entry present");
                }
                this.engineDeleteEntry(alias);
            }
            UBCertificate c = new UBCertificate(this.partition, alias, (X509Certificate)cert);
            entry = new Entry(c);
            UBKeyStore uBKeyStore = this;
            synchronized (uBKeyStore) {
                this.cache.put(alias, entry);
            }
        }
        catch (IOException | CertificateException | InvalidKeySpecException e) {
            throw new KeyStoreException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        try {
            Entry entry = this.findEntry(alias);
            if (entry == null) {
                return;
            }
            UBObject.delete(this.partition, entry.cert, entry.key);
            UBKeyStore uBKeyStore = this;
            synchronized (uBKeyStore) {
                this.cache.remove(alias);
            }
        }
        catch (IOException | CertificateException | InvalidKeySpecException e) {
            throw new KeyStoreException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<String> engineAliases() {
        UBKeyStore uBKeyStore = this;
        synchronized (uBKeyStore) {
            long now = clock.millis();
            if (now < this.lastCacheClock + 30000L) {
                return Collections.enumeration(this.cache.keySet());
            }
        }
        try {
            long[] rsaIds = this.partition.locate(4, 4);
            long[] eccIds = this.partition.locate(4, 26);
            long[] keyIds = new long[rsaIds.length + eccIds.length];
            System.arraycopy(rsaIds, 0, keyIds, 0, rsaIds.length);
            System.arraycopy(eccIds, 0, keyIds, rsaIds.length, eccIds.length);
            long[] certIds = this.partition.locate(1, 0);
            UBObject[] keys = UBObject.read(this.partition, keyIds);
            UBObject[] certs = UBObject.read(this.partition, certIds);
            HashMap<String, Entry> cache = new HashMap<String, Entry>();
            for (UBObject object : keys) {
                UBPrivateKey key = (UBPrivateKey)object;
                UBCertificate found = null;
                for (int i = 0; i < certs.length; ++i) {
                    UBCertificate cert = (UBCertificate)certs[i];
                    if (cert == null || !cert.match(key.pub)) continue;
                    found = cert;
                    certs[i] = null;
                    break;
                }
                if (found == null) continue;
                Entry entry = new Entry(key, found, found.getChain(certs));
                cache.put(key.name.toUpperCase(), entry);
            }
            UBKeyStore uBKeyStore2 = this;
            synchronized (uBKeyStore2) {
                this.cache = cache;
                this.lastCacheClock = clock.millis();
            }
            return Collections.enumeration(cache.keySet());
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException | InvalidKeySpecException e) {
            throw new ProviderException(e);
        }
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        Entry entry = null;
        try {
            entry = this.findEntry(alias);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return entry != null;
    }

    @Override
    public int engineSize() {
        return 0;
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        Entry entry = null;
        try {
            entry = this.findEntry(alias);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return entry != null && !entry.isTrustedCert();
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        Entry entry = null;
        try {
            entry = this.findEntry(alias);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return entry != null && entry.isTrustedCert();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        if (!(cert instanceof X509Certificate)) {
            return null;
        }
        X509Certificate x509 = (X509Certificate)cert;
        UBKeyStore uBKeyStore = this;
        synchronized (uBKeyStore) {
            for (Entry entry : this.cache.values()) {
                if (!entry.cert.x509.equals(cert)) continue;
                return entry.getName();
            }
        }
        try {
            UBCertificate certificate = UBCertificate.locate(this.partition, x509);
            if (certificate == null) {
                return null;
            }
            long keyUid = UBCertificate.getKeyUid(x509);
            UBPrivateKey key = null;
            try {
                key = (UBPrivateKey)UBObject.read(this.partition, keyUid);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Entry entry = key == null ? new Entry(certificate) : new Entry(key, certificate, null);
            UBKeyStore uBKeyStore2 = this;
            synchronized (uBKeyStore2) {
                this.cache.put(entry.getName().toUpperCase(), entry);
            }
            return entry.getName();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (password != null && password.length != 0) {
            this.partition.login(new String(password));
        }
    }

    static final class Entry {
        UBPrivateKey key = null;
        UBCertificate cert = null;
        Certificate[] chain;

        Entry(UBPrivateKey key, UBCertificate cert, Certificate[] chain) throws InvalidKeySpecException, CertificateException, IOException {
            this.key = key;
            this.cert = cert;
            if (chain == null) {
                chain = cert.getChain();
            }
            this.chain = chain;
        }

        Entry(UBCertificate cert) {
            this.cert = cert;
            this.chain = null;
        }

        String getName() {
            return this.isTrustedCert() ? this.cert.name : this.key.name;
        }

        boolean isTrustedCert() {
            return this.key == null;
        }
    }
}

