/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider;

import com.unbound.common.Converter;
import com.unbound.common.HEX;
import com.unbound.provider.Partition;
import com.unbound.provider.UBCertificate;
import com.unbound.provider.UBPrivateKey;
import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.attribute.DateAttribute;
import com.unbound.provider.kmip.attribute.EnumAttribute;
import com.unbound.provider.kmip.attribute.Name;
import com.unbound.provider.kmip.request.DestroyRequest;
import com.unbound.provider.kmip.request.LocateRequest;
import com.unbound.provider.kmip.request.ModifyAttributeRequest;
import com.unbound.provider.kmip.request.RequestMessage;
import com.unbound.provider.kmip.request.RevokeRequest;
import com.unbound.provider.kmip.response.GetAttributesResponse;
import com.unbound.provider.kmip.response.GetResponse;
import com.unbound.provider.kmip.response.ResponseMessage;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;

abstract class UBObject {
    Partition partition;
    long uid;
    String name;
    long initialDate;

    static long strToUid(String str) {
        if (str.length() == 16) {
            str = "0x00" + str;
        }
        if (str.length() == 20 && str.charAt(0) == '0' && str.charAt(1) == 'x' && str.charAt(2) == '0' && str.charAt(3) == '0') {
            long uid = 0L;
            for (int i = 4; i < 20; i += 2) {
                int hi = HEX.from(str.charAt(i));
                int lo = HEX.from(str.charAt(i + 1));
                if (lo < 0 || hi < 0) {
                    return 0L;
                }
                uid = uid << 8 | (long)(hi << 4) | (long)lo;
            }
            return uid;
        }
        return 0L;
    }

    static String uidToStr(long uid) {
        byte[] cka_id = new byte[9];
        cka_id[0] = 0;
        Converter.setBE8(cka_id, 1, uid);
        char[] out = new char[20];
        out[0] = 48;
        out[1] = 120;
        for (int i = 0; i < cka_id.length; ++i) {
            out[2 + i * 2 + 0] = HEX.chars[cka_id[i] >> 4 & 0xF];
            out[2 + i * 2 + 1] = HEX.chars[cka_id[i] & 0xF];
        }
        return new String(out);
    }

    UBObject(Partition partition) {
        this.partition = partition;
    }

    UBObject(Partition partition, long uid, GetAttributesResponse getAttrResp) {
        this.partition = partition;
        this.uid = uid;
        this.name = ((Name)getAttrResp.attrs.get((int)2)).value;
        this.initialDate = ((DateAttribute)getAttrResp.attrs.get((int)3)).value;
    }

    abstract int objectType();

    static UBObject[] read(Partition partition, long[] uids) throws CertificateException, NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        if (uids.length == 0) {
            return new UBObject[0];
        }
        ResponseMessage respMsg = partition.read(uids);
        UBObject[] list = new UBObject[uids.length];
        for (int i = 0; i < uids.length; ++i) {
            GetAttributesResponse getAttrResp = (GetAttributesResponse)respMsg.batch.get(i * 2);
            GetResponse getResp = (GetResponse)respMsg.batch.get(i * 2 + 1);
            list[i] = UBObject.newObject(partition, uids[i], getAttrResp, getResp);
        }
        return list;
    }

    static UBObject read(Partition partition, long uid) throws CertificateException, InvalidKeySpecException, IOException {
        ResponseMessage respMsg = partition.read(uid);
        GetAttributesResponse getAttrResp = (GetAttributesResponse)respMsg.batch.get(0);
        GetResponse getResp = (GetResponse)respMsg.batch.get(1);
        return UBObject.newObject(partition, uid, getAttrResp, getResp);
    }

    private static UBObject newObject(Partition partition, long uid, GetAttributesResponse getAttrResp, GetResponse getResp) throws CertificateException, InvalidKeySpecException {
        int objectType = ((EnumAttribute)getAttrResp.attrs.get((int)0)).value;
        switch (objectType) {
            case 4: {
                return UBPrivateKey.newPrivateKey(partition, uid, getAttrResp, getResp);
            }
            case 1: {
                return new UBCertificate(partition, uid, getAttrResp, getResp);
            }
        }
        throw new ProviderException("Unsupported object type");
    }

    static LocateRequest locateRequest(int objectType, int keyType, String alias) {
        LocateRequest req = new LocateRequest();
        req.maxItems = 1;
        req.attrs.add(new EnumAttribute(KMIP.Tag.State, 2));
        req.attrs.add(new EnumAttribute(KMIP.Tag.ObjectType, objectType));
        if (keyType != 0) {
            req.attrs.add(new EnumAttribute(KMIP.Tag.CryptographicAlgorithm, keyType));
        }
        if (alias != null) {
            req.attrs.add(new Name(alias));
        }
        return req;
    }

    static void delete(Partition partition, UBObject obj1) throws IOException {
        UBObject.delete(partition, obj1, null, null);
    }

    static void delete(Partition partition, UBObject obj1, UBObject obj2) throws IOException {
        UBObject.delete(partition, obj1, obj2, null);
    }

    static void delete(Partition partition, UBObject obj1, UBObject obj2, UBObject obj3) throws IOException {
        RequestMessage reqMsg = new RequestMessage();
        RevokeRequest r = new RevokeRequest();
        r.uid = UBObject.uidToStr(obj1.uid);
        DestroyRequest d = new DestroyRequest();
        reqMsg.batch.add(r);
        reqMsg.batch.add(d);
        if (obj2 != null) {
            r = new RevokeRequest();
            r.uid = UBObject.uidToStr(obj2.uid);
            d = new DestroyRequest();
            reqMsg.batch.add(r);
            reqMsg.batch.add(d);
        }
        if (obj3 != null) {
            r = new RevokeRequest();
            r.uid = UBObject.uidToStr(obj3.uid);
            d = new DestroyRequest();
            reqMsg.batch.add(r);
            reqMsg.batch.add(d);
        }
        partition.transmit(reqMsg);
    }

    void setName(String name) throws IOException {
        if (this.name.equals(name)) {
            return;
        }
        ModifyAttributeRequest req = new ModifyAttributeRequest();
        req.uid = UBObject.uidToStr(this.uid);
        req.attribute = new Name(name);
        this.partition.transmit(req);
        this.name = name;
    }
}

