/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider;

import com.unbound.common.Log;
import com.unbound.common.crypto.EC;
import com.unbound.provider.Partition;
import com.unbound.provider.UBECPrivateKey;
import com.unbound.provider.UBObject;
import com.unbound.provider.UBRSAPrivateKey;
import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.attribute.CryptoParams;
import com.unbound.provider.kmip.attribute.DateAttribute;
import com.unbound.provider.kmip.attribute.EnumAttribute;
import com.unbound.provider.kmip.attribute.IntAttribute;
import com.unbound.provider.kmip.attribute.Name;
import com.unbound.provider.kmip.attribute.TemplateAttribute;
import com.unbound.provider.kmip.object.ManagedObject;
import com.unbound.provider.kmip.request.ActivateRequest;
import com.unbound.provider.kmip.request.CreateKeyPairRequest;
import com.unbound.provider.kmip.request.GetAttributesRequest;
import com.unbound.provider.kmip.request.GetRequest;
import com.unbound.provider.kmip.request.RegisterRequest;
import com.unbound.provider.kmip.request.RequestMessage;
import com.unbound.provider.kmip.request.SignRequest;
import com.unbound.provider.kmip.response.CreateKeyPairResponse;
import com.unbound.provider.kmip.response.GetAttributesResponse;
import com.unbound.provider.kmip.response.GetResponse;
import com.unbound.provider.kmip.response.RegisterResponse;
import com.unbound.provider.kmip.response.ResponseMessage;
import com.unbound.provider.kmip.response.SignResponse;
import java.io.IOException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.InvalidKeySpecException;

abstract class UBPrivateKey
extends UBObject
implements PrivateKey {
    PublicKey pub = null;

    UBPrivateKey(Partition partition) {
        super(partition);
    }

    @Override
    int objectType() {
        return 4;
    }

    abstract int keyType();

    UBPrivateKey(Partition partition, long uid, GetAttributesResponse getAttrResp) {
        super(partition, uid, getAttrResp);
    }

    static UBPrivateKey newPrivateKey(Partition partition, long uid, GetAttributesResponse getAttrResp, GetResponse getResp) throws InvalidKeySpecException {
        int keyType = ((EnumAttribute)getAttrResp.attrs.get((int)1)).value;
        switch (keyType) {
            case 26: {
                return new UBECPrivateKey(partition, uid, getAttrResp, getResp);
            }
            case 4: {
                return new UBRSAPrivateKey(partition, uid, getAttrResp, getResp);
            }
        }
        throw new ProviderException("Unsupported key type");
    }

    static UBPrivateKey newPrivateKey(Partition partition, String alias, Key key) throws InvalidKeySpecException, IOException {
        if (key instanceof RSAPrivateCrtKey) {
            return new UBRSAPrivateKey(partition, alias, (RSAPrivateCrtKey)key);
        }
        if (key instanceof ECPrivateKey) {
            return new UBECPrivateKey(partition, alias, (ECPrivateKey)key);
        }
        throw new ProviderException("Unsupported key type");
    }

    abstract PublicKey convertResponseToPublicKey(GetResponse var1) throws InvalidKeySpecException;

    abstract TemplateAttribute prepareGenerateTemplate(int var1, EC.Curve var2);

    void generate(int bitSize, EC.Curve curve) throws InvalidKeySpecException, IOException {
        Log log = Log.func("UBPrivateKey.generate").log("bitSize", bitSize).end();
        try {
            RequestMessage reqMsg = new RequestMessage();
            CreateKeyPairRequest reqCreateKeyPair = new CreateKeyPairRequest();
            reqMsg.batch.add(reqCreateKeyPair);
            reqCreateKeyPair.prv = this.prepareGenerateTemplate(bitSize, curve);
            ActivateRequest reqActivate = new ActivateRequest();
            reqMsg.batch.add(reqActivate);
            GetAttributesRequest reqGetAttr = new GetAttributesRequest();
            reqMsg.batch.add(reqGetAttr);
            reqGetAttr.names.add("Name");
            reqGetAttr.names.add("Initial Date");
            GetRequest reqGet = new GetRequest();
            reqMsg.batch.add(reqGet);
            reqGet.formatType = 5;
            ResponseMessage respMsg = this.partition.transmit(reqMsg);
            CreateKeyPairResponse respCreateKeyPair = (CreateKeyPairResponse)respMsg.batch.get(0);
            GetAttributesResponse respGetAttr = (GetAttributesResponse)respMsg.batch.get(2);
            GetResponse respGet = (GetResponse)respMsg.batch.get(3);
            this.uid = UBPrivateKey.strToUid(respCreateKeyPair.prvUID);
            this.name = ((Name)respGetAttr.attrs.get((int)0)).value;
            this.initialDate = ((DateAttribute)respGetAttr.attrs.get((int)1)).value;
            this.pub = this.convertResponseToPublicKey(respGet);
        }
        catch (Exception e) {
            log.failed(e);
            throw e;
        }
        finally {
            log.leavePrint().logHex("UID", this.uid).end();
        }
    }

    void register(String alias, int kmipAlg, int kmipUsage, ManagedObject managedObject) throws InvalidKeySpecException, IOException {
        RequestMessage reqMsg = new RequestMessage();
        RegisterRequest reqRegister = new RegisterRequest();
        reqMsg.batch.add(reqRegister);
        reqRegister.objectType = 4;
        reqRegister.template = new TemplateAttribute();
        reqRegister.template.attrs.add(new EnumAttribute(KMIP.Tag.CryptographicAlgorithm, kmipAlg));
        reqRegister.template.attrs.add(new IntAttribute(KMIP.Tag.CryptographicUsageMask, kmipUsage));
        if (alias != null) {
            reqRegister.template.attrs.add(new Name(alias));
        }
        reqRegister.object = managedObject;
        ActivateRequest reqActivate = new ActivateRequest();
        reqMsg.batch.add(reqActivate);
        GetAttributesRequest reqGetAttr = new GetAttributesRequest();
        reqMsg.batch.add(reqGetAttr);
        reqGetAttr.names.add("Name");
        reqGetAttr.names.add("Initial Date");
        GetRequest reqGet = new GetRequest();
        reqMsg.batch.add(reqGet);
        reqGet.formatType = 5;
        ResponseMessage respMsg = this.partition.transmit(reqMsg);
        RegisterResponse respRegister = (RegisterResponse)respMsg.batch.get(0);
        GetAttributesResponse respGetAttr = (GetAttributesResponse)respMsg.batch.get(2);
        GetResponse respGet = (GetResponse)respMsg.batch.get(3);
        this.uid = UBPrivateKey.strToUid(respRegister.uid);
        this.name = alias == null ? ((Name)respGetAttr.attrs.get((int)0)).value : alias;
        this.initialDate = ((DateAttribute)respGetAttr.attrs.get((int)1)).value;
        this.pub = this.convertResponseToPublicKey(respGet);
    }

    static UBPrivateKey locate(Partition partition, String alias) throws InvalidKeySpecException, CertificateException, IOException {
        long uid = 0L;
        Log log = Log.func("UBPrivateKey.locate").log("alias", alias).end();
        try {
            uid = partition.locate(4, 0, alias);
            if (uid == 0L) {
                UBPrivateKey uBPrivateKey = null;
                return uBPrivateKey;
            }
            UBPrivateKey uBPrivateKey = (UBPrivateKey)UBObject.read(partition, uid);
            return uBPrivateKey;
        }
        catch (Exception e) {
            log.failed(e);
            throw e;
        }
        finally {
            log.leavePrint().logHex("uid", uid).end();
        }
    }

    byte[] sign(byte[] in, int kmipAlg, int kmipSigAlg) throws IOException {
        Log log = Log.func("UBPrivateKey.sign").log("kmipAlg", kmipAlg).log("kmipSigAlg", kmipSigAlg).log("in.length", in.length).end();
        try {
            SignRequest req = new SignRequest();
            req.uid = UBPrivateKey.uidToStr(this.uid);
            req.data = in;
            req.params = new CryptoParams();
            req.params.cryptoAlg = kmipAlg;
            if (kmipAlg == 4) {
                req.params.padding = 8;
            }
            if (kmipSigAlg != 0) {
                req.params.signingAlg = kmipSigAlg;
            }
            SignResponse resp = (SignResponse)this.partition.transmit(req);
            byte[] byArray = resp.data;
            return byArray;
        }
        catch (Exception e) {
            log.failed(e);
            throw e;
        }
        finally {
            log.leave();
        }
    }
}

