/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider;

import com.unbound.common.Converter;
import com.unbound.common.Log;
import com.unbound.common.crypto.EC;
import com.unbound.common.crypto.SHA256;
import com.unbound.common.crypto.SystemProvider;
import com.unbound.provider.Partition;
import com.unbound.provider.UBPrivateKey;
import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.attribute.CryptoParams;
import com.unbound.provider.kmip.attribute.EnumAttribute;
import com.unbound.provider.kmip.attribute.IntAttribute;
import com.unbound.provider.kmip.attribute.MessageExt;
import com.unbound.provider.kmip.attribute.TemplateAttribute;
import com.unbound.provider.kmip.object.ManagedObject;
import com.unbound.provider.kmip.object.PrivateKey;
import com.unbound.provider.kmip.request.DecryptRequest;
import com.unbound.provider.kmip.response.DecryptResponse;
import com.unbound.provider.kmip.response.GetAttributesResponse;
import com.unbound.provider.kmip.response.GetResponse;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.X509EncodedKeySpec;

public final class UBRSAPrivateKey
extends UBPrivateKey
implements RSAPrivateCrtKey {
    UBRSAPrivateKey(Partition partition) {
        super(partition);
    }

    @Override
    int keyType() {
        return 4;
    }

    UBRSAPrivateKey(Partition partition, long uid, GetAttributesResponse getAttrResp, GetResponse get) throws InvalidKeySpecException {
        super(partition, uid, getAttrResp);
        Log log = Log.func("UBRSAPrivateKey").logHex("uid", uid).end();
        try {
            this.pub = this.convertResponseToPublicKey(get);
        }
        catch (Exception e) {
            log.failed(e);
            throw e;
        }
        finally {
            log.leave();
        }
    }

    UBRSAPrivateKey(Partition partition, String alias, RSAPrivateCrtKey key) throws InvalidKeySpecException, IOException {
        super(partition);
        this.register(alias, 4, 9, this.prepareManagedObject(key));
    }

    UBRSAPrivateKey(Partition partition, KeySpec keySpec) throws InvalidKeySpecException, IOException {
        super(partition);
        this.register(null, 4, 9, this.prepareManagedObject(keySpec));
    }

    @Override
    PublicKey convertResponseToPublicKey(GetResponse get) throws InvalidKeySpecException {
        PrivateKey kmipManagedObject = (PrivateKey)get.object;
        X509EncodedKeySpec spec = new X509EncodedKeySpec(kmipManagedObject.keyBlock.buf);
        KeyFactory kf = SystemProvider.KeyFactory.getInstance("RSA");
        return kf.generatePublic(spec);
    }

    @Override
    TemplateAttribute prepareGenerateTemplate(int bitSize, EC.Curve curve) {
        int usage = 9;
        TemplateAttribute template = new TemplateAttribute();
        template.attrs.add(new EnumAttribute(KMIP.Tag.CryptographicAlgorithm, 4));
        template.attrs.add(new IntAttribute(KMIP.Tag.CryptographicLength, bitSize));
        template.attrs.add(new IntAttribute(KMIP.Tag.CryptographicUsageMask, usage));
        return template;
    }

    private ManagedObject prepareManagedObjectCrt(RSAPrivateCrtKeySpec keySpec) {
        PrivateKey mo = new PrivateKey();
        mo.keyBlock.formatType = 10;
        mo.keyBlock.N = keySpec.getModulus();
        mo.keyBlock.E = keySpec.getPublicExponent();
        mo.keyBlock.D = keySpec.getPrivateExponent();
        mo.keyBlock.P = keySpec.getPrimeP();
        mo.keyBlock.Q = keySpec.getPrimeP();
        mo.keyBlock.DP = keySpec.getPrimeExponentP();
        mo.keyBlock.DQ = keySpec.getPrimeExponentQ();
        mo.keyBlock.QINV = keySpec.getCrtCoefficient();
        return mo;
    }

    private ManagedObject prepareManagedObjectPkcs8(PKCS8EncodedKeySpec keySpec) {
        PrivateKey mo = new PrivateKey();
        mo.keyBlock.formatType = 4;
        mo.keyBlock.buf = keySpec.getEncoded();
        return mo;
    }

    private ManagedObject prepareManagedObject(KeySpec keySpec) {
        if (keySpec instanceof RSAPrivateCrtKeySpec) {
            return this.prepareManagedObjectCrt((RSAPrivateCrtKeySpec)keySpec);
        }
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            return this.prepareManagedObjectPkcs8((PKCS8EncodedKeySpec)keySpec);
        }
        return null;
    }

    private ManagedObject prepareManagedObject(RSAPrivateCrtKey key) {
        PrivateKey mo = new PrivateKey();
        mo.keyBlock.formatType = 10;
        mo.keyBlock.N = key.getModulus();
        mo.keyBlock.E = key.getPublicExponent();
        mo.keyBlock.D = key.getPrivateExponent();
        mo.keyBlock.P = key.getPrimeP();
        mo.keyBlock.Q = key.getPrimeP();
        mo.keyBlock.DP = key.getPrimeExponentP();
        mo.keyBlock.DQ = key.getPrimeExponentQ();
        mo.keyBlock.QINV = key.getCrtCoefficient();
        return mo;
    }

    RSAPublicKey rsaPublicKey() {
        return (RSAPublicKey)this.pub;
    }

    int getBitSize() {
        return this.rsaPublicKey().getModulus().bitLength();
    }

    static long getKeyUid(RSAPublicKey pub) {
        byte[] hash = SHA256.hash(pub.getModulus().toByteArray());
        return Converter.getBE8(hash, 0);
    }

    byte[] decrypt(byte[] in, int kmipPadding, int kmipHashAlg, int kmipMgfAlg, byte[] label) throws IOException {
        DecryptRequest req = new DecryptRequest();
        req.uid = UBRSAPrivateKey.uidToStr(this.uid);
        req.params = new CryptoParams();
        req.params.cryptoAlg = 4;
        req.params.padding = kmipPadding;
        req.data = in;
        if (kmipPadding == 2) {
            req.params.hashingAlg = kmipHashAlg;
            req.ext = new MessageExt();
            req.ext.mgf = kmipMgfAlg;
            if (label != null && label.length != 0) {
                req.ext.auth.add(label);
            }
        }
        DecryptResponse resp = (DecryptResponse)this.partition.transmit(req);
        return resp.data;
    }

    @Override
    public BigInteger getPublicExponent() {
        return this.rsaPublicKey().getPublicExponent();
    }

    @Override
    public BigInteger getPrimeP() {
        return null;
    }

    @Override
    public BigInteger getPrimeQ() {
        return null;
    }

    @Override
    public BigInteger getPrimeExponentP() {
        return null;
    }

    @Override
    public BigInteger getPrimeExponentQ() {
        return null;
    }

    @Override
    public BigInteger getCrtCoefficient() {
        return null;
    }

    @Override
    public BigInteger getPrivateExponent() {
        return null;
    }

    @Override
    public String getAlgorithm() {
        return "RSA";
    }

    @Override
    public String getFormat() {
        return "N/A";
    }

    @Override
    public byte[] getEncoded() {
        return null;
    }

    @Override
    public BigInteger getModulus() {
        return this.rsaPublicKey().getModulus();
    }
}

