/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider.kmip;

public class KMIP {
    private static int stdTag(int x, int y) {
        return 0x42000000 | x << 8 | y;
    }

    private static int extTag(int x, int y) {
        return 0x54000000 | x << 8 | y;
    }

    public static int tagAttributeValue(int y) {
        return KMIP.stdTag(11, y);
    }

    private static int tagStruct(int x) {
        return KMIP.stdTag(x, 1);
    }

    private static int tagInt(int x) {
        return KMIP.stdTag(x, 2);
    }

    private static int tagInt64(int x) {
        return KMIP.stdTag(x, 3);
    }

    private static int tagBigInt(int x) {
        return KMIP.stdTag(x, 4);
    }

    private static int tagEnum(int x) {
        return KMIP.stdTag(x, 5);
    }

    private static int tagBool(int x) {
        return KMIP.stdTag(x, 6);
    }

    private static int tagText(int x) {
        return KMIP.stdTag(x, 7);
    }

    private static int tagBytes(int x) {
        return KMIP.stdTag(x, 8);
    }

    private static int tagDateTime(int x) {
        return KMIP.stdTag(x, 9);
    }

    private static int tagInterval(int x) {
        return KMIP.stdTag(x, 10);
    }

    private static int extTagInt(int x) {
        return KMIP.extTag(x, 2);
    }

    private static int extTagInt64(int x) {
        return KMIP.extTag(x, 3);
    }

    private static int extTagEnum(int x) {
        return KMIP.extTag(x, 5);
    }

    private static int extTagBool(int x) {
        return KMIP.extTag(x, 6);
    }

    private static int extTagBytes(int x) {
        return KMIP.extTag(x, 8);
    }

    private static int extTagText(int x) {
        return KMIP.extTag(x, 7);
    }

    private static int extTagBigInt(int x) {
        return KMIP.extTag(x, 4);
    }

    private static int extTagDateTime(int x) {
        return KMIP.extTag(x, 9);
    }

    private static int extTagStructure(int x) {
        return KMIP.extTag(x, 1);
    }

    static /* synthetic */ int access$000(int x0) {
        return KMIP.tagDateTime(x0);
    }

    static /* synthetic */ int access$100(int x0) {
        return KMIP.tagText(x0);
    }

    static /* synthetic */ int access$200(int x0) {
        return KMIP.tagStruct(x0);
    }

    static /* synthetic */ int access$300(int x0) {
        return KMIP.tagBytes(x0);
    }

    static /* synthetic */ int access$400(int x0) {
        return KMIP.tagBool(x0);
    }

    static /* synthetic */ int access$500(int x0) {
        return KMIP.tagInt(x0);
    }

    static /* synthetic */ int access$600(int x0) {
        return KMIP.tagEnum(x0);
    }

    static /* synthetic */ int access$700(int x0) {
        return KMIP.tagBigInt(x0);
    }

    static /* synthetic */ int access$800(int x0) {
        return KMIP.tagInterval(x0);
    }

    static /* synthetic */ int access$900(int x0) {
        return KMIP.tagInt64(x0);
    }

    static /* synthetic */ int access$1000(int x0) {
        return KMIP.extTagEnum(x0);
    }

    static /* synthetic */ int access$1100(int x0) {
        return KMIP.extTagBool(x0);
    }

    static /* synthetic */ int access$1200(int x0) {
        return KMIP.extTagText(x0);
    }

    static /* synthetic */ int access$1300(int x0) {
        return KMIP.extTagBytes(x0);
    }

    static /* synthetic */ int access$1400(int x0) {
        return KMIP.extTagDateTime(x0);
    }

    static /* synthetic */ int access$1500(int x0) {
        return KMIP.extTagBigInt(x0);
    }

    static /* synthetic */ int access$1600(int x0) {
        return KMIP.extTagInt(x0);
    }

    static /* synthetic */ int access$1700(int x0) {
        return KMIP.extTagInt64(x0);
    }

    static /* synthetic */ int access$1800(int x0) {
        return KMIP.extTagStructure(x0);
    }

    public static class DyPartitionFipsRequirements {
        public static final int None = 0;
        public static final int Preferred = 1;
        public static final int Mandatory = 2;
    }

    public static class DyGrantType {
        public static final int None = 0;
        public static final int ClientCredentials = 1;
        public static final int Password = 2;
        public static final int JwtBearer = 3;
    }

    public static class DyPeriod {
        public static final int None = 0;
        public static final int LastDay = 1;
        public static final int LastWeek = 2;
        public static final int LastMonth = 3;
        public static final int LastYear = 4;
    }

    public static class DyMode {
        public static final int None = 0;
        public static final int Activation = 1;
        public static final int Csr = 2;
        public static final int Full = 3;
        public static final int External = 4;
        public static final int Template = 5;
        public static final int Ephemeral = 6;
        public static final int Secret = 7;
        public static final int PublicKey = 8;
    }

    public static class CryptographicUsageMask {
        public static final int Sign = 1;
        public static final int Verify = 2;
        public static final int Encrypt = 4;
        public static final int Decrypt = 8;
        public static final int WrapKey = 16;
        public static final int UnwrapKey = 32;
        public static final int Export = 64;
        public static final int MACGenerate = 128;
        public static final int MACVerify = 256;
        public static final int DeriveKey = 512;
        public static final int ContentCommitment = 1024;
        public static final int KeyAgreement = 2048;
        public static final int CertificateSign = 4096;
        public static final int CrlSign = 8192;
        public static final int GenerateCryptogram = 16384;
        public static final int ValidateCryptogram = 32768;
        public static final int TranslateEncrypt = 65536;
        public static final int TranslateDecrypt = 131072;
        public static final int TranslateWrap = 262144;
        public static final int TranslateUnwrap = 524288;
    }

    public static class MaskGenerator {
        public static final int MGF1 = 1;
    }

    public static class KeyWrapType {
        public static final int NotWrapped = 1;
        public static final int AsRegistered = 2;
    }

    public static class ClientRegistrationMethod {
        public static final int Unspecified = 1;
        public static final int ServerPreGenerated = 2;
        public static final int ServerOnDemand = 3;
        public static final int ClientGenerated = 4;
        public static final int ClientRegistered = 5;
    }

    public static class RNGMode {
        public static final int Unspecified = 1;
        public static final int SharedInstantiation = 2;
        public static final int NonSharedInstantiation = 3;
    }

    public static class ShreddingAlgorithm {
        public static final int Unspecified = 1;
        public static final int Cryptographic = 2;
        public static final int Unsupported = 3;
    }

    public static class DestroyAction {
        public static final int Unspecified = 1;
        public static final int KeyMaterialDeleted = 2;
        public static final int KeyMaterialShredded = 3;
        public static final int MetaDataDeleted = 4;
        public static final int MetaDataShredded = 5;
        public static final int Deleted = 6;
        public static final int Shredded = 7;
    }

    public static class UnwrapMode {
        public static final int Unspecified = 1;
        public static final int Processed = 2;
        public static final int NotProcessed = 3;
    }

    public static class ValidationType {
        public static final int Unspecified = 1;
        public static final int Hardware = 2;
        public static final int Software = 3;
        public static final int Firmware = 4;
        public static final int Hybrid = 5;
    }

    public static class ValidationAuthorityType {
        public static final int Unspecified = 1;
        public static final int NISTCMVP = 2;
        public static final int CommonCriteria = 3;
    }

    public static class DRBGAlgorithm {
        public static final int Unspecified = 1;
        public static final int Dual_EC = 2;
        public static final int Hash = 3;
        public static final int HMAC = 4;
        public static final int CTR = 5;
    }

    public static class RNGAlgorithm {
        public static final int Unspecified = 1;
        public static final int FIPS186_2 = 2;
        public static final int DRBG = 3;
        public static final int NRBG = 4;
        public static final int ANSIX9_31 = 5;
        public static final int ANSIX9_62 = 6;
        public static final int DyRngAlg = -2147483647;
    }

    public static class KeyValueLocationType {
        public static final int UninterpretedTextString = 1;
        public static final int URI = 2;
    }

    public static class AlternativeNameType {
        public static final int UninterpretedTextString = 1;
        public static final int URI = 2;
        public static final int ObjectSerialNumber = 3;
        public static final int EmailAddress = 4;
        public static final int DNSName = 5;
        public static final int X_500DistinguishedName = 6;
        public static final int IPAddress = 7;
    }

    public static class ObjectGroupMember {
        public static final int GroupMemberFresh = 1;
        public static final int GroupMemberDefault = 2;
    }

    public static class EncodingOption {
        public static final int NoEncoding = 1;
        public static final int TTLVEncoding = 2;
    }

    public static class UsageLimitsUnit {
        public static final int Byte = 1;
        public static final int Object = 2;
    }

    public static class BatchErrorContinuationOption {
        public static final int Continue = 1;
        public static final int Stop = 2;
        public static final int Undo = 3;
    }

    public static class ResultReason {
        public static final int ItemNotFound = 1;
        public static final int ResponseTooLarge = 2;
        public static final int AuthenticationNotSuccessful = 3;
        public static final int InvalidMessage = 4;
        public static final int OperationNotSupported = 5;
        public static final int MissingData = 6;
        public static final int InvalidField = 7;
        public static final int FeatureNotSupported = 8;
        public static final int OperationCanceledByRequester = 9;
        public static final int CryptographicFailure = 10;
        public static final int IllegalOperation = 11;
        public static final int PermissionDenied = 12;
        public static final int ObjectArchived = 13;
        public static final int IndexOutOfBounds = 14;
        public static final int ApplicationNamespaceNotSupported = 15;
        public static final int KeyFormatTypeNotSupported = 16;
        public static final int KeyCompressionTypeNotSupported = 17;
        public static final int EncodingOptionError = 18;
        public static final int KeyValueNotPresent = 19;
        public static final int AttestationRequired = 20;
        public static final int AttestationFailed = 21;
        public static final int GeneralFailure = 256;
    }

    public static class ResultStatus {
        public static final int Success = 0;
        public static final int OperationFailed = 1;
        public static final int OperationPending = 2;
        public static final int OperationUndone = 3;
        public static final int DyFatalError = -2147483647;
    }

    public static class Operation {
        public static final int Create = 1;
        public static final int CreateKeyPair = 2;
        public static final int Register = 3;
        public static final int ReKey = 4;
        public static final int DeriveKey = 5;
        public static final int Certify = 6;
        public static final int ReCertify = 7;
        public static final int Locate = 8;
        public static final int Check = 9;
        public static final int Get = 10;
        public static final int GetAttributes = 11;
        public static final int GetAttributeList = 12;
        public static final int AddAttribute = 13;
        public static final int ModifyAttribute = 14;
        public static final int DeleteAttribute = 15;
        public static final int ObtainLease = 16;
        public static final int GetUsageAllocation = 17;
        public static final int Activate = 18;
        public static final int Revoke = 19;
        public static final int Destroy = 20;
        public static final int Archive = 21;
        public static final int Recover = 22;
        public static final int Validate = 23;
        public static final int Query = 24;
        public static final int Cancel = 25;
        public static final int Poll = 26;
        public static final int Notify = 27;
        public static final int Put = 28;
        public static final int ReKeyPair = 29;
        public static final int DiscoverVersions = 30;
        public static final int Encrypt = 31;
        public static final int Decrypt = 32;
        public static final int Sign = 33;
        public static final int SignatureVerify = 34;
        public static final int MAC = 35;
        public static final int MACVerify = 36;
        public static final int RNGRetrieve = 37;
        public static final int RNGSeed = 38;
        public static final int Hash = 39;
        public static final int CreateSplitKey = 40;
        public static final int JoinSplitKey = 41;
        public static final int DyCreate = -2147483647;
        public static final int DyDestroy = -2147483646;
        public static final int DyLocate = -2147483645;
        public static final int DyGet = -2147483644;
        public static final int DyModifyAttribute = -2147483643;
        public static final int DyModifyAttributes = -2147483642;
        public static final int DyRegister = -2147483641;
        public static final int DyRefreshKey = -2147483640;
        public static final int DyDerive = -2147483639;
        public static final int DyWrap = -2147483638;
        public static final int DyUnWrap = -2147483637;
        public static final int DyUpdateData = -2147483636;
        public static final int DyAddPair = -2147483633;
        public static final int DyAddAuxiliary = -2147483632;
        public static final int DyRemovePair = -2147483631;
        public static final int DyRemoveAuxiliary = -2147483630;
        public static final int DyGetTopology = -2147483629;
        public static final int DyTestTopology = -2147483628;
        public static final int DyLogin = -2147483627;
        public static final int DyUpdateUserPassword = -2147483626;
        public static final int DyRecoverSoPassword = -2147483625;
        public static final int DyRecoverPartition = -2147483624;
        public static final int DyGetAttributes = -2147483623;
        public static final int DyGetRootCaCertificate = -2147483616;
        public static final int DyGetQuorumTransaction = -2147483615;
        public static final int DyListQuorumTransactions = -2147483614;
        public static final int DyDeleteQuorumTransaction = -2147483613;
        public static final int DyApproveQuorumTransaction = -2147483612;
        public static final int DyGetSelfCertificate = -2147483611;
        public static final int DyGetServerCertificate = -2147483610;
        public static final int DyExecuteQuorumTransaction = -2147483609;
        public static final int DyDestroySecretData = -2147483608;
        public static final int DyUpdateSecretData = -2147483607;
        public static final int DyRenewClientCertificate = -2147483606;
        public static final int DyUpdateRole = -2147483605;
        public static final int DyTestHealth = -2147483604;
        public static final int DyGetObjectGroups = -2147483603;
        public static final int DyChangePartitionUserRole = -2147483602;
        public static final int DyLogout = -2147483601;
        public static final int DyGetSystemKey = -2147483600;
        public static final int DyCreateSecretData = -2147483599;
        public static final int DyAddTriplet = -2147483598;
        public static final int DyCreatePartition = -2147483584;
        public static final int DyDestroyPartition = -2147483583;
        public static final int DyGetKeyMaterial = -2147483582;
        public static final int DyGenerateTrustedKey = -2147483581;
        public static final int DyGetSecretData = -2147483580;
        public static final int DyCreateSoUser = -2147483579;
        public static final int DyDeleteSoUser = -2147483578;
        public static final int DyUpdateUserRetries = -2147483577;
        public static final int DyDestroyStaticUsers = -2147483576;
        public static final int DyDestroyStaticRoles = -2147483575;
        public static final int DyModifyProtectedAttribute = -2147483568;
        public static final int DyGetProtectedAttribute = -2147483567;
        public static final int DySetQuorumTransaction = -2147483566;
        public static final int DyRecoverQuorumValue = -2147483565;
        public static final int DyUpdateSoLastActivity = -2147483564;
        public static final int DyCreateClient = -2147483563;
        public static final int DyDeleteClient = -2147483562;
        public static final int DyCreatePartitionUser = -2147483561;
        public static final int DyDeletePartitionUser = -2147483560;
        public static final int DyRecoverRootSoPassword = -2147483559;
        public static final int DyLocatePartitions = -2147483558;
        public static final int DyGetPartition = -2147483557;
        public static final int DyCryptoDeriveKey = -2147483556;
        public static final int DyUpdateClientVersion = -2147483555;
        public static final int DyRefreshClientActivationCode = -2147483554;
        public static final int DyUpdateClient = -2147483553;
        public static final int DyGetObfuscatedAttribute = -2147483552;
        public static final int DyPrecreateObject = -2147483551;
        public static final int DyBackupDB = -2147483550;
        public static final int DyRemoveFromCache = -2147483549;
        public static final int DyUpdateReadOnlyAttributes = -2147483548;
        public static final int DyListDbBackup = -2147483547;
        public static final int DyDeleteDbBackup = -2147483546;
        public static final int DyGetDbBackup = -2147483545;
        public static final int DySignLogs = -2147483544;
        public static final int DyRefreshClientSecret = -2147483543;
        public static final int DyRefreshClientPublicKey = -2147483542;
        public static final int DyCreateRole = -2147483541;
        public static final int DyDeleteRole = -2147483540;
    }

    public static class PutFunction {
        public static final int New = 1;
        public static final int Replace = 2;
    }

    public static class CancellationResult {
        public static final int Canceled = 1;
        public static final int UnableToCancel = 2;
        public static final int Completed = 3;
        public static final int Failed = 4;
        public static final int Unavailable = 5;
    }

    public static class QueryFunction {
        public static final int QueryOperations = 1;
        public static final int QueryObjects = 2;
        public static final int QueryServerInformation = 3;
        public static final int QueryApplicationNamespaces = 4;
        public static final int QueryExtensionList = 5;
        public static final int QueryExtensionMap = 6;
        public static final int QueryAttestationTypes = 7;
        public static final int QueryRNGs = 8;
        public static final int QueryValidations = 9;
        public static final int QueryProfiles = 10;
        public static final int QueryCapabilities = 11;
        public static final int QueryClientRegistrationMethods = 12;
    }

    public static class ValidityIndicator {
        public static final int Valid = 1;
        public static final int Invalid = 2;
        public static final int Unknown = 3;
    }

    public static class CertificateRequestType {
        public static final int CRMF = 1;
        public static final int PKCS_10 = 2;
        public static final int PEM = 3;
        public static final int PGP = 4;
    }

    public static class DerivationMethod {
        public static final int Pbkdf2 = 1;
        public static final int Hash = 2;
        public static final int Hmac = 3;
        public static final int Encrypt = 4;
        public static final int NIST800_108_C = 5;
        public static final int NIST800_108_F = 6;
        public static final int NIST800_108_DPI = 7;
        public static final int DyConcat = -2147483647;
        public static final int DyEcdsaBipNormal = -2147483646;
        public static final int DyEcdsaBipHardened = -2147483645;
        public static final int DyEcdsaToEddsa = -2147483644;
        public static final int DyEcdsaBipCaspHardened = -2147483643;
        public static final int DyEddsaBipNormal = -2147483642;
        public static final int DyEddsaBipHardened = -2147483641;
        public static final int DyEddsaBipCaspHardened = -2147483640;
    }

    public static class LinkType {
        public static final int CertificateLink = 257;
        public static final int PublicKeyLink = 258;
        public static final int PrivateKeyLink = 259;
        public static final int DerivationBaseObjectLink = 260;
        public static final int DerivedKeyLink = 261;
        public static final int ReplacementObjectLink = 262;
        public static final int ReplacedObjectLink = 263;
        public static final int ParentLink = 264;
        public static final int ChildLink = 265;
        public static final int PreviousLink = 266;
        public static final int NextLink = 267;
        public static final int PKCS_12CertificateLink = 268;
        public static final int PKCS_12PasswordLink = 269;
    }

    public static class RevocationReasonCode {
        public static final int Unspecified = 1;
        public static final int KeyCompromise = 2;
        public static final int CACompromise = 3;
        public static final int AffiliationChanged = 4;
        public static final int Superseded = 5;
        public static final int CessationofOperation = 6;
        public static final int PrivilegeWithdrawn = 7;
    }

    public static class State {
        public static final int PreActive = 1;
        public static final int Active = 2;
        public static final int Deactivated = 3;
        public static final int Compromised = 4;
        public static final int Destroyed = 5;
        public static final int DestroyedCompromised = 6;
    }

    public static class KeyRoleType {
        public static final int BDK = 1;
        public static final int CVK = 2;
        public static final int DEK = 3;
        public static final int MKAC = 4;
        public static final int MKSMC = 5;
        public static final int MKSMI = 6;
        public static final int MKDAC = 7;
        public static final int MKDN = 8;
        public static final int MKCP = 9;
        public static final int MKOTH = 10;
        public static final int KEK = 11;
        public static final int MAC16609 = 12;
        public static final int MAC97971 = 13;
        public static final int MAC97972 = 14;
        public static final int MAC97973 = 15;
        public static final int MAC97974 = 16;
        public static final int MAC97975 = 17;
        public static final int ZPK = 18;
        public static final int PVKIBM = 19;
        public static final int PVKPVV = 20;
        public static final int PVKOTH = 21;
        public static final int DUKPT = 22;
        public static final int IV = 23;
        public static final int TRKBK = 24;
    }

    public static class HashingAlgorithm {
        public static final int MD2 = 1;
        public static final int MD4 = 2;
        public static final int MD5 = 3;
        public static final int SHA_1 = 4;
        public static final int SHA_224 = 5;
        public static final int SHA_256 = 6;
        public static final int SHA_384 = 7;
        public static final int SHA_512 = 8;
        public static final int RIPEMD_160 = 9;
        public static final int TIGER = 10;
        public static final int WHIRLPOOL = 11;
    }

    public static class PaddingMethod {
        public static final int None = 1;
        public static final int OAEP = 2;
        public static final int PKCS5 = 3;
        public static final int SSL3 = 4;
        public static final int Zeros = 5;
        public static final int ANSIX9_23 = 6;
        public static final int ISO = 7;
        public static final int PKCS1_V1_5 = 8;
        public static final int X9_31 = 9;
        public static final int PSS = 10;
        public static final int DyPrefix = -2147483647;
        public static final int DySuffix = -2147483646;
    }

    public static class BlockCipherMode {
        public static final int CBC = 1;
        public static final int ECB = 2;
        public static final int PCBC = 3;
        public static final int CFB = 4;
        public static final int OFB = 5;
        public static final int CTR = 6;
        public static final int CMAC = 7;
        public static final int CCM = 8;
        public static final int GCM = 9;
        public static final int CBCMAC = 10;
        public static final int XTS = 11;
        public static final int AESKeyWrappadding = 12;
        public static final int NISTKeyWrap = 13;
        public static final int SIV = -2147483647;
        public static final int GMAC = -2147483646;
    }

    public static class CryptographicAlgorithm {
        public static final int DES = 1;
        public static final int DES3 = 2;
        public static final int AES = 3;
        public static final int RSA = 4;
        public static final int DSA = 5;
        public static final int ECDSA = 6;
        public static final int HMAC_SHA1 = 7;
        public static final int HMAC_SHA224 = 8;
        public static final int HMAC_SHA256 = 9;
        public static final int HMAC_SHA384 = 10;
        public static final int HMAC_SHA512 = 11;
        public static final int HMAC_MD5 = 12;
        public static final int DH = 13;
        public static final int ECDH = 14;
        public static final int ECMQV = 15;
        public static final int Blowfish = 16;
        public static final int Camellia = 17;
        public static final int Cast5 = 18;
        public static final int Idea = 19;
        public static final int Mars = 20;
        public static final int RC2 = 21;
        public static final int RC4 = 22;
        public static final int RC5 = 23;
        public static final int Skipjack = 24;
        public static final int Twofish = 25;
        public static final int EC = 26;
        public static final int DyPRF = -2147483647;
        public static final int DyPWD = -2147483646;
        public static final int DyAES_SIV = -2147483645;
        public static final int DyAES_XTS = -2147483644;
        public static final int DyLIMA = -2147483643;
        public static final int DyECDSAEnc = -2147483642;
        public static final int DyDeriveConcat = -2147483641;
        public static final int DyEDDSA = -2147483640;
        public static final int DyPrfCMacCtr = -2147483639;
        public static final int DySchnorr = -2147483638;
    }

    public static class DyObjectGroup {
        public static final int Crypto = -2147483638;
        public static final int SecretData = -2147483636;
        public static final int PublicData = -2147483635;
    }

    public static class ObjectType {
        public static final int None = 0;
        public static final int Certificate = 1;
        public static final int SymmetricKey = 2;
        public static final int PublicKey = 3;
        public static final int PrivateKey = 4;
        public static final int SplitKey = 5;
        public static final int Template = 6;
        public static final int SecretData = 7;
        public static final int OpaqueObject = 8;
        public static final int PGPKey = 9;
        public static final int DyPartition = -2147483647;
        public static final int DyClient = -2147483646;
        public static final int DyPartitionUser = -2147483645;
        public static final int DyRole = -2147483644;
        public static final int DyGenericKey = -2147483643;
    }

    public static class NameType {
        public static final int UninterpretedTextString = 1;
        public static final int Uri = 2;
    }

    public static class SecretDataType {
        public static final int Password = 1;
        public static final int Seed = 2;
    }

    public static class DigitalSignatureAlgorithm {
        public static final int Md2WithRSAEncryption = 1;
        public static final int Md5WithRSAEncryption = 2;
        public static final int SHA_1WithRSAEncryption = 3;
        public static final int SHA_224WithRSAEncryption = 4;
        public static final int SHA_256WithRSAEncryption = 5;
        public static final int SHA_384WithRSAEncryption = 6;
        public static final int SHA_512WithRSAEncryption = 7;
        public static final int RSASSA_PSS = 8;
        public static final int DSAWithSHA_1 = 9;
        public static final int DSAWithSHA224 = 10;
        public static final int DSAWithSHA256 = 11;
        public static final int ECDSAWithSHA_1 = 12;
        public static final int ECDSAWithSHA224 = 13;
        public static final int ECDSAWithSHA256 = 14;
        public static final int ECDSAWithSHA384 = 15;
        public static final int ECDSAWithSHA512 = 16;
    }

    public static class CertificateType {
        public static final int None = 0;
        public static final int X_509 = 1;
    }

    public static class RecommendedCurve {
        public static final int P_192 = 1;
        public static final int K_163 = 2;
        public static final int B_163 = 3;
        public static final int P_224 = 4;
        public static final int K_233 = 5;
        public static final int B_233 = 6;
        public static final int P_256 = 7;
        public static final int K_283 = 8;
        public static final int B_283 = 9;
        public static final int P_384 = 10;
        public static final int K_409 = 11;
        public static final int B_409 = 12;
        public static final int P_521 = 13;
        public static final int K_571 = 14;
        public static final int B_571 = 15;
        public static final int SECP256K1 = 25;
    }

    public static class WrappingMethod {
        public static final int Encrypt = 1;
        public static final int MACsign = 2;
        public static final int EncryptthenMACsign = 3;
        public static final int MACsignthenencrypt = 4;
        public static final int TR_31 = 5;
    }

    public static class KeyFormatType {
        public static final int Raw = 1;
        public static final int Opaque = 2;
        public static final int PKCS_1 = 3;
        public static final int PKCS_8 = 4;
        public static final int X_509 = 5;
        public static final int ECPrivateKey = 6;
        public static final int TransparentSymmetricKey = 7;
        public static final int TransparentDSAPrivateKey = 8;
        public static final int TransparentDSAPublicKey = 9;
        public static final int TransparentRSAPrivateKey = 10;
        public static final int TransparentRSAPublicKey = 11;
        public static final int TransparentDHPrivateKey = 12;
        public static final int TransparentDHPublicKey = 13;
        public static final int TransparentECDSAPrivateKey = 14;
        public static final int TransparentECDSAPublicKey = 15;
        public static final int TransparentECDHPrivateKey = 16;
        public static final int TransparentECDHPublicKey = 17;
        public static final int TransparentECMQVPrivateKey = 18;
        public static final int TransparentECMQVPublicKey = 19;
        public static final int TransparentECPrivateKey = 20;
        public static final int TransparentECPublicKey = 21;
        public static final int PKCS_12 = 22;
        public static final int TransparentLIMAPrivateKey = -2147483647;
        public static final int PUBLIC_PEM = -2147483646;
        public static final int PFX = -2147483645;
        public static final int OBFUSCATED_PEM = -2147483644;
        public static final int NOTARY = -2147483643;
        public static final int PRIVATE_PEM = -2147483642;
    }

    public static class KeyCompressionType {
        public static final int ECPublicKeyTypeUncompressed = 1;
        public static final int ECPublicKeyTypeX9_62CompressedPrime = 2;
        public static final int ECPublicKeyTypeX9_62CompressedChar2 = 3;
        public static final int ECPublicKeyTypeX9_62Hybrid = 4;
    }

    public static class CredentialType {
        public static final int UsernameAndPassword = 1;
        public static final int Device = 2;
        public static final int Attestation = 3;
    }

    public static class RevocationReason {
        public static final int Unspecified = 1;
        public static final int KeyCompromise = 2;
        public static final int CACompromise = 3;
        public static final int AffiliationChanged = 4;
        public static final int Superseded = 5;
        public static final int CessationOfOperation = 6;
        public static final int PrivilegeWithdrawn = 7;
    }

    public static class AttestationType {
        public static final int Quote = 1;
        public static final int TCGIntegrityReport = 2;
        public static final int SAMLAssertion = 3;
        public static final int DyJwtAssertion = -2147483647;
    }

    public static class ErrorOption {
        public static final int Continue = 1;
        public static final int Stop = 2;
        public static final int Undo = 3;
    }

    public static class Tag {
        public static final int ActivationDate = KMIP.access$000(1);
        public static final int ApplicationData = KMIP.access$100(2);
        public static final int ApplicationNamespace = KMIP.access$100(3);
        public static final int ApplicationSpecificInformation = KMIP.access$200(4);
        public static final int ArchiveDate = KMIP.access$000(5);
        public static final int AsynchronousCorrelationValue = KMIP.access$300(6);
        public static final int AsynchronousIndicator = KMIP.access$400(7);
        public static final int Attribute = KMIP.access$200(8);
        public static final int AttributeIndex = KMIP.access$500(9);
        public static final int AttributeName = KMIP.access$100(10);
        public static final int Authentication = KMIP.access$200(12);
        public static final int BatchCount = KMIP.access$500(13);
        public static final int BatchErrorContinuationOption = KMIP.access$600(14);
        public static final int BatchItem = KMIP.access$200(15);
        public static final int BatchOrderOption = KMIP.access$400(16);
        public static final int BlockCipherMode = KMIP.access$600(17);
        public static final int CancellationResult = KMIP.access$600(18);
        public static final int Certificate = KMIP.access$200(19);
        public static final int CertificateIdentifier = KMIP.access$200(20);
        public static final int CertificateIssuer = KMIP.access$200(21);
        public static final int CertificateIssuerAlternativeName = KMIP.access$100(22);
        public static final int CertificateIssuerDistinguishedName = KMIP.access$100(23);
        public static final int CertificateRequest = KMIP.access$300(24);
        public static final int CertificateRequestType = KMIP.access$600(25);
        public static final int CertificateSubject = KMIP.access$200(26);
        public static final int CertificateSubjectAlternativeName = KMIP.access$100(27);
        public static final int CertificateSubjectDistinguishedName = KMIP.access$100(28);
        public static final int CertificateType = KMIP.access$600(29);
        public static final int CertificateValue = KMIP.access$300(30);
        public static final int CommonTemplateAttribute = KMIP.access$200(31);
        public static final int CompromiseDate = KMIP.access$000(32);
        public static final int CompromiseOccurrenceDate = KMIP.access$000(33);
        public static final int ContactInformation = KMIP.access$100(34);
        public static final int Credential = KMIP.access$200(35);
        public static final int CredentialType = KMIP.access$600(36);
        public static final int CredentialValue = KMIP.access$200(37);
        public static final int CriticalityIndicator = KMIP.access$400(38);
        public static final int CRTCoefficient = KMIP.access$700(39);
        public static final int CryptographicAlgorithm = KMIP.access$600(40);
        public static final int CryptographicDomainParameters = KMIP.access$200(41);
        public static final int CryptographicLength = KMIP.access$500(42);
        public static final int CryptographicParameters = KMIP.access$200(43);
        public static final int CryptographicUsageMask = KMIP.access$500(44);
        public static final int D = KMIP.access$700(46);
        public static final int DeactivationDate = KMIP.access$000(47);
        public static final int DerivationData = KMIP.access$300(48);
        public static final int DerivationMethod = KMIP.access$600(49);
        public static final int DerivationParameters = KMIP.access$200(50);
        public static final int DestroyDate = KMIP.access$000(51);
        public static final int Digest = KMIP.access$200(52);
        public static final int DigestValue = KMIP.access$300(53);
        public static final int EncryptionKeyInformation = KMIP.access$200(54);
        public static final int G = KMIP.access$700(55);
        public static final int HashingAlgorithm = KMIP.access$600(56);
        public static final int InitialDate = KMIP.access$000(57);
        public static final int InitializationVector = KMIP.access$300(58);
        public static final int Issuer = KMIP.access$100(59);
        public static final int IterationCount = KMIP.access$500(60);
        public static final int IVCounterNonce = KMIP.access$300(61);
        public static final int J = KMIP.access$700(62);
        public static final int Key = KMIP.access$300(63);
        public static final int KeyBlock = KMIP.access$200(64);
        public static final int KeyCompressionType = KMIP.access$600(65);
        public static final int KeyFormatType = KMIP.access$600(66);
        public static final int KeyMaterialStruct = KMIP.access$200(67);
        public static final int KeyMaterialBuf = KMIP.access$300(67);
        public static final int KeyPartIdentifier = KMIP.access$500(68);
        public static final int KeyValueStruct = KMIP.access$200(69);
        public static final int KeyValueBuf = KMIP.access$300(69);
        public static final int KeyWrappingData = KMIP.access$200(70);
        public static final int KeyWrappingSpecification = KMIP.access$200(71);
        public static final int LastChangeDate = KMIP.access$000(72);
        public static final int LeaseTime = KMIP.access$800(73);
        public static final int Link = KMIP.access$200(74);
        public static final int LinkType = KMIP.access$600(75);
        public static final int LinkedObjectIdentifier = KMIP.access$100(76);
        public static final int MacSignature = KMIP.access$300(77);
        public static final int MacSignatureKeyInformation = KMIP.access$100(78);
        public static final int MaximumItems = KMIP.access$500(79);
        public static final int MaximumResponseSize = KMIP.access$500(80);
        public static final int MessageExtension = KMIP.access$200(81);
        public static final int Modulus = KMIP.access$700(82);
        public static final int Name = KMIP.access$200(83);
        public static final int NameType = KMIP.access$600(84);
        public static final int NameValue = KMIP.access$100(85);
        public static final int ObjectGroup = KMIP.access$100(86);
        public static final int ObjectType = KMIP.access$600(87);
        public static final int Offset = KMIP.access$800(88);
        public static final int OpaqueDataType = KMIP.access$600(89);
        public static final int OpaqueDataValue = KMIP.access$300(90);
        public static final int OpaqueObject = KMIP.access$200(91);
        public static final int Operation = KMIP.access$600(92);
        public static final int OperationPolicyName = KMIP.access$100(93);
        public static final int P = KMIP.access$700(94);
        public static final int PaddingMethod = KMIP.access$600(95);
        public static final int PrimeExponentP = KMIP.access$700(96);
        public static final int PrimeExponentQ = KMIP.access$700(97);
        public static final int PrimeFieldSize = KMIP.access$700(98);
        public static final int PrivateExponent = KMIP.access$700(99);
        public static final int PrivateKey = KMIP.access$200(100);
        public static final int PrivateKeyTemplateAttribute = KMIP.access$200(101);
        public static final int PrivateKeyUniqueIdentifier = KMIP.access$100(102);
        public static final int ProcessStartDate = KMIP.access$000(103);
        public static final int ProtectStopDate = KMIP.access$000(104);
        public static final int ProtocolVersion = KMIP.access$200(105);
        public static final int ProtocolVersionMajor = KMIP.access$500(106);
        public static final int ProtocolVersionMinor = KMIP.access$500(107);
        public static final int PublicExponent = KMIP.access$700(108);
        public static final int PublicKey = KMIP.access$200(109);
        public static final int PublicKeyTemplateAttribute = KMIP.access$200(110);
        public static final int PublicKeyUniqueIdentifier = KMIP.access$100(111);
        public static final int PutFunction = KMIP.access$600(112);
        public static final int Q = KMIP.access$700(113);
        public static final int QString = KMIP.access$300(114);
        public static final int QLength = KMIP.access$500(115);
        public static final int QueryFunction = KMIP.access$600(116);
        public static final int RecommendedCurve = KMIP.access$600(117);
        public static final int ReplacedUniqueIdentifier = KMIP.access$100(118);
        public static final int RequestHeader = KMIP.access$200(119);
        public static final int RequestMessage = KMIP.access$200(120);
        public static final int RequestPayload = KMIP.access$200(121);
        public static final int ResponseHeader = KMIP.access$200(122);
        public static final int ResponseMessage = KMIP.access$200(123);
        public static final int ResponsePayload = KMIP.access$200(124);
        public static final int ResultMessage = KMIP.access$100(125);
        public static final int ResultReason = KMIP.access$600(126);
        public static final int ResultStatus = KMIP.access$600(127);
        public static final int RevocationMessage = KMIP.access$100(128);
        public static final int RevocationReason = KMIP.access$200(129);
        public static final int RevocationReasonCode = KMIP.access$600(130);
        public static final int KeyRoleType = KMIP.access$600(131);
        public static final int Salt = KMIP.access$300(132);
        public static final int SecretData = KMIP.access$200(133);
        public static final int SecretDataType = KMIP.access$600(134);
        public static final int SerialNumber = KMIP.access$100(135);
        public static final int ServerInformation = KMIP.access$200(136);
        public static final int SplitKey = KMIP.access$200(137);
        public static final int SplitKeyMethod = KMIP.access$600(138);
        public static final int SplitKeyParts = KMIP.access$500(139);
        public static final int SplitKeyThreshold = KMIP.access$500(140);
        public static final int State = KMIP.access$600(141);
        public static final int StorageStatusMask = KMIP.access$500(142);
        public static final int SymmetricKey = KMIP.access$200(143);
        public static final int Template = KMIP.access$200(144);
        public static final int TemplateAttribute = KMIP.access$200(145);
        public static final int TimeStamp = KMIP.access$000(146);
        public static final int UniqueBatchItemID = KMIP.access$300(147);
        public static final int UniqueIdentifier = KMIP.access$100(148);
        public static final int UsageLimits = KMIP.access$200(149);
        public static final int UsageLimitsCount = KMIP.access$900(150);
        public static final int UsageLimitsTotal = KMIP.access$900(151);
        public static final int UsageLimitsUnit = KMIP.access$600(152);
        public static final int Username = KMIP.access$100(153);
        public static final int ValidityDate = KMIP.access$000(154);
        public static final int ValidityIndicator = KMIP.access$600(155);
        public static final int VendorExtension = KMIP.access$200(156);
        public static final int VendorIdentification = KMIP.access$100(157);
        public static final int WrappingMethod = KMIP.access$600(158);
        public static final int X = KMIP.access$700(159);
        public static final int Y = KMIP.access$700(160);
        public static final int Password = KMIP.access$100(161);
        public static final int DeviceIdentifier = KMIP.access$100(162);
        public static final int EncodingOption = KMIP.access$600(163);
        public static final int ExtensionInformation = KMIP.access$200(164);
        public static final int ExtensionName = KMIP.access$100(165);
        public static final int ExtensionTag = KMIP.access$500(166);
        public static final int ExtensionType = KMIP.access$500(167);
        public static final int Fresh = KMIP.access$400(168);
        public static final int MachineIdentifier = KMIP.access$100(169);
        public static final int MediaIdentifier = KMIP.access$100(170);
        public static final int NetworkIdentifier = KMIP.access$100(171);
        public static final int ObjectGroupMember = KMIP.access$600(172);
        public static final int CertificateLength = KMIP.access$500(173);
        public static final int DigitalSignatureAlgorithm = KMIP.access$600(174);
        public static final int CertificateSerialNumber = KMIP.access$300(175);
        public static final int DeviceSerialNumber = KMIP.access$100(176);
        public static final int IssuerAlternativeName = KMIP.access$300(177);
        public static final int IssuerDistinguishedName = KMIP.access$300(178);
        public static final int SubjectAlternativeName = KMIP.access$300(179);
        public static final int SubjectDistinguishedName = KMIP.access$300(180);
        public static final int X509CertificateIdentifier = KMIP.access$200(181);
        public static final int X509CertificateIssuer = KMIP.access$200(182);
        public static final int X509CertificateSubject = KMIP.access$200(183);
        public static final int KeyValueLocation = KMIP.access$200(184);
        public static final int KeyValueLocationValue = KMIP.access$100(185);
        public static final int KeyValueLocationType = KMIP.access$600(186);
        public static final int OriginalCreationDate = KMIP.access$000(188);
        public static final int PGPKey = KMIP.access$200(189);
        public static final int PGPKeyVersion = KMIP.access$500(190);
        public static final int AlternativeName = KMIP.access$200(191);
        public static final int AlternativeNameValue = KMIP.access$100(192);
        public static final int AlternativeNameType = KMIP.access$600(193);
        public static final int Data = KMIP.access$300(194);
        public static final int SignatureData = KMIP.access$300(195);
        public static final int DataLength = KMIP.access$500(196);
        public static final int RandomIV = KMIP.access$400(197);
        public static final int MACData = KMIP.access$300(198);
        public static final int AttestationType = KMIP.access$600(199);
        public static final int Nonce = KMIP.access$200(200);
        public static final int NonceID = KMIP.access$300(201);
        public static final int NonceValue = KMIP.access$300(202);
        public static final int AttestationMeasurement = KMIP.access$300(203);
        public static final int AttestationAssertion = KMIP.access$300(204);
        public static final int IVLength = KMIP.access$500(205);
        public static final int TagLength = KMIP.access$500(206);
        public static final int FixedFieldLength = KMIP.access$500(207);
        public static final int CounterLength = KMIP.access$500(208);
        public static final int InitialCounterValue = KMIP.access$500(209);
        public static final int InvocationFieldLength = KMIP.access$500(210);
        public static final int AttestationCapableIndicator = KMIP.access$400(211);
        public static final int OffsetItems = KMIP.access$500(212);
        public static final int LocatedItems = KMIP.access$500(213);
        public static final int CorrelationValue = KMIP.access$300(214);
        public static final int InitIndicator = KMIP.access$400(215);
        public static final int FinalIndicator = KMIP.access$400(216);
        public static final int RNGParameters = KMIP.access$200(217);
        public static final int RNGAlgorithm = KMIP.access$600(218);
        public static final int DRBGAlgorithm = KMIP.access$600(219);
        public static final int FIPS186Variation = KMIP.access$600(220);
        public static final int PredictionResistance = KMIP.access$400(221);
        public static final int RandomNumberGenerator = KMIP.access$600(222);
        public static final int ValidationInformation = KMIP.access$200(223);
        public static final int ValidationAuthorityType = KMIP.access$600(224);
        public static final int ValidationAuthorityCountry = KMIP.access$100(225);
        public static final int ValidationAuthorityURI = KMIP.access$100(226);
        public static final int ValidationVersionMajor = KMIP.access$500(227);
        public static final int ValidationVersionMinor = KMIP.access$500(228);
        public static final int ValidationType = KMIP.access$600(229);
        public static final int ValidationLevel = KMIP.access$600(230);
        public static final int ValidationCertificateIdentifier = KMIP.access$100(231);
        public static final int ValidationCertificateURI = KMIP.access$100(232);
        public static final int ValidationVendorURI = KMIP.access$100(233);
        public static final int ValidationProfile = KMIP.access$100(234);
        public static final int ProfileInformation = KMIP.access$200(235);
        public static final int ProfileName = KMIP.access$600(236);
        public static final int ServerURI = KMIP.access$100(237);
        public static final int ServerPort = KMIP.access$500(238);
        public static final int StreamingCapability = KMIP.access$400(239);
        public static final int AsynchronousCapability = KMIP.access$400(240);
        public static final int AttestationCapability = KMIP.access$400(241);
        public static final int UnwrapMode = KMIP.access$600(242);
        public static final int DestroyAction = KMIP.access$600(243);
        public static final int ShreddingAlgorithm = KMIP.access$600(244);
        public static final int RNGMode = KMIP.access$600(245);
        public static final int ClientRegistrationMethod = KMIP.access$600(246);
        public static final int CapabilityInformation = KMIP.access$200(247);
        public static final int KeyWrapType = KMIP.access$600(248);
        public static final int BatchUndoCapability = KMIP.access$400(249);
        public static final int BatchContinueCapability = KMIP.access$400(250);
        public static final int PKCS12FriendlyName = KMIP.access$100(251);
        public static final int Description = KMIP.access$100(252);
        public static final int Comment = KMIP.access$100(253);
        public static final int AuthenticatedEncryptionAdditionalData = KMIP.access$300(254);
        public static final int AuthenticatedEncryptionTag = KMIP.access$300(255);
        public static final int SaltLength = KMIP.access$500(256);
        public static final int MaskGenerator = KMIP.access$600(257);
        public static final int MaskGeneratorHashingAlgorithm = KMIP.access$600(258);
        public static final int PSource = KMIP.access$300(259);
        public static final int TrailerField = KMIP.access$500(260);
        public static final int ClientCorrelationValue = KMIP.access$100(261);
        public static final int ServerCorrelationValue = KMIP.access$100(262);
        public static final int DigestedData = KMIP.access$300(263);
        public static final int CertificateSubjectCN = KMIP.access$100(264);
        public static final int CertificateSubjectO = KMIP.access$100(265);
        public static final int CertificateSubjectOU = KMIP.access$100(266);
        public static final int CertificateSubjectEmail = KMIP.access$100(267);
        public static final int CertificateSubjectC = KMIP.access$100(268);
        public static final int CertificateSubjectST = KMIP.access$100(269);
        public static final int CertificateSubjectL = KMIP.access$100(270);
        public static final int CertificateSubjectUID = KMIP.access$100(271);
        public static final int CertificateSubjectSerialNumber = KMIP.access$100(272);
        public static final int CertificateSubjectTitle = KMIP.access$100(273);
        public static final int CertificateSubjectDC = KMIP.access$100(274);
        public static final int CertificateSubjectDNQualifier = KMIP.access$100(275);
        public static final int CertificateIssuerCN = KMIP.access$100(276);
        public static final int CertificateIssuerO = KMIP.access$100(277);
        public static final int CertificateIssuerOU = KMIP.access$100(278);
        public static final int CertificateIssuerEmail = KMIP.access$100(279);
        public static final int CertificateIssuerC = KMIP.access$100(280);
        public static final int CertificateIssuerST = KMIP.access$100(281);
        public static final int CertificateIssuerL = KMIP.access$100(282);
        public static final int CertificateIssuerUID = KMIP.access$100(283);
        public static final int CertificateIssuerSerialNumber = KMIP.access$100(284);
        public static final int CertificateIssuerTitle = KMIP.access$100(285);
        public static final int CertificateIssuerDC = KMIP.access$100(286);
        public static final int CertificateIssuerDNQualifier = KMIP.access$100(287);
        public static final int Sensitive = KMIP.access$400(288);
        public static final int AlwaysSensitive = KMIP.access$400(289);
        public static final int Extractable = KMIP.access$400(290);
        public static final int NeverExtractable = KMIP.access$400(291);
        public static final int ReplaceExisting = KMIP.access$400(292);
        public static final int CKA_CLASS = KMIP.access$1000(0);
        public static final int CKA_TOKEN = KMIP.access$1100(1);
        public static final int CKA_PRIVATE = KMIP.access$1100(2);
        public static final int CKA_LABEL = KMIP.access$1200(3);
        public static final int CKA_APPLICATION = KMIP.access$1200(16);
        public static final int CKA_VALUE = KMIP.access$1300(17);
        public static final int CKA_CERTIFICATE_TYPE = KMIP.access$1000(128);
        public static final int CKA_ISSUER = KMIP.access$1300(129);
        public static final int CKA_SERIAL_NUMBER = KMIP.access$1300(130);
        public static final int CKA_CERTIFICATE_CATEGORY = KMIP.access$1000(135);
        public static final int CKA_URL = KMIP.access$1200(137);
        public static final int CKA_OBJECT_ID = KMIP.access$1300(18);
        public static final int CKA_CHECK_VALUE = KMIP.access$1300(144);
        public static final int CKA_KEY_GEN_MECHANISM = KMIP.access$1000(358);
        public static final int CKA_KEY_TYPE = KMIP.access$1000(256);
        public static final int CKA_SUBJECT = KMIP.access$1300(257);
        public static final int CKA_ID = KMIP.access$1300(258);
        public static final int CKA_SENSITIVE = KMIP.access$1100(259);
        public static final int CKA_ENCRYPT = KMIP.access$1100(260);
        public static final int CKA_DECRYPT = KMIP.access$1100(261);
        public static final int CKA_WRAP = KMIP.access$1100(262);
        public static final int CKA_UNWRAP = KMIP.access$1100(263);
        public static final int CKA_SIGN = KMIP.access$1100(264);
        public static final int CKA_SIGN_RECOVER = KMIP.access$1100(265);
        public static final int CKA_VERIFY = KMIP.access$1100(266);
        public static final int CKA_VERIFY_RECOVER = KMIP.access$1100(267);
        public static final int CKA_DERIVE = KMIP.access$1100(268);
        public static final int CKA_START_DATE = KMIP.access$1400(272);
        public static final int CKA_END_DATE = KMIP.access$1400(273);
        public static final int CKA_MODULUS = KMIP.access$1500(288);
        public static final int CKA_MODULUS_BITS = KMIP.access$1600(289);
        public static final int CKA_PUBLIC_EXPONENT = KMIP.access$1500(290);
        public static final int CKA_PRIVATE_EXPONENT = KMIP.access$1500(291);
        public static final int CKA_PRIME_1 = KMIP.access$1500(292);
        public static final int CKA_PRIME_2 = KMIP.access$1500(293);
        public static final int CKA_EXPONENT_1 = KMIP.access$1500(294);
        public static final int CKA_EXPONENT_2 = KMIP.access$1500(295);
        public static final int CKA_COEFFICIENT = KMIP.access$1500(296);
        public static final int CKA_VALUE_LEN = KMIP.access$1600(353);
        public static final int CKA_EXTRACTABLE = KMIP.access$1100(354);
        public static final int CKA_LOCAL = KMIP.access$1100(355);
        public static final int CKA_NEVER_EXTRACTABLE = KMIP.access$1100(356);
        public static final int CKA_ALWAYS_SENSITIVE = KMIP.access$1100(357);
        public static final int CKA_MODIFIABLE = KMIP.access$1100(368);
        public static final int CKA_ALWAYS_AUTHENTICATE = KMIP.access$1100(514);
        public static final int CKA_EC_PARAMS = KMIP.access$1300(384);
        public static final int CKA_EC_POINT = KMIP.access$1300(385);
        public static final int CKA_MECHANISM_TYPE = KMIP.access$1000(1280);
        public static final int CKA_TRUSTED = KMIP.access$1100(134);
        public static final int CKA_WRAP_WITH_TRUSTED = KMIP.access$1100(528);
        public static final int xID = KMIP.access$1100(529);
        public static final int DyDYCKA_UID = KMIP.access$1700(29185);
        public static final int DyDYCKA_PASS_EC_POINT = KMIP.access$1300(29186);
        public static final int DyDYCKA_DATA_EC_POINT = KMIP.access$1300(29187);
        public static final int DyDYCKA_ECDSA_ENC_PUB_KEY = KMIP.access$1500(29190);
        public static final int DyDYCKA_LIMA_PUB_KEY = KMIP.access$1300(29191);
        public static final int DyDYCKA_EDDSA_PUB_KEY = KMIP.access$1300(29192);
        public static final int DyDYCKA_ERASE_KEY_MATERIAL = KMIP.access$1100(29193);
        public static final int DyDYCKA_FIPS = KMIP.access$1100(29194);
        public static final int DyCKA_MPC_SIGN_PROTECTED = KMIP.access$1100(29195);
        public static final int DyCKA_INTEGRITY_SIGNATURE = KMIP.access$1300(29196);
        public static final int DYCKA_OBJECT_GROUPS = KMIP.access$1200(29199);
        public static final int DYCKA_ECDSA_BIP_LEVEL = KMIP.access$1600(29200);
        public static final int DYCKA_ECDSA_BIP_CHILD_NUMBER = KMIP.access$1600(29201);
        public static final int DYCKA_ECDSA_BIP_PARENT_FINGERPRINT = KMIP.access$1300(29202);
        public static final int DYCKA_ECDSA_BIP_CPAR = KMIP.access$1300(29203);
        public static final int DYCKA_ECDSA_BIP_PARENT_UID = KMIP.access$1700(29204);
        public static final int DYCKA_ECDSA_BIP_HARDENED = KMIP.access$1100(29205);
        public static final int DYCKA_EDDSA_BIP_LEVEL = KMIP.access$1600(29232);
        public static final int DYCKA_EDDSA_BIP_CHILD_NUMBER = KMIP.access$1600(29233);
        public static final int DYCKA_EDDSA_BIP_CPAR = KMIP.access$1300(29235);
        public static final int DYCKA_EDDSA_BIP_PARENT_UID = KMIP.access$1700(29236);
        public static final int DYCKA_EDDSA_BIP_HARDENED = KMIP.access$1100(29237);
        public static final int DYCKA_DIGEST_SHA_1 = KMIP.access$1300(29216);
        public static final int DYCKA_DIGEST_SHA256 = KMIP.access$1300(29217);
        public static final int DYCKA_DIGEST_SHA384 = KMIP.access$1300(29218);
        public static final int DYCKA_DIGEST_SHA512 = KMIP.access$1300(29219);
        public static final int DyAuth = KMIP.access$1300(65281);
        public static final int DyMgfAlg = KMIP.access$1000(65282);
        public static final int DyPssSaltSize = KMIP.access$1600(65283);
        public static final int DySecretSize = KMIP.access$1600(65284);
        public static final int DyPartitionName = KMIP.access$1200(65285);
        public static final int DyPartitionId = KMIP.access$1200(65286);
        public static final int DyServer = KMIP.access$1200(65287);
        public static final int DyLIMAKeyType = KMIP.access$1000(65288);
        public static final int DyLIMAPrivateKey = KMIP.access$1300(65289);
        public static final int DyLIMAPublicKey = KMIP.access$1300(65290);
        public static final int DyPaillierKey = KMIP.access$1300(65291);
        public static final int DyDetails = KMIP.access$1300(65296);
        public static final int DyAuthType = KMIP.access$1000(65297);
        public static final int DyRole = KMIP.access$1200(65298);
        public static final int DyMode = KMIP.access$1000(65299);
        public static final int DyActivationCode = KMIP.access$1200(65300);
        public static final int DyCertificateRequest = KMIP.access$1300(65301);
        public static final int DyPfxPassword = KMIP.access$1200(65302);
        public static final int DyPFX = KMIP.access$1300(65303);
        public static final int DyCertificate = KMIP.access$1300(65304);
        public static final int DyObject = KMIP.access$1200(65305);
        public static final int DyPublicKey = KMIP.access$1300(65306);
        public static final int DySecret = KMIP.access$1200(4100);
        public static final int DyOperation = KMIP.access$1100(4101);
        public static final int DyOperations = KMIP.access$1600(4102);
        public static final int DyPrivateOperation = KMIP.access$1100(4104);
        public static final int DyEp = KMIP.access$1200(65312);
        public static final int DyPartner = KMIP.access$1200(65313);
        public static final int DyAuxiliary = KMIP.access$1200(65314);
        public static final int DyEpPublic = KMIP.access$1200(65315);
        public static final int DyPartnerPublic = KMIP.access$1200(65316);
        public static final int DyAuxiliaryPublic = KMIP.access$1200(65317);
        public static final int DyEpCertificateThumbPrint = KMIP.access$1200(65318);
        public static final int DyPartnerCertificateThumbPrint = KMIP.access$1200(65319);
        public static final int DyAuxiliaryCertificateThumbPrint = KMIP.access$1200(65320);
        public static final int DyForce = KMIP.access$1200(65321);
        public static final int DyTopology = KMIP.access$1200(65344);
        public static final int DyStatus = KMIP.access$1200(65345);
        public static final int DyFull = KMIP.access$1100(65346);
        public static final int DyPassword = KMIP.access$1200(65347);
        public static final int DyPartition = KMIP.access$1200(65348);
        public static final int DyPresent = KMIP.access$1100(65349);
        public static final int DyPairOnly = KMIP.access$1100(65350);
        public static final int DyTitle = KMIP.access$1200(65351);
        public static final int DySoUser = KMIP.access$1200(65352);
        public static final int DyEpCertificate = KMIP.access$1300(65328);
        public static final int DyPartnerCertificate = KMIP.access$1300(65329);
        public static final int DyAuxiliaryCertificate = KMIP.access$1300(65330);
        public static final int DyGetAllCAs = KMIP.access$1100(65331);
        public static final int DyExportable = KMIP.access$1600(65344);
        public static final int DyWrapable = KMIP.access$1300(65345);
        public static final int DyWrapableWithTrusted = KMIP.access$1300(65346);
        public static final int DyNonExportable = KMIP.access$1100(65347);
        public static final int DyClient = KMIP.access$1200(65362);
        public static final int DyServerName = KMIP.access$1200(65363);
        public static final int DyRetries = KMIP.access$1600(65364);
        public static final int DyGenerateAttestation = KMIP.access$1100(65365);
        public static final int DyCaCertificate = KMIP.access$1300(65366);
        public static final int DyOperationsGroup = KMIP.access$1300(65367);
        public static final int DyTemplate = KMIP.access$1200(65368);
        public static final int DyGenericKey = KMIP.access$1200(65369);
        public static final int DyBackup = KMIP.access$1200(65392);
        public static final int DyChain = KMIP.access$1200(65114);
        public static final int DyObjectGroup = KMIP.access$1200(65115);
        public static final int DyIsPrimaryObject = KMIP.access$1100(65116);
        public static final int DyCreatedUsingDerive = KMIP.access$1100(65117);
        public static final int DyIsSync = KMIP.access$1100(65118);
        public static final int DyDateCreated = KMIP.access$1200(65376);
        public static final int DyLastUpdated = KMIP.access$1200(65377);
        public static final int DyLastPasswordUpdated = KMIP.access$1200(65378);
        public static final int DyClientRegistrainRetries = KMIP.access$1600(65408);
        public static final int DyClientRegistrationTimeout = KMIP.access$1600(65409);
        public static final int DyUserLoginRetries = KMIP.access$1600(65410);
        public static final int DySamlTimeout = KMIP.access$1600(65411);
        public static final int DySamlCertificate = KMIP.access$1300(65412);
        public static final int DyPasswordComplexity = KMIP.access$1100(65413);
        public static final int DyPasswordLength = KMIP.access$1300(65414);
        public static final int DyCheckClientIp = KMIP.access$1100(65415);
        public static final int DyPartitionInheritance = KMIP.access$1100(65416);
        public static final int DyCertificatePropagation = KMIP.access$1100(65417);
        public static final int DyPartitionFipsRequirements = KMIP.access$1000(65424);
        public static final int DyDoActivate = KMIP.access$1100(65418);
        public static final int DyKeyOnly = KMIP.access$1100(65419);
        public static final int DyTestMode = KMIP.access$1100(65420);
        public static final int DyDeleteCertificate = KMIP.access$1100(65421);
        public static final int DyJwtTimeout = KMIP.access$1600(65422);
        public static final int DyJwtLimit = KMIP.access$1600(65372);
        public static final int DyRoleObjectPermission = KMIP.access$1800(65423);
        public static final int DyRefreshInterval = KMIP.access$1600(65424);
        public static final int DySyncInterval = KMIP.access$1600(65425);
        public static final int DyCheckAllowServers = KMIP.access$1600(65426);
        public static final int DyAllowNoCertificate = KMIP.access$1100(65427);
        public static final int DyAllowDefaultClient = KMIP.access$1100(65428);
        public static final int DySeedInterval = KMIP.access$1600(65429);
        public static final int DyLicense = KMIP.access$1600(65430);
        public static final int DyVersion = KMIP.access$1200(65431);
        public static final int DyAllowNat = KMIP.access$1100(65432);
        public static final int DyRootCaCertificateExpiration = KMIP.access$1600(65433);
        public static final int DyServerCertificateExpiration = KMIP.access$1600(65434);
        public static final int DyClientCertificateExpiration = KMIP.access$1600(65435);
        public static final int DyRootCaCertificatePreExpiry = KMIP.access$1600(65436);
        public static final int DyServerCertificatePreExpiry = KMIP.access$1600(65437);
        public static final int DyClientCertificatePreExpiry = KMIP.access$1600(65438);
        public static final int DyActivationCodeLength = KMIP.access$1600(65439);
        public static final int DyExpiration = KMIP.access$1200(65370);
        public static final int DyClientCertExpiring = KMIP.access$1100(65371);
        public static final int DyIpRange = KMIP.access$1200(65472);
        public static final int DyEnforceUniqueName = KMIP.access$1100(65473);
        public static final int DyEnforceUniqueDescription = KMIP.access$1100(65474);
        public static final int DyOfflineBackupKey = KMIP.access$1300(65475);
        public static final int DyGrantType = KMIP.access$1600(65476);
        public static final int DyClientSecretExpiration = KMIP.access$1600(65477);
        public static final int DyJwtExpiresAt = KMIP.access$1200(65478);
        public static final int DyJwtExpiresIn = KMIP.access$1600(65479);
        public static final int DyRefreshJwt = KMIP.access$1600(65480);
        public static final int DyLastActivity = KMIP.access$1200(65481);
        public static final int DyLastLogout = KMIP.access$1200(65482);
        public static final int DyQuorumValue = KMIP.access$1200(65440);
        public static final int DyQuorumInitiator = KMIP.access$1200(65441);
        public static final int DyQuorumIsApproved = KMIP.access$1100(65442);
        public static final int DyQuorumApprover = KMIP.access$1200(65443);
        public static final int DyQuorumDate = KMIP.access$1700(65444);
        public static final int DyQuorumOperations = KMIP.access$1200(65445);
        public static final int DyQuorumTimeout = KMIP.access$1600(65446);
        public static final int DyAllowOnlyCrypto = KMIP.access$1100(65456);
        public static final int DyLdapProviderUrl = KMIP.access$1200(65457);
        public static final int DyLdapBindDn = KMIP.access$1200(65458);
        public static final int DyLdapBindDnPwd = KMIP.access$1200(65459);
        public static final int DyLdapCaCert = KMIP.access$1300(65460);
        public static final int DyLdapSearchFilter = KMIP.access$1200(65461);
        public static final int DyLdapDoNotVerifyCert = KMIP.access$1100(65463);
        public static final int DyKeyRotationExecTime = KMIP.access$1200(65464);
        public static final int DyLdapSearchBase = KMIP.access$1200(65465);
        public static final int DySignAttributes = KMIP.access$1100(65504);
        public static final int DyFips = KMIP.access$1100(65505);
        public static final int DyKeyRotationInterval = KMIP.access$1600(65506);
        public static final int DyNextKeyRotationTime = KMIP.access$1700(65507);
        public static final int DyConnectTimeout = KMIP.access$1600(65488);
        public static final int DyReadTimeout = KMIP.access$1600(65489);
        public static final int DyWriteTimeout = KMIP.access$1600(65490);
        public static final int DyCipherSuite = KMIP.access$1200(65491);
        public static final int DyKeepAliveIdle = KMIP.access$1600(65492);
        public static final int DyKeepAliveInterval = KMIP.access$1600(65493);
        public static final int DyKeepAliveCount = KMIP.access$1600(65494);
        public static final int DyJws = KMIP.access$1300(65495);
        public static final int DyDateFrom = KMIP.access$1400(65496);
        public static final int DyDateTo = KMIP.access$1400(65497);
        public static final int DyPeriod = KMIP.access$1000(65498);
        public static final int DyDseVersion = KMIP.access$1200(65499);
        public static final int DyDseKeyNamespace = KMIP.access$1200(65500);
        public static final int DyCheckJwtOriginator = KMIP.access$1200(65501);
    }

    public static class TagType {
        public static final int Structure = 1;
        public static final int Integer = 2;
        public static final int LongInteger = 3;
        public static final int BigInteger = 4;
        public static final int Enumeration = 5;
        public static final int Boolean = 6;
        public static final int TextString = 7;
        public static final int ByteString = 8;
        public static final int DateTime = 9;
        public static final int Interval = 10;
    }
}

