/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider.kmip.attribute;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.attribute.Attribute;

public class CryptoParams
extends Attribute {
    public Integer mode = null;
    public Integer padding = null;
    public Integer hashingAlg = null;
    public Integer keyRole = null;
    public Integer signingAlg = null;
    public Integer cryptoAlg = null;
    public Boolean randomIv = null;
    public Integer ivLength = null;
    public Integer tagLength = null;
    public Integer fixFieldLength = null;
    public Integer invocationFieldLength = null;
    public Integer counterLength = null;
    public Integer initCounterValue = null;
    public Integer saltLength = null;
    public Integer maskGenerator = null;
    public Integer maskGeneratorHashAlg = null;
    public byte[] PSource = null;
    public Integer trailerField = null;

    public CryptoParams() {
        super(KMIP.Tag.CryptographicParameters);
    }

    public CryptoParams(Integer mode) {
        this();
        if (mode != 0) {
            this.mode = mode;
        }
    }

    public CryptoParams(Integer cryptoAlg, Integer mode, Integer padding) {
        this(mode);
        if (cryptoAlg != 0) {
            this.cryptoAlg = cryptoAlg;
        }
        if (padding != 0) {
            this.padding = padding;
        }
    }

    @Override
    public void convert(KMIPConverter converter) throws KMIPConvertException {
        this.convertValue(converter, KMIP.tagAttributeValue(1));
    }

    public void convertValue(KMIPConverter converter) throws KMIPConvertException {
        this.convertValue(converter, KMIP.Tag.CryptographicParameters);
    }

    public void convertValue(KMIPConverter converter, int tag) throws KMIPConvertException {
        int begin = converter.convertBegin(tag);
        this.mode = converter.convertOptional(KMIP.Tag.BlockCipherMode, this.mode);
        this.padding = converter.convertOptional(KMIP.Tag.PaddingMethod, this.padding);
        this.hashingAlg = converter.convertOptional(KMIP.Tag.HashingAlgorithm, this.hashingAlg);
        this.keyRole = converter.convertOptional(KMIP.Tag.KeyRoleType, this.keyRole);
        this.signingAlg = converter.convertOptional(KMIP.Tag.DigitalSignatureAlgorithm, this.signingAlg);
        this.cryptoAlg = converter.convertOptional(KMIP.Tag.CryptographicAlgorithm, this.cryptoAlg);
        this.randomIv = converter.convertOptional(KMIP.Tag.RandomIV, this.randomIv);
        this.ivLength = converter.convertOptional(KMIP.Tag.IVLength, this.ivLength);
        this.tagLength = converter.convertOptional(KMIP.Tag.TagLength, this.tagLength);
        this.fixFieldLength = converter.convertOptional(KMIP.Tag.FixedFieldLength, this.fixFieldLength);
        this.invocationFieldLength = converter.convertOptional(KMIP.Tag.InvocationFieldLength, this.invocationFieldLength);
        this.counterLength = converter.convertOptional(KMIP.Tag.CounterLength, this.counterLength);
        this.initCounterValue = converter.convertOptional(KMIP.Tag.InitialCounterValue, this.initCounterValue);
        this.saltLength = converter.convertOptional(KMIP.Tag.SaltLength, this.saltLength);
        this.maskGenerator = converter.convertOptional(KMIP.Tag.MaskGenerator, this.maskGenerator);
        this.maskGeneratorHashAlg = converter.convertOptional(KMIP.Tag.MaskGeneratorHashingAlgorithm, this.maskGeneratorHashAlg);
        this.PSource = converter.convertOptional(KMIP.Tag.PSource, this.PSource);
        this.trailerField = converter.convertOptional(KMIP.Tag.TrailerField, this.trailerField);
        converter.convertEnd(begin);
    }
}

