/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider.kmip.attribute;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.attribute.Attribute;

public class RNGParams
extends Attribute {
    public Integer rngAlg = null;
    public Integer cryptoAlg = null;
    public Integer cryptoLen = null;
    public Integer hashAlg = null;
    public Integer drbgAlg = null;
    public Integer curve = null;
    public Integer fips186Var = null;
    public Boolean predictResist = null;

    public RNGParams() {
        super(KMIP.Tag.RNGParameters);
    }

    @Override
    public void convert(KMIPConverter converter) throws KMIPConvertException {
        this.convertValue(converter, KMIP.tagAttributeValue(1));
    }

    public void convertValue(KMIPConverter converter) throws KMIPConvertException {
        this.convertValue(converter, KMIP.Tag.CryptographicParameters);
    }

    public void convertValue(KMIPConverter converter, int tag) throws KMIPConvertException {
        int begin = converter.convertBegin(tag);
        this.rngAlg = converter.convert(KMIP.Tag.RNGAlgorithm, this.rngAlg);
        this.cryptoAlg = converter.convertOptional(KMIP.Tag.CryptographicAlgorithm, this.cryptoAlg);
        this.cryptoLen = converter.convertOptional(KMIP.Tag.CryptographicLength, this.cryptoLen);
        this.hashAlg = converter.convertOptional(KMIP.Tag.HashingAlgorithm, this.hashAlg);
        this.drbgAlg = converter.convertOptional(KMIP.Tag.DRBGAlgorithm, this.drbgAlg);
        this.curve = converter.convertOptional(KMIP.Tag.RecommendedCurve, this.curve);
        this.fips186Var = converter.convertOptional(KMIP.Tag.FIPS186Variation, this.fips186Var);
        this.predictResist = converter.convertOptional(KMIP.Tag.PredictionResistance, this.predictResist);
        converter.convertEnd(begin);
    }
}

