/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider.kmip.object;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.attribute.Attributes;
import com.unbound.provider.kmip.attribute.KeyWrappingData;
import java.math.BigInteger;

public class KeyBlock {
    public int formatType = 0;
    public Integer compressionType = null;
    public Integer algorithm = null;
    public Integer length = null;
    public Attributes attrs = new Attributes();
    public byte[] buf = null;
    public BigInteger N = null;
    public BigInteger E = null;
    public BigInteger D = null;
    public BigInteger P = null;
    public BigInteger Q = null;
    public BigInteger DP = null;
    public BigInteger DQ = null;
    public BigInteger QINV = null;
    public Integer curveType = null;
    public byte[] ecPoint = null;
    public boolean bufKeyMaterial;
    public KeyWrappingData keyWrap = null;
    public byte[] limaPrvKey = null;
    public byte[] limaPubKey = null;
    public int limaType = 0;

    public boolean isTransparentFormat() {
        return this.formatType == 7 || this.formatType == 12 || this.formatType == 13 || this.formatType == 8 || this.formatType == 9 || this.formatType == 16 || this.formatType == 17 || this.formatType == 14 || this.formatType == 15 || this.formatType == 18 || this.formatType == 19 || this.formatType == 20 || this.formatType == 21 || this.formatType == 10 || this.formatType == 11;
    }

    public void convert(KMIPConverter converter) throws KMIPConvertException {
        int begin = converter.convertBegin(KMIP.Tag.KeyBlock);
        this.formatType = converter.convert(KMIP.Tag.KeyFormatType, this.formatType);
        this.compressionType = converter.convertOptional(KMIP.Tag.KeyCompressionType, this.compressionType);
        if (!converter.isWrite() && converter.getNextTag() == KMIP.Tag.KeyValueBuf) {
            this.keyWrap = new KeyWrappingData();
        }
        if (this.keyWrap != null) {
            this.bufKeyMaterial = true;
            this.buf = converter.convert(KMIP.Tag.KeyValueBuf, this.buf);
        } else {
            this.bufKeyMaterial = this.formatType == 1 || this.formatType == 2 || this.formatType == 3 || this.formatType == 4 || this.formatType == 5 || this.formatType == -2147483646 || this.formatType == -2147483645 || this.formatType == 6;
            int valueBegin = converter.convertBegin(KMIP.Tag.KeyValueStruct);
            if (this.bufKeyMaterial) {
                this.buf = converter.convert(KMIP.Tag.KeyMaterialBuf, this.buf);
            } else {
                int matBegin = converter.convertBegin(KMIP.Tag.KeyMaterialStruct);
                switch (this.formatType) {
                    case 7: {
                        this.buf = converter.convert(KMIP.Tag.Key, this.buf);
                        break;
                    }
                    case 11: {
                        this.N = converter.convert(KMIP.Tag.Modulus, this.N);
                        this.E = converter.convert(KMIP.Tag.PublicExponent, this.E);
                        break;
                    }
                    case 10: {
                        this.N = converter.convert(KMIP.Tag.Modulus, this.N);
                        this.D = converter.convert(KMIP.Tag.PrivateExponent, this.D);
                        this.E = converter.convertOptional(KMIP.Tag.PublicExponent, this.E);
                        this.P = converter.convertOptional(KMIP.Tag.P, this.P);
                        this.Q = converter.convertOptional(KMIP.Tag.Q, this.Q);
                        this.DP = converter.convertOptional(KMIP.Tag.PrimeExponentP, this.DP);
                        this.DQ = converter.convertOptional(KMIP.Tag.PrimeExponentQ, this.DQ);
                        this.QINV = converter.convertOptional(KMIP.Tag.CRTCoefficient, this.QINV);
                        break;
                    }
                    case 14: 
                    case 16: 
                    case 20: {
                        this.curveType = converter.convert(KMIP.Tag.RecommendedCurve, this.curveType);
                        this.D = converter.convert(KMIP.Tag.D, this.D);
                        break;
                    }
                    case 15: 
                    case 17: 
                    case 21: {
                        this.curveType = converter.convert(KMIP.Tag.RecommendedCurve, this.curveType);
                        this.ecPoint = converter.convert(KMIP.Tag.QString, this.ecPoint);
                        break;
                    }
                    case -2147483647: {
                        this.limaType = converter.convert(KMIP.Tag.DyLIMAKeyType, this.limaType);
                        this.limaPrvKey = converter.convert(KMIP.Tag.DyLIMAPrivateKey, this.limaPrvKey);
                        this.limaPubKey = converter.convert(KMIP.Tag.DyLIMAPrivateKey, this.limaPubKey);
                    }
                }
                converter.convertEnd(matBegin);
            }
            this.attrs.convert(converter);
            converter.convertEnd(valueBegin);
        }
        this.algorithm = converter.convertOptional(KMIP.Tag.CryptographicAlgorithm, this.algorithm);
        this.length = converter.convertOptional(KMIP.Tag.CryptographicLength, this.length);
        if (this.keyWrap != null) {
            this.keyWrap.convert(converter);
        }
        converter.convertEnd(begin);
    }
}

