/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider.kmip.response;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.attribute.CapabilityInformation;
import com.unbound.provider.kmip.attribute.ExtInfo;
import com.unbound.provider.kmip.attribute.ServerInfo;
import com.unbound.provider.kmip.response.ResponseItem;
import java.util.ArrayList;

public class QueryResponse
extends ResponseItem {
    public ArrayList<Integer> operations = new ArrayList();
    public ArrayList<Integer> objectTypes = new ArrayList();
    public String vendorID = null;
    public ServerInfo serverInfo = null;
    public ArrayList<String> appNamespaces = new ArrayList();
    public ArrayList<ExtInfo> extInfos = new ArrayList();
    public ArrayList<Integer> attestationTypes = new ArrayList();
    public CapabilityInformation capabilityInfo = null;
    public ArrayList<Integer> clientRegistrationMethods = new ArrayList();

    public QueryResponse() {
        super(24);
    }

    @Override
    public void convert(KMIPConverter converter) throws KMIPConvertException {
        converter.convertIntList(KMIP.Tag.Operation, this.operations);
        converter.convertIntList(KMIP.Tag.ObjectType, this.objectTypes);
        if (converter.isWrite() && this.serverInfo != null) {
            this.vendorID = "unboundtech.com";
        }
        this.vendorID = converter.convertOptional(KMIP.Tag.VendorIdentification, this.vendorID);
        if (converter.isRead() && converter.getNextTag() == KMIP.Tag.ServerInformation) {
            this.serverInfo = new ServerInfo();
        }
        if (this.serverInfo != null) {
            this.serverInfo.convert(converter);
        }
        converter.convertStrList(KMIP.Tag.ApplicationNamespace, this.appNamespaces);
        if (converter.isWrite()) {
            for (ExtInfo extInfo : this.extInfos) {
                extInfo.convert(converter);
            }
        } else {
            while (converter.getNextTag() == KMIP.Tag.ExtensionInformation) {
                ExtInfo extInfo = new ExtInfo();
                extInfo.convert(converter);
                this.extInfos.add(extInfo);
            }
        }
        converter.convertIntList(KMIP.Tag.AttestationType, this.attestationTypes);
        if (converter.isRead() && converter.getNextTag() == KMIP.Tag.CapabilityInformation) {
            this.capabilityInfo = new CapabilityInformation();
        }
        if (this.capabilityInfo != null) {
            this.capabilityInfo.convert(converter);
        }
        converter.convertIntList(KMIP.Tag.ClientRegistrationMethod, this.clientRegistrationMethods);
    }
}

