/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider.kmip.response;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.attribute.Nonce;
import com.unbound.provider.kmip.attribute.Version;

public class ResponseHeader {
    public Version version = new Version(1, 0);
    public long timeStamp = -1L;
    public Nonce nonce = null;
    public int batchCount = 0;
    public String serverCorrelationValue;

    public void convert(KMIPConverter converter) throws KMIPConvertException {
        int begin = converter.convertBegin(KMIP.Tag.ResponseHeader);
        this.version.convert(converter);
        this.timeStamp = converter.convert(KMIP.Tag.TimeStamp, this.timeStamp);
        if (converter.isRead() && converter.getNextTag() == KMIP.Tag.Nonce) {
            this.nonce = new Nonce();
        }
        if (this.nonce != null) {
            this.nonce.convert(converter);
        }
        if (converter.isRead()) {
            converter.skip(KMIP.Tag.AttestationType);
        }
        if (this.version.major == 1 && this.version.minor == 4) {
            this.serverCorrelationValue = converter.convertOptional(KMIP.Tag.ServerCorrelationValue, this.serverCorrelationValue);
        }
        this.batchCount = converter.convert(KMIP.Tag.BatchCount, this.batchCount);
        converter.convertEnd(begin);
    }
}

