/*
 * Decompiled with CFR 0.152.
 */
package com.unbound.provider.kmip.response;

import com.unbound.provider.kmip.KMIP;
import com.unbound.provider.kmip.KMIPConvertException;
import com.unbound.provider.kmip.KMIPConverter;
import com.unbound.provider.kmip.response.PollResponse;
import com.unbound.provider.kmip.response.ResponseHeader;
import com.unbound.provider.kmip.response.ResponseItem;
import java.util.ArrayList;

public class ResponseMessage {
    public ResponseHeader header = new ResponseHeader();
    public ArrayList<ResponseItem> batch = new ArrayList();

    public ResponseMessage() {
        this.header.version.major = 1;
        this.header.version.minor = 0;
    }

    public void convert(KMIPConverter converter) throws KMIPConvertException {
        int begin = converter.convertBegin(KMIP.Tag.ResponseMessage);
        this.header.convert(converter);
        if (converter.isWrite()) {
            for (ResponseItem item : this.batch) {
                ResponseItem.convert(converter, item);
            }
        } else {
            for (int i = 0; i < this.header.batchCount; ++i) {
                ResponseItem item = ResponseItem.convert(converter, null);
                this.batch.add(item);
            }
        }
        converter.convertEnd(begin);
    }

    public void add(ResponseItem responseItem, byte[] uid) {
        if (responseItem.operation == 26 && ((PollResponse)responseItem).responseItem != null) {
            this.add(((PollResponse)responseItem).responseItem);
            return;
        }
        responseItem.responseUID = uid;
        this.batch.add(responseItem);
        ++this.header.batchCount;
    }

    public void add(ResponseItem responseItem) {
        this.add(responseItem, null);
    }

    public void clear() {
        this.batch.clear();
        this.header.batchCount = 0;
    }
}

