/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.cryptoki;

import com.dyadicsec.cryptoki.CKR_Exception;
import com.dyadicsec.cryptoki.CK_DATE;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.Arrays;

public class CK_ATTRIBUTE {
    public int type;
    public Object pValue;
    private int size;
    private long longValue;
    private byte[] bufValue;
    private static final int attr_bytes = 0;
    private static final int attr_bool = 1;
    private static final int attr_int = 2;
    private static final int attr_bigint = 3;
    private static final int attr_str = 4;
    private static final int attr_date = 5;
    private static final int attr_long = 6;

    public CK_ATTRIBUTE(int type) {
        this.type = type;
    }

    public CK_ATTRIBUTE(int type, Object value) throws CKR_Exception {
        this.type = type;
        this.pValue = value;
    }

    public CK_ATTRIBUTE(int type, boolean value) throws CKR_Exception {
        int mode = CK_ATTRIBUTE.getAttrMode(type);
        if (mode != 1) {
            throw new CKR_Exception(19);
        }
        this.type = type;
        this.longValue = value ? 1L : 0L;
    }

    public CK_ATTRIBUTE(int type, int value) throws CKR_Exception {
        int mode = CK_ATTRIBUTE.getAttrMode(type);
        if (mode != 2) {
            throw new CKR_Exception(19);
        }
        this.type = type;
        this.longValue = (long)value & 0xFFFFFFFFFFFFFFFFL;
    }

    public CK_ATTRIBUTE(int type, long value) throws CKR_Exception {
        int mode = CK_ATTRIBUTE.getAttrMode(type);
        if (mode != 6) {
            throw new CKR_Exception(19);
        }
        this.type = type;
        this.longValue = value;
    }

    public boolean getBooleanValue() throws CKR_Exception {
        return this.longValue != 0L;
    }

    public int getIntValue() throws CKR_Exception {
        return (int)this.longValue;
    }

    public long getLongValue() throws CKR_Exception {
        return this.longValue;
    }

    private static int getAttrMode(int attr) {
        switch (attr) {
            case -2147454463: 
            case -2147454459: 
            case -2147454444: 
            case -2147418141: {
                return 6;
            }
            case -2147454454: 
            case -2147454400: 
            case 1: 
            case 2: 
            case 134: 
            case 259: 
            case 260: 
            case 261: 
            case 262: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 354: 
            case 355: 
            case 356: 
            case 357: 
            case 368: 
            case 512: 
            case 514: 
            case 528: {
                return 1;
            }
            case -2147454448: 
            case -2147454447: 
            case -2147454446: 
            case -2147418142: 
            case 0: 
            case 128: 
            case 135: 
            case 256: 
            case 289: 
            case 352: 
            case 353: 
            case 358: {
                return 2;
            }
            case 272: 
            case 273: {
                return 5;
            }
            case 288: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: {
                return 3;
            }
            case 3: {
                return 4;
            }
        }
        return 0;
    }

    private boolean knownSize() {
        int mode = CK_ATTRIBUTE.getAttrMode(this.type);
        return mode == 1 || mode == 2 || mode == 6;
    }

    private void toNativeGetSize() {
        this.bufValue = null;
    }

    private void toNativeGetValue() {
        if (!this.knownSize()) {
            this.bufValue = new byte[this.size];
        }
    }

    private void toNative() throws CKR_Exception {
        this.size = 0;
        this.bufValue = null;
        if (this.pValue == null) {
            return;
        }
        boolean ok = true;
        try {
            int mode = CK_ATTRIBUTE.getAttrMode(this.type);
            switch (mode) {
                case 1: {
                    if (this.pValue instanceof Boolean) {
                        this.longValue = (Boolean)this.pValue != false ? 1L : 0L;
                        break;
                    }
                    ok = false;
                    break;
                }
                case 2: {
                    if (this.pValue instanceof Byte) {
                        this.longValue = (Byte)this.pValue & 0xFF;
                        break;
                    }
                    if (this.pValue instanceof Short) {
                        this.longValue = (Short)this.pValue & 0xFFFF;
                        break;
                    }
                    if (this.pValue instanceof Integer) {
                        this.longValue = ((Integer)this.pValue).intValue();
                        break;
                    }
                    if (this.pValue instanceof Long) {
                        long x = (Long)this.pValue;
                        if ((x & 0xFFFFFFFF00000000L) == 0L) {
                            this.longValue = (int)(x & 0xFFFFFFFFFFFFFFFFL);
                            break;
                        }
                        ok = false;
                        break;
                    }
                    ok = false;
                    break;
                }
                case 6: {
                    if (this.pValue instanceof Long) {
                        this.longValue = (Long)this.pValue;
                        break;
                    }
                    ok = false;
                    break;
                }
                case 3: {
                    if (this.pValue instanceof BigInteger) {
                        this.bufValue = ((BigInteger)this.pValue).toByteArray();
                        if (this.bufValue != null && this.bufValue.length > 0 && this.bufValue[0] == 0) {
                            this.bufValue = Arrays.copyOfRange(this.bufValue, 1, this.bufValue.length);
                        }
                        break;
                    }
                    if (this.pValue instanceof byte[]) {
                        this.bufValue = (byte[])this.pValue;
                        break;
                    }
                    ok = false;
                    break;
                }
                case 4: {
                    if (this.pValue instanceof String) {
                        this.bufValue = ((String)this.pValue).getBytes("UTF-8");
                        break;
                    }
                    if (this.pValue instanceof char[]) {
                        this.bufValue = new String((char[])this.pValue).getBytes("UTF-8");
                        break;
                    }
                    if (this.pValue instanceof byte[]) {
                        this.bufValue = (byte[])this.pValue;
                        break;
                    }
                    ok = false;
                    break;
                }
                case 5: {
                    if (this.pValue instanceof CK_DATE) {
                        CK_DATE d = (CK_DATE)this.pValue;
                        this.bufValue = new byte[8];
                        this.bufValue[0] = (byte)d.year[0];
                        this.bufValue[1] = (byte)d.year[1];
                        this.bufValue[2] = (byte)d.year[2];
                        this.bufValue[3] = (byte)d.year[3];
                        this.bufValue[4] = (byte)d.month[0];
                        this.bufValue[5] = (byte)d.month[1];
                        this.bufValue[6] = (byte)d.day[0];
                        this.bufValue[7] = (byte)d.day[1];
                        break;
                    }
                    if (this.pValue instanceof byte[]) {
                        this.bufValue = (byte[])this.pValue;
                        if (this.bufValue.length != 8) {
                            ok = false;
                        }
                        break;
                    }
                    ok = false;
                    break;
                }
                default: {
                    if (this.pValue instanceof byte[]) {
                        this.bufValue = (byte[])this.pValue;
                        break;
                    }
                    ok = false;
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            ok = false;
        }
        if (!ok) {
            throw new CKR_Exception(19);
        }
        if (this.bufValue != null) {
            this.size = this.bufValue.length;
        }
    }

    private void fromNative() throws CKR_Exception {
        int mode = CK_ATTRIBUTE.getAttrMode(this.type);
        switch (mode) {
            case 1: {
                if (this.pValue == null) {
                    return;
                }
                this.pValue = new Boolean(this.longValue != 0L);
                break;
            }
            case 2: {
                if (this.pValue == null) {
                    return;
                }
                this.pValue = new Integer((int)this.longValue);
                break;
            }
            case 6: {
                if (this.pValue == null) {
                    return;
                }
                this.pValue = new Long(this.longValue);
                break;
            }
            case 3: {
                this.pValue = new BigInteger(1, this.bufValue);
                break;
            }
            case 4: {
                try {
                    this.pValue = new String(this.bufValue, "UTF-8");
                    break;
                }
                catch (UnsupportedEncodingException e) {
                    throw new CKR_Exception(19, e);
                }
            }
            case 5: {
                CK_DATE d = new CK_DATE();
                d.year[0] = (char)this.bufValue[0];
                d.year[1] = (char)this.bufValue[1];
                d.year[2] = (char)this.bufValue[2];
                d.year[3] = (char)this.bufValue[3];
                d.month[0] = (char)this.bufValue[4];
                d.month[1] = (char)this.bufValue[5];
                d.day[0] = (char)this.bufValue[6];
                d.day[1] = (char)this.bufValue[7];
                this.pValue = d;
                break;
            }
            default: {
                this.pValue = this.bufValue;
            }
        }
    }

    static void toNative(CK_ATTRIBUTE[] pTemplate) throws CKR_Exception {
        for (int i = 0; i < pTemplate.length; ++i) {
            pTemplate[i].toNative();
        }
    }

    static void toNativeGetSize(CK_ATTRIBUTE[] pTemplate) throws CKR_Exception {
        for (int i = 0; i < pTemplate.length; ++i) {
            pTemplate[i].toNativeGetSize();
        }
    }

    static void toNativeGetValue(CK_ATTRIBUTE[] pTemplate) throws CKR_Exception {
        for (int i = 0; i < pTemplate.length; ++i) {
            pTemplate[i].toNativeGetValue();
        }
    }

    static boolean allKnownSizes(CK_ATTRIBUTE[] pTemplate) {
        for (int i = 0; i < pTemplate.length; ++i) {
            if (pTemplate[i].knownSize()) continue;
            return false;
        }
        return true;
    }

    static void fromNative(CK_ATTRIBUTE[] pTemplate) throws CKR_Exception {
        for (int i = 0; i < pTemplate.length; ++i) {
            pTemplate[i].fromNative();
        }
    }
}

