/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.pkcs11;

import com.dyadicsec.pkcs11.CKException;
import com.dyadicsec.pkcs11.CKObject;
import com.dyadicsec.pkcs11.CK_ATTRIBUTE;
import com.dyadicsec.pkcs11.Policy;
import com.dyadicsec.pkcs11.Slot;
import com.dyadicsec.pkcs11.Utils;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;

public final class CKCertificate
extends CKObject {
    byte[] value = null;
    X509Certificate cert = null;
    long privateKeyUID = 0L;

    CKCertificate() {
        this.clazz = 1;
    }

    @Override
    void prepareReadTemplate(Map<Integer, CK_ATTRIBUTE> template) {
        super.prepareReadTemplate(template);
        this.addReadTemplate(template, 17);
        this.addReadTemplate(template, 135);
        this.addReadTemplate(template, -2147454451);
    }

    @Override
    void saveReadTemplate(Map<Integer, CK_ATTRIBUTE> template) throws CKException {
        super.saveReadTemplate(template);
        this.value = template.get(17).getValue();
        this.policy.cka_trusted = template.get(135).toInt() == 2;
        this.privateKeyUID = template.get(-2147454451).toLong();
        this.policy.cka_extractable = true;
        this.policy.cka_derive = false;
        this.policy.cka_unwrap = false;
        this.policy.cka_wrap = false;
        this.policy.cka_verify = false;
        this.policy.cka_sign = false;
        this.policy.cka_decrypt = false;
        this.policy.cka_encrypt = false;
        this.policy.cka_private = false;
        this.policy.cka_sensitive = false;
    }

    public byte[] getValue() throws CKException {
        if (this.value == null) {
            this.read();
        }
        return this.value;
    }

    public X509Certificate getX509() throws CKException, CertificateException {
        if (this.cert == null) {
            byte[] value = this.getValue();
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            this.cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(value));
        }
        return this.cert;
    }

    public static CKCertificate create(Slot slot, String name, Policy policy, byte[] value) throws CKException, CertificateException, CertificateEncodingException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream in = new ByteArrayInputStream(value);
        X509Certificate cert = (X509Certificate)cf.generateCertificate(in);
        return CKCertificate.create(slot, name, policy, cert);
    }

    public static CKCertificate create(Slot slot, String name, Policy policy, X509Certificate cert) throws CKException, CertificateEncodingException {
        if (policy == null) {
            policy = new Policy();
        }
        CKCertificate certificate = new CKCertificate();
        CK_ATTRIBUTE[] t = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1, policy.cka_token), new CK_ATTRIBUTE(0, 1), new CK_ATTRIBUTE(128, 0), new CK_ATTRIBUTE(257, cert.getSubjectX500Principal().getEncoded()), new CK_ATTRIBUTE(129, cert.getIssuerX500Principal().getEncoded()), new CK_ATTRIBUTE(130, cert.getSerialNumber().toByteArray()), new CK_ATTRIBUTE(17, cert.getEncoded()), new CK_ATTRIBUTE(258, Utils.name2id(name))};
        certificate.create(slot, t);
        certificate.policy = policy;
        certificate.name = name;
        return certificate;
    }

    public static CKCertificate find(Slot slot, String name) {
        return (CKCertificate)CKObject.find(slot, 1, -1, name);
    }

    public static CKCertificate find(Slot slot, long uid) {
        return CKObject.find(slot, CKCertificate.class, uid);
    }

    public static ArrayList<CKCertificate> list(Slot slot) {
        return CKObject.list(slot, CKCertificate.class, 1, -1);
    }

    public static ArrayList<CKCertificate> findCertsByPrivateKeyUID(Slot slot, long uid) {
        CKCertificate c = CKObject.find(slot, CKCertificate.class, uid ^ 0xFFFFFFFFFFFFFFFFL);
        CK_ATTRIBUTE[] t = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1, true), new CK_ATTRIBUTE(0, 1), new CK_ATTRIBUTE(-2147454451, uid)};
        ArrayList<CKCertificate> list = CKObject.list(slot, CKCertificate.class, t);
        if (c != null) {
            for (int i = 0; i < list.size(); ++i) {
                if (list.get((int)i).handle != c.handle) continue;
                c = null;
                break;
            }
            if (c != null) {
                list.add(c);
            }
        }
        return list;
    }

    public static CKCertificate findCertByPrivateKeyUID(Slot slot, long uid) {
        ArrayList<CKCertificate> list = CKCertificate.findCertsByPrivateKeyUID(slot, uid);
        int n = list.size();
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return list.get(0);
        }
        CKCertificate best = null;
        Date bestDate = null;
        for (int i = 0; i < n; ++i) {
            CKCertificate c = list.get(i);
            Date date = null;
            try {
                date = c.getX509().getNotAfter();
            }
            catch (CKException cKException) {
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
            if (bestDate == null) {
                bestDate = date;
                best = c;
                continue;
            }
            if (date == null || !date.after(bestDate)) continue;
            bestDate = date;
            best = c;
        }
        return best;
    }

    public long getPrivateKeyUID() throws CKException {
        if (this.privateKeyUID == 0L) {
            this.read();
        }
        return this.privateKeyUID;
    }
}

