/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.pkcs11;

import com.dyadicsec.pkcs11.CKException;
import com.dyadicsec.pkcs11.CKObject;
import com.dyadicsec.pkcs11.CK_ATTRIBUTE;
import com.dyadicsec.pkcs11.Policy;
import com.dyadicsec.pkcs11.Slot;
import com.dyadicsec.pkcs11.Utils;
import java.util.ArrayList;
import java.util.Map;

public final class CKData
extends CKObject {
    CKData() {
        this.clazz = 0;
    }

    @Override
    void prepareReadTemplate(Map<Integer, CK_ATTRIBUTE> template) {
        super.prepareReadTemplate(template);
        this.addReadTemplate(template, 2);
    }

    @Override
    void saveReadTemplate(Map<Integer, CK_ATTRIBUTE> template) throws CKException {
        super.saveReadTemplate(template);
        this.policy.cka_private = template.get(2).toBool();
        this.policy.cka_extractable = true;
        this.policy.cka_sensitive = false;
        this.policy.cka_trusted = false;
        this.policy.cka_derive = false;
        this.policy.cka_unwrap = false;
        this.policy.cka_wrap = false;
        this.policy.cka_verify = false;
        this.policy.cka_sign = false;
        this.policy.cka_decrypt = false;
        this.policy.cka_encrypt = false;
    }

    public static CKData create(Slot slot, String name, Policy policy, byte[] value) throws CKException {
        CKData data = new CKData();
        CK_ATTRIBUTE[] t = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1, policy.cka_token), new CK_ATTRIBUTE(2, policy.cka_private), new CK_ATTRIBUTE(0, 0), new CK_ATTRIBUTE(17, value), new CK_ATTRIBUTE(258, Utils.name2id(name))};
        data.create(slot, t);
        data.policy = policy;
        data.name = name;
        return data;
    }

    public byte[] getValue() throws CKException {
        return this.getAttributeValue(17);
    }

    public static CKData find(Slot slot, String name) {
        return (CKData)CKObject.find(slot, 0, -1, name);
    }

    public static CKData find(Slot slot, long uid) {
        return CKObject.find(slot, CKData.class, uid);
    }

    public static ArrayList<CKData> list(Slot slot) {
        return CKObject.list(slot, CKData.class, 0, -1);
    }
}

