/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.pkcs11;

import com.dyadicsec.pkcs11.CKECPublicKey;
import com.dyadicsec.pkcs11.CKException;
import com.dyadicsec.pkcs11.CKObject;
import com.dyadicsec.pkcs11.CKPrivateKey;
import com.dyadicsec.pkcs11.CK_ATTRIBUTE;
import com.dyadicsec.pkcs11.CK_ECDH1_DERIVE_PARAMS;
import com.dyadicsec.pkcs11.CK_MECHANISM;
import com.dyadicsec.pkcs11.ECCurve;
import com.dyadicsec.pkcs11.Policy;
import com.dyadicsec.pkcs11.Slot;
import com.dyadicsec.pkcs11.Utils;
import java.io.IOException;
import java.math.BigInteger;
import java.security.spec.ECPoint;
import java.util.ArrayList;
import java.util.Map;

public class CKECPrivateKey
extends CKPrivateKey {
    ECCurve curve = null;
    ECPoint point = null;
    CKECPublicKey pubKey = null;

    CKECPrivateKey() {
        this.keyType = 3;
    }

    @Override
    void prepareReadTemplate(Map<Integer, CK_ATTRIBUTE> template) {
        super.prepareReadTemplate(template);
        this.addReadTemplate(template, 384);
        this.addReadTemplate(template, 385);
    }

    @Override
    void saveReadTemplate(Map<Integer, CK_ATTRIBUTE> template) throws CKException {
        super.saveReadTemplate(template);
        this.curve = ECCurve.find(template.get(384).getValue());
        if (this.curve == null) {
            throw new CKException("Unsupported EC curve", 0);
        }
        try {
            this.point = this.curve.derDecodePoint(template.get(385).getValue());
        }
        catch (IOException e) {
            throw new CKException(e, "Can't decode ECPoint", 0);
        }
    }

    public static CK_ATTRIBUTE[] getUnwrapTemplate(String name, Policy policy) {
        if (policy == null) {
            policy = new Policy();
        }
        return new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1, policy.cka_token), new CK_ATTRIBUTE(0, 3), new CK_ATTRIBUTE(256, 3), new CK_ATTRIBUTE(354, policy.cka_extractable), new CK_ATTRIBUTE(264, policy.cka_sign), new CK_ATTRIBUTE(268, policy.cka_derive && !policy.cka_sign), new CK_ATTRIBUTE(258, Utils.name2id(name))};
    }

    public static CKECPrivateKey generate(Slot slot, String name, Policy policy, ECCurve curve) throws CKException {
        CKECPrivateKey key = new CKECPrivateKey();
        if (policy == null) {
            policy = new Policy();
        }
        CK_ATTRIBUTE[] tPrv = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1, policy.cka_token), new CK_ATTRIBUTE(0, 3), new CK_ATTRIBUTE(256, 3), new CK_ATTRIBUTE(354, policy.cka_extractable), new CK_ATTRIBUTE(264, policy.cka_sign), new CK_ATTRIBUTE(268, policy.cka_derive && !policy.cka_sign), new CK_ATTRIBUTE(258, Utils.name2id(name))};
        CK_ATTRIBUTE[] tPub = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1, false), new CK_ATTRIBUTE(0, 2), new CK_ATTRIBUTE(256, 3), new CK_ATTRIBUTE(384, curve.getOidBin())};
        key.generateKeyPair(slot, 4160, tPub, tPrv);
        key.curve = curve;
        key.policy = policy;
        key.name = name;
        return key;
    }

    public static CKECPrivateKey create(Slot slot, String name, Policy policy, ECCurve curve, BigInteger x) throws CKException {
        CKECPrivateKey key = new CKECPrivateKey();
        if (policy == null) {
            policy = new Policy();
        }
        CK_ATTRIBUTE[] t = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1, policy.cka_token), new CK_ATTRIBUTE(0, 3), new CK_ATTRIBUTE(256, 3), new CK_ATTRIBUTE(354, policy.cka_extractable), new CK_ATTRIBUTE(264, policy.cka_sign), new CK_ATTRIBUTE(268, policy.cka_derive && !policy.cka_sign), new CK_ATTRIBUTE(384, curve.getOidBin()), new CK_ATTRIBUTE(17, Utils.bigInt2Bytes(x, curve.getSize())), new CK_ATTRIBUTE(258, Utils.name2id(name))};
        key.create(slot, t);
        key.curve = curve;
        key.policy = policy;
        key.name = name;
        return key;
    }

    public ECCurve getCurve() throws CKException {
        if (this.curve == null) {
            this.read();
        }
        return this.curve;
    }

    public ECPoint getPoint() throws CKException {
        if (this.point == null) {
            this.read();
        }
        return this.point;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] ecdh(ECPoint point) throws CKException {
        byte[] encodedPoint = this.getCurve().derEncodePoint(point);
        CK_ATTRIBUTE[] t = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1, false), new CK_ATTRIBUTE(0, 4), new CK_ATTRIBUTE(256, 16), new CK_ATTRIBUTE(259, false), new CK_ATTRIBUTE(353, this.curve.getSize())};
        CK_ECDH1_DERIVE_PARAMS m = new CK_ECDH1_DERIVE_PARAMS(1, encodedPoint, null);
        int derivedHandle = this.slot.deriveKey(m, this.handle, t);
        CK_ATTRIBUTE[] v = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17)};
        try {
            this.slot.getAttributeValue(derivedHandle, v);
        }
        finally {
            this.slot.destroyObject(derivedHandle);
        }
        return v[0].getValue();
    }

    public byte[] sign(byte[] data) throws CKException {
        return this.sign(4161, data);
    }

    public byte[] sign(int mechanism, byte[] data) throws CKException {
        return this.sign(new CK_MECHANISM(mechanism), data, this.getCurve().getSize() * 2);
    }

    public CKECPublicKey getPublicKey() throws CKException {
        if (this.pubKey == null) {
            this.pubKey = CKECPublicKey.create(this.slot, null, null, this.getCurve(), this.getPoint());
        }
        return this.pubKey;
    }

    public static CKECPrivateKey find(Slot slot, String name) {
        return (CKECPrivateKey)CKObject.find(slot, 3, 3, name);
    }

    public static CKECPrivateKey find(Slot slot, long uid) {
        return CKObject.find(slot, CKECPrivateKey.class, uid);
    }

    public static ArrayList<CKECPrivateKey> list(Slot slot) {
        return CKObject.list(slot, CKECPrivateKey.class, 3, 3);
    }
}

