/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.pkcs11;

import com.dyadicsec.pkcs11.CKException;
import com.dyadicsec.pkcs11.CKObject;
import com.dyadicsec.pkcs11.CKPublicKey;
import com.dyadicsec.pkcs11.CK_ATTRIBUTE;
import com.dyadicsec.pkcs11.CK_MECHANISM;
import com.dyadicsec.pkcs11.ECCurve;
import com.dyadicsec.pkcs11.Policy;
import com.dyadicsec.pkcs11.Slot;
import com.dyadicsec.pkcs11.Utils;
import java.io.IOException;
import java.security.spec.ECPoint;
import java.util.ArrayList;
import java.util.Map;

public class CKECPublicKey
extends CKPublicKey {
    ECCurve curve = null;
    ECPoint point = null;

    CKECPublicKey() {
        this.keyType = 3;
    }

    @Override
    void prepareReadTemplate(Map<Integer, CK_ATTRIBUTE> template) {
        super.prepareReadTemplate(template);
        this.addReadTemplate(template, 384);
        this.addReadTemplate(template, 385);
    }

    @Override
    void saveReadTemplate(Map<Integer, CK_ATTRIBUTE> template) throws CKException {
        super.saveReadTemplate(template);
        this.curve = ECCurve.find(template.get(384).getValue());
        if (this.curve == null) {
            throw new CKException("Unsupported EC curve", 0);
        }
        try {
            this.point = this.curve.derDecodePoint(template.get(385).getValue());
        }
        catch (IOException e) {
            throw new CKException(e, "Can't decode ECPoint", 0);
        }
    }

    public static CKECPublicKey create(Slot slot, String name, Policy policy, ECCurve curve, ECPoint point) throws CKException {
        CKECPublicKey key = new CKECPublicKey();
        if (policy == null) {
            policy = CKPublicKey.getDefaultPolicy();
        }
        CK_ATTRIBUTE[] t = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1, policy.cka_token), new CK_ATTRIBUTE(0, 2), new CK_ATTRIBUTE(256, 3), new CK_ATTRIBUTE(266, policy.cka_verify), new CK_ATTRIBUTE(384, curve.getOidBin()), new CK_ATTRIBUTE(385, curve.derEncodePoint(point)), new CK_ATTRIBUTE(258, Utils.name2id(name))};
        key.create(slot, t);
        key.policy = policy;
        key.curve = curve;
        key.point = point;
        key.name = name;
        return key;
    }

    public ECCurve getCurve() throws CKException {
        if (this.curve == null) {
            this.read();
        }
        return this.curve;
    }

    public ECPoint getPoint() throws CKException {
        if (this.point == null) {
            this.read();
        }
        return this.point;
    }

    public static CKECPublicKey find(Slot slot, String name) {
        return (CKECPublicKey)CKObject.find(slot, 2, 3, name);
    }

    public static CKECPublicKey find(Slot slot, long uid) {
        return CKObject.find(slot, CKECPublicKey.class, uid);
    }

    public static ArrayList<CKECPublicKey> list(Slot slot) {
        return CKObject.list(slot, CKECPublicKey.class, 2, 3);
    }

    public boolean verify(int mechanism, byte[] in, byte[] signature) throws CKException {
        return this.verify(new CK_MECHANISM(mechanism), in, signature);
    }
}

