/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.pkcs11;

import com.dyadicsec.pkcs11.CKException;
import com.dyadicsec.pkcs11.CKLIMAPublicKey;
import com.dyadicsec.pkcs11.CKPrivateKey;
import com.dyadicsec.pkcs11.CK_ATTRIBUTE;
import com.dyadicsec.pkcs11.CK_MECHANISM;
import com.dyadicsec.pkcs11.Policy;
import com.dyadicsec.pkcs11.Slot;
import com.dyadicsec.pkcs11.Utils;
import java.util.Map;

public final class CKLIMAPrivateKey
extends CKPrivateKey {
    byte[] pubKeyValue = null;
    CKLIMAPublicKey pubKey = null;

    CKLIMAPrivateKey() {
        this.keyType = -2147454713;
    }

    @Override
    void prepareReadTemplate(Map<Integer, CK_ATTRIBUTE> template) {
        super.prepareReadTemplate(template);
        this.addReadTemplate(template, -2147454457);
    }

    @Override
    void saveReadTemplate(Map<Integer, CK_ATTRIBUTE> template) throws CKException {
        super.saveReadTemplate(template);
        this.pubKeyValue = template.get(-2147454457).getValue();
    }

    public byte[] getPublicKeyValue() throws CKException {
        if (this.pubKeyValue == null) {
            this.read();
        }
        return this.pubKeyValue;
    }

    public CKLIMAPublicKey getPublicKey() throws CKException {
        if (this.pubKey == null) {
            this.pubKey = CKLIMAPublicKey.create(this.slot, null, null, this.getPublicKeyValue());
        }
        return this.pubKey;
    }

    public static CKLIMAPrivateKey generate(Slot slot, String name, Policy policy) throws CKException {
        CKLIMAPrivateKey key = new CKLIMAPrivateKey();
        if (policy == null) {
            policy = new Policy();
        }
        CK_ATTRIBUTE[] tPrv = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1, policy.cka_token), new CK_ATTRIBUTE(0, 3), new CK_ATTRIBUTE(256, -2147454713), new CK_ATTRIBUTE(259, policy.cka_sensitive), new CK_ATTRIBUTE(354, policy.cka_extractable), new CK_ATTRIBUTE(261, policy.cka_decrypt), new CK_ATTRIBUTE(263, policy.cka_unwrap), new CK_ATTRIBUTE(258, Utils.name2id(name))};
        CK_ATTRIBUTE[] tPub = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1, false), new CK_ATTRIBUTE(0, 2), new CK_ATTRIBUTE(256, -2147454713)};
        key.generateKeyPair(slot, -2147451310, tPub, tPrv);
        key.policy = policy;
        return key;
    }

    public byte[] decrypt(byte[] in) throws CKException {
        return this.decrypt(new CK_MECHANISM(-2147451311), in, 0);
    }
}

