/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.pkcs11;

import com.dyadicsec.pkcs11.CKException;
import com.dyadicsec.pkcs11.CK_ATTRIBUTE;
import com.dyadicsec.pkcs11.Policy;
import com.dyadicsec.pkcs11.Slot;
import com.dyadicsec.pkcs11.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class CKObject {
    int handle = 0;
    Slot slot = null;
    long uid = 0L;
    long replacedUID = -1L;
    int clazz = -1;
    String name;
    Policy policy = null;

    CKObject() {
    }

    CKObject(int handle) {
        this.handle = handle;
    }

    void addReadTemplate(Map<Integer, CK_ATTRIBUTE> template, int attribute) {
        template.put(attribute, new CK_ATTRIBUTE(attribute));
    }

    void prepareReadTemplate(Map<Integer, CK_ATTRIBUTE> template) {
        this.addReadTemplate(template, 1);
        this.addReadTemplate(template, -2147454463);
        this.addReadTemplate(template, 258);
        this.addReadTemplate(template, -2147454459);
    }

    void saveReadTemplate(Map<Integer, CK_ATTRIBUTE> template) throws CKException {
        this.policy.setToken(template.get(1).toBool());
        this.uid = template.get(-2147454463).toLong();
        this.name = Utils.id2name(template.get(258).getValue());
        this.replacedUID = template.get(-2147454459).toLong();
    }

    void read() throws CKException {
        HashMap<Integer, CK_ATTRIBUTE> template = new HashMap<Integer, CK_ATTRIBUTE>();
        this.prepareReadTemplate(template);
        CK_ATTRIBUTE[] array = template.values().toArray(new CK_ATTRIBUTE[0]);
        this.getAttributeValue(array);
        if (this.policy == null) {
            this.policy = new Policy();
        }
        this.saveReadTemplate(template);
    }

    public int getHandle() {
        return this.handle;
    }

    public Slot getSlot() {
        return this.slot;
    }

    public void destroy() throws CKException {
        this.slot.destroyObject(this.handle);
    }

    public void create(Slot slot, CK_ATTRIBUTE[] template) throws CKException {
        if (slot == null) {
            slot = Slot.getDefault();
        }
        this.handle = slot.createObject(template);
        this.slot = slot;
    }

    public Policy getPolicy() throws CKException {
        if (this.policy == null) {
            this.policy = new Policy();
            if (this.handle != 0) {
                this.read();
            }
        }
        return this.policy;
    }

    public int getAttributeSize(int attribute) throws CKException {
        return this.slot.getAttributeSize(this.handle, attribute);
    }

    public void getAttributeValue(CK_ATTRIBUTE[] template) throws CKException {
        this.slot.getAttributeValue(this.handle, template);
    }

    public void setAttributeValue(CK_ATTRIBUTE[] template) throws CKException {
        this.slot.setAttributeValue(this.handle, template);
    }

    public byte[] getAttributeValue(int type) throws CKException {
        CK_ATTRIBUTE[] t = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(type)};
        this.slot.getAttributeValue(this.handle, t);
        return t[0].getValue();
    }

    public int getAttributeValueInt(int type) throws CKException {
        CK_ATTRIBUTE[] t = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(type)};
        this.slot.getAttributeValue(this.handle, t);
        return t[0].toInt();
    }

    public boolean getAttributeValueBool(int type) throws CKException {
        CK_ATTRIBUTE[] t = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(type)};
        this.slot.getAttributeValue(this.handle, t);
        return t[0].toBool();
    }

    public long getAttributeValueLong(int type) throws CKException {
        CK_ATTRIBUTE[] t = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(type)};
        this.slot.getAttributeValue(this.handle, t);
        return t[0].toLong();
    }

    public long getUID() throws CKException {
        if (this.uid == 0L) {
            this.read();
        }
        return this.uid;
    }

    public long getReplacedUID() throws CKException {
        if (this.replacedUID == -1L) {
            this.read();
        }
        return this.replacedUID;
    }

    public int getClazz() {
        return this.clazz;
    }

    public String getName() throws CKException {
        return Utils.id2name(this.getAttributeValue(258));
    }

    public void setName(String name) throws CKException {
        this.setAttributeValue(new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258, Utils.name2id(name))});
    }

    public static <T extends CKObject> T find(Slot slot, Class<T> c, CK_ATTRIBUTE[] template) {
        if (slot == null) {
            return Slot.findObjectInAllSlots(c, template);
        }
        return slot.findObject(c, template);
    }

    public static <T extends CKObject> T find(Slot slot, Class<T> c, long uid) {
        if (slot == null) {
            return Slot.findObjectInAllSlots(c, uid);
        }
        return slot.findObject(c, uid);
    }

    public static CKObject find(Slot slot, int clazz, int keyType, String name) {
        if (slot == null) {
            return Slot.findObjectInAllSlots(clazz, keyType, name);
        }
        return slot.findObject(clazz, keyType, name);
    }

    public static <T extends CKObject> ArrayList<T> list(Slot slot, Class<T> c, CK_ATTRIBUTE[] template) {
        if (slot == null) {
            return Slot.findObjectsInAllSlots(c, template);
        }
        return slot.findObjects(c, template);
    }

    public static <T extends CKObject> ArrayList<T> list(Slot slot, Class<T> c, int clazz, int keyType) {
        if (slot == null) {
            return Slot.findObjectsInAllSlots(c, clazz, keyType);
        }
        return slot.findObjects(c, clazz, keyType);
    }

    public static ArrayList<CKObject> list(Slot slot, int clazz, int keyType) {
        if (slot == null) {
            return Slot.findObjectsInAllSlots(clazz, keyType);
        }
        return slot.findObjects(clazz, keyType);
    }
}

