/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.pkcs11;

import com.dyadicsec.pkcs11.CKException;
import com.dyadicsec.pkcs11.CKKey;
import com.dyadicsec.pkcs11.CKObject;
import com.dyadicsec.pkcs11.CKSecretKey;
import com.dyadicsec.pkcs11.CK_ATTRIBUTE;
import com.dyadicsec.pkcs11.CK_GCM_PARAMS;
import com.dyadicsec.pkcs11.CK_MECHANISM;
import com.dyadicsec.pkcs11.DYCK_PRF_PARAMS;
import com.dyadicsec.pkcs11.Policy;
import com.dyadicsec.pkcs11.Session;
import com.dyadicsec.pkcs11.Slot;
import com.dyadicsec.pkcs11.Utils;
import com.unbound.common.crypto.AES;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.crypto.AEADBadTagException;

public final class CKPRFKey
extends CKKey {
    static final int PRF_TWEAK_LEN = 16;
    static final int PRF_GCM_TAG_LEN = 12;
    static final int AES_BLOCK_LEN = 16;

    protected CKPRFKey() {
        this.keyType = -2147454717;
        this.clazz = 3;
    }

    @Override
    void prepareReadTemplate(Map<Integer, CK_ATTRIBUTE> template) {
        super.prepareReadTemplate(template);
        this.addReadTemplate(template, 261);
    }

    @Override
    void saveReadTemplate(Map<Integer, CK_ATTRIBUTE> template) throws CKException {
        super.saveReadTemplate(template);
        this.policy.cka_decrypt = template.get(261).toBool();
        this.policy.cka_sensitive = true;
        this.policy.cka_private = true;
        this.policy.cka_encrypt = true;
        this.policy.cka_extractable = false;
        this.policy.cka_unwrap = false;
        this.policy.cka_wrap = false;
        this.policy.cka_verify = false;
        this.policy.cka_sign = false;
    }

    public static CKPRFKey find(Slot slot, String name) {
        return (CKPRFKey)CKObject.find(slot, 3, -2147454717, name);
    }

    public static CKPRFKey find(Slot slot, long uid) {
        return CKObject.find(slot, CKPRFKey.class, uid);
    }

    public static ArrayList<CKPRFKey> list(Slot slot) {
        return CKObject.list(slot, CKPRFKey.class, 3, -2147454717);
    }

    public static CKPRFKey generate(Slot slot, String name, Policy policy) throws CKException {
        CKPRFKey key = new CKPRFKey();
        if (policy == null) {
            policy = new Policy();
        }
        CK_ATTRIBUTE[] t = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1, policy.cka_token), new CK_ATTRIBUTE(0, 3), new CK_ATTRIBUTE(256, -2147454717), new CK_ATTRIBUTE(261, policy.cka_decrypt), new CK_ATTRIBUTE(268, policy.cka_derive), new CK_ATTRIBUTE(258, Utils.name2id(name))};
        key.generateKey(slot, -2147451374, t);
        key.policy = policy;
        return key;
    }

    public byte[] prf(byte[] tweak, int secretSize) throws CKException {
        return this.prf(0, tweak, secretSize);
    }

    public CKSecretKey derive(int purpose, byte[] tweak, int keyType, int bitSize) throws CKException {
        CK_ATTRIBUTE[] t = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1, false), new CK_ATTRIBUTE(0, 4), new CK_ATTRIBUTE(256, keyType), new CK_ATTRIBUTE(259, false), new CK_ATTRIBUTE(353, bitSize / 8)};
        DYCK_PRF_PARAMS m = new DYCK_PRF_PARAMS(purpose, tweak, bitSize / 8);
        return this.derive(CKSecretKey.class, m, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] prf(int purpose, byte[] tweak, int outLen) throws CKException {
        CKSecretKey temp = this.derive(purpose, tweak, 16, outLen * 8);
        try {
            byte[] byArray = temp.getValue();
            return byArray;
        }
        finally {
            temp.destroy();
        }
    }

    public static byte[] encrypt(byte[] tweak, byte[] KM, byte[] aad, byte[] in) {
        byte[] blocks = new byte[48];
        blocks[15] = 0;
        blocks[31] = 1;
        blocks[31] = 2;
        byte[] e = new AES(KM).encrypt(blocks);
        byte[] KValue = Arrays.copyOfRange(e, 0, 32);
        byte[] IV = Arrays.copyOfRange(e, 32, 48);
        byte[] enc = AES.GCM.encrypt(KValue, IV, aad, 12, in);
        byte[] out = new byte[16 + enc.length];
        System.arraycopy(enc, 0, out, 16, enc.length);
        System.arraycopy(tweak, 0, out, 0, 16);
        return out;
    }

    public static byte[] getDecryptTweak(byte[] in) {
        return Arrays.copyOfRange(in, 0, 16);
    }

    public static byte[] decrypt(byte[] KM, byte[] aad, byte[] in) throws AEADBadTagException {
        byte[] blocks = new byte[48];
        blocks[15] = 0;
        blocks[31] = 1;
        blocks[31] = 2;
        byte[] e = new AES(KM).encrypt(blocks);
        byte[] KValue = Arrays.copyOfRange(e, 0, 32);
        byte[] IV = Arrays.copyOfRange(e, 32, 48);
        byte[] dec = AES.GCM.decrypt(KValue, IV, aad, 12, Arrays.copyOfRange(in, 16, in.length));
        return dec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encrypt(byte[] aad, byte[] in) throws CKException {
        byte[] byArray;
        byte[] tweak = this.slot.generateRandom(16);
        CKSecretKey KM = this.derive(0, tweak, 31, 256);
        CKObject K = null;
        Session session = null;
        try {
            byte[] blocks = new byte[48];
            blocks[15] = 0;
            blocks[31] = 1;
            blocks[31] = 2;
            byte[] e = KM.encrypt(new CK_MECHANISM(4225), blocks, blocks.length);
            byte[] KValue = Arrays.copyOfRange(e, 0, 32);
            byte[] IV = Arrays.copyOfRange(e, 32, 48);
            K = CKSecretKey.create(this.slot, null, new Policy().setToken(false), 31, KValue);
            byte[] out = new byte[16 + in.length + 12];
            System.arraycopy(tweak, 0, out, 0, 16);
            CK_GCM_PARAMS m = new CK_GCM_PARAMS(IV, aad, 96);
            session = ((CKKey)K).encryptInit(m);
            session.encrypt(in, 0, in.length, out, 16);
            byArray = out;
        }
        catch (Throwable throwable) {
            KM.destroy();
            if (K != null) {
                K.destroy();
            }
            this.slot.releaseSession(session);
            throw throwable;
        }
        KM.destroy();
        if (K != null) {
            K.destroy();
        }
        this.slot.releaseSession(session);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decrypt(byte[] aad, byte[] in) throws CKException {
        byte[] byArray;
        int outLen = in.length - 28;
        if (outLen < 0) {
            throw new CKException("Decrypt using PRF", 65);
        }
        byte[] tweak = Arrays.copyOfRange(in, 0, 16);
        CKSecretKey KM = this.derive(0, tweak, 31, 256);
        CKObject K = null;
        Session session = null;
        try {
            byte[] blocks = new byte[48];
            blocks[15] = 0;
            blocks[31] = 1;
            blocks[31] = 2;
            byte[] e = KM.encrypt(new CK_MECHANISM(4225), blocks, blocks.length);
            byte[] KValue = Arrays.copyOfRange(e, 0, 32);
            byte[] IV = Arrays.copyOfRange(e, 32, 48);
            K = CKSecretKey.create(this.slot, null, new Policy().setToken(false), 31, KValue);
            byte[] out = new byte[outLen];
            CK_GCM_PARAMS m = new CK_GCM_PARAMS(IV, aad, 96);
            session = ((CKKey)K).decryptInit(m);
            session.decrypt(in, 16, in.length - 16, out, 0);
            byArray = out;
        }
        catch (Throwable throwable) {
            KM.destroy();
            if (K != null) {
                K.destroy();
            }
            this.slot.releaseSession(session);
            throw throwable;
        }
        KM.destroy();
        if (K != null) {
            K.destroy();
        }
        this.slot.releaseSession(session);
        return byArray;
    }

    @Override
    public CKPRFKey rekey() throws CKException {
        return (CKPRFKey)super.rekey();
    }
}

