/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.pkcs11;

import com.dyadicsec.pkcs11.CKException;
import com.dyadicsec.pkcs11.CKKey;
import com.dyadicsec.pkcs11.CKObject;
import com.dyadicsec.pkcs11.CK_ATTRIBUTE;
import com.dyadicsec.pkcs11.CK_MECHANISM;
import com.dyadicsec.pkcs11.Policy;
import com.dyadicsec.pkcs11.Slot;
import com.dyadicsec.pkcs11.Utils;
import java.util.ArrayList;
import java.util.Map;

public final class CKPasswordKey
extends CKKey {
    static CK_MECHANISM mech = new CK_MECHANISM(-2147451359);

    CKPasswordKey() {
        this.keyType = -2147454719;
        this.clazz = 3;
    }

    @Override
    void saveReadTemplate(Map<Integer, CK_ATTRIBUTE> template) throws CKException {
        super.saveReadTemplate(template);
        this.policy.cka_sensitive = true;
        this.policy.cka_private = true;
        this.policy.cka_verify = true;
        this.policy.cka_encrypt = true;
        this.policy.cka_extractable = false;
        this.policy.cka_unwrap = false;
        this.policy.cka_wrap = false;
        this.policy.cka_decrypt = false;
        this.policy.cka_sign = false;
    }

    public static CKPasswordKey find(Slot slot, String name) {
        return (CKPasswordKey)CKObject.find(slot, 3, -2147454719, name);
    }

    public static CKPasswordKey find(Slot slot, long uid) {
        return CKObject.find(slot, CKPasswordKey.class, uid);
    }

    public static ArrayList<CKPasswordKey> list(Slot slot) {
        return CKObject.list(slot, CKPasswordKey.class, 3, -2147454719);
    }

    public static CKPasswordKey generate(Slot slot, String name, Policy policy) throws CKException {
        CKPasswordKey key = new CKPasswordKey();
        if (policy == null) {
            policy = new Policy();
        }
        CK_ATTRIBUTE[] t = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1, policy.cka_token), new CK_ATTRIBUTE(0, 3), new CK_ATTRIBUTE(256, -2147454719), new CK_ATTRIBUTE(258, Utils.name2id(name))};
        key.generateKey(slot, -2147451358, t);
        key.policy = policy;
        key.name = name;
        return key;
    }

    public byte[] encrypt(byte[] password) throws CKException {
        return this.encrypt(mech, password, 0);
    }

    public boolean verify(byte[] password, byte[] encrypted) throws CKException {
        return this.verify(mech, password, encrypted);
    }
}

