/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.pkcs11;

import com.dyadicsec.pkcs11.CKException;
import com.dyadicsec.pkcs11.CKKey;
import com.dyadicsec.pkcs11.CKObject;
import com.dyadicsec.pkcs11.CKPublicKey;
import com.dyadicsec.pkcs11.CK_ATTRIBUTE;
import com.dyadicsec.pkcs11.CK_MECHANISM;
import com.dyadicsec.pkcs11.Policy;
import com.dyadicsec.pkcs11.Slot;
import com.dyadicsec.pkcs11.Utils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Map;

public final class CKRSAPublicKey
extends CKPublicKey {
    int bitsSize = 0;
    BigInteger N = null;
    BigInteger E = null;

    CKRSAPublicKey() {
        this.keyType = 0;
    }

    @Override
    void prepareReadTemplate(Map<Integer, CK_ATTRIBUTE> template) {
        super.prepareReadTemplate(template);
        this.addReadTemplate(template, 290);
        this.addReadTemplate(template, 288);
    }

    @Override
    void saveReadTemplate(Map<Integer, CK_ATTRIBUTE> template) throws CKException {
        super.saveReadTemplate(template);
        byte[] NBuf = template.get(288).getValue();
        this.E = new BigInteger(1, template.get(290).getValue());
        this.N = new BigInteger(1, NBuf);
        this.bitsSize = NBuf.length * 8;
    }

    public BigInteger getE() throws CKException {
        if (this.E == null) {
            this.read();
        }
        return this.E;
    }

    public BigInteger getN() throws CKException {
        if (this.N == null) {
            this.read();
        }
        return this.N;
    }

    public static CKRSAPublicKey create(Slot slot, String name, Policy policy, BigInteger N, BigInteger E) throws CKException {
        byte[] NBuf = Utils.bigInt2Bytes(N, 0);
        CKRSAPublicKey key = new CKRSAPublicKey();
        if (policy == null) {
            policy = CKPublicKey.getDefaultPolicy();
        }
        CK_ATTRIBUTE[] t = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1, policy.cka_token), new CK_ATTRIBUTE(0, 2), new CK_ATTRIBUTE(256, 0), new CK_ATTRIBUTE(260, policy.cka_encrypt), new CK_ATTRIBUTE(266, policy.cka_verify), new CK_ATTRIBUTE(262, policy.cka_wrap), new CK_ATTRIBUTE(134, policy.cka_trusted), new CK_ATTRIBUTE(288, NBuf), new CK_ATTRIBUTE(290, E.toByteArray()), new CK_ATTRIBUTE(258, Utils.name2id(name))};
        key.create(slot, t);
        key.policy = policy;
        key.E = E;
        key.N = N;
        key.name = name;
        key.bitsSize = NBuf.length * 8;
        return key;
    }

    public int getBitsSize() throws CKException {
        if (this.bitsSize == 0) {
            this.read();
        }
        return this.bitsSize;
    }

    public static CKRSAPublicKey find(Slot slot, String name) {
        return (CKRSAPublicKey)CKObject.find(slot, 2, 0, name);
    }

    public static CKRSAPublicKey find(Slot slot, long uid) {
        return CKObject.find(slot, CKRSAPublicKey.class, uid);
    }

    public static ArrayList<CKRSAPublicKey> list(Slot slot) {
        return CKObject.list(slot, CKRSAPublicKey.class, 2, 0);
    }

    public byte[] encrypt(CK_MECHANISM mechanism, byte[] in) throws CKException {
        return super.encrypt(mechanism, in, this.getBitsSize() / 8);
    }

    public byte[] encrypt(int mechanism, byte[] in) throws CKException {
        return this.encrypt(new CK_MECHANISM(mechanism), in);
    }

    public byte[] wrap(CK_MECHANISM mechanism, CKKey key) throws CKException {
        return super.wrap(mechanism, key, this.getBitsSize() / 8);
    }

    public byte[] wrap(int mechanism, CKKey key) throws CKException {
        return this.wrap(new CK_MECHANISM(mechanism), key);
    }

    public boolean verify(int mechanism, byte[] in, byte[] signature) throws CKException {
        return this.verify(new CK_MECHANISM(mechanism), in, signature);
    }
}

