/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.pkcs11;

import com.dyadicsec.pkcs11.CKException;
import com.dyadicsec.pkcs11.CKKey;
import com.dyadicsec.pkcs11.CKObject;
import com.dyadicsec.pkcs11.CK_ATTRIBUTE;
import com.dyadicsec.pkcs11.CK_MECHANISM;
import com.dyadicsec.pkcs11.DYCK_FPE_PARAMS;
import com.dyadicsec.pkcs11.DYCK_SPE_PARAMS;
import com.dyadicsec.pkcs11.Policy;
import com.dyadicsec.pkcs11.Slot;
import com.dyadicsec.pkcs11.Utils;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;

public final class CKSecretKey
extends CKKey {
    int bitSize = 0;

    CKSecretKey() {
        this.clazz = 4;
    }

    @Override
    void prepareReadTemplate(Map<Integer, CK_ATTRIBUTE> template) {
        super.prepareReadTemplate(template);
        this.addReadTemplate(template, 256);
        this.addReadTemplate(template, 353);
    }

    @Override
    void saveReadTemplate(Map<Integer, CK_ATTRIBUTE> template) throws CKException {
        super.saveReadTemplate(template);
        this.keyType = template.get(256).toInt();
        this.bitSize = template.get(353).toInt() * 8;
    }

    public byte[] getValue() throws CKException {
        return this.getAttributeValue(17);
    }

    public int getBitSize() throws CKException {
        if (this.bitSize == 0) {
            this.read();
        }
        return this.bitSize;
    }

    public static CK_ATTRIBUTE[] getUnwrapTemplate(String name, Policy policy, int keyType) {
        if (policy == null) {
            policy = new Policy();
        }
        return new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1, policy.cka_token), new CK_ATTRIBUTE(2, true), new CK_ATTRIBUTE(0, 4), new CK_ATTRIBUTE(256, keyType), new CK_ATTRIBUTE(268, policy.cka_derive), new CK_ATTRIBUTE(259, policy.cka_sensitive), new CK_ATTRIBUTE(354, policy.cka_extractable), new CK_ATTRIBUTE(260, policy.cka_encrypt), new CK_ATTRIBUTE(261, policy.cka_decrypt), new CK_ATTRIBUTE(264, policy.cka_sign), new CK_ATTRIBUTE(266, policy.cka_verify), new CK_ATTRIBUTE(262, policy.cka_wrap), new CK_ATTRIBUTE(263, policy.cka_unwrap), new CK_ATTRIBUTE(134, policy.cka_trusted)};
    }

    public static CKSecretKey generate(Slot slot, String name, Policy policy, int keyType, int bitSize) throws CKException {
        if (policy == null) {
            policy = new Policy();
        }
        CKSecretKey key = new CKSecretKey();
        if (keyType == 21) {
            bitSize = 192;
        }
        CK_ATTRIBUTE[] t = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1, policy.cka_token), new CK_ATTRIBUTE(0, 4), new CK_ATTRIBUTE(256, keyType), new CK_ATTRIBUTE(259, policy.cka_sensitive), new CK_ATTRIBUTE(354, policy.cka_extractable), new CK_ATTRIBUTE(260, policy.cka_encrypt), new CK_ATTRIBUTE(261, policy.cka_decrypt), new CK_ATTRIBUTE(264, policy.cka_sign), new CK_ATTRIBUTE(266, policy.cka_verify), new CK_ATTRIBUTE(262, policy.cka_wrap), new CK_ATTRIBUTE(263, policy.cka_unwrap), new CK_ATTRIBUTE(134, policy.cka_trusted), new CK_ATTRIBUTE(353, bitSize / 8), new CK_ATTRIBUTE(258, Utils.name2id(name))};
        int genMechanism = CKSecretKey.getGenerateMechanism(keyType);
        key.generateKey(slot, genMechanism, t);
        key.bitSize = bitSize;
        key.keyType = keyType;
        key.policy = policy;
        key.name = name;
        return key;
    }

    public static CKSecretKey create(Slot slot, String name, Policy policy, int keyType, byte[] value) throws CKException {
        if (policy == null) {
            policy = new Policy();
        }
        CKSecretKey key = new CKSecretKey();
        CK_ATTRIBUTE[] t = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1, policy.cka_token), new CK_ATTRIBUTE(0, 4), new CK_ATTRIBUTE(256, keyType), new CK_ATTRIBUTE(259, policy.cka_sensitive), new CK_ATTRIBUTE(354, policy.cka_extractable), new CK_ATTRIBUTE(260, policy.cka_encrypt), new CK_ATTRIBUTE(261, policy.cka_decrypt), new CK_ATTRIBUTE(264, policy.cka_sign), new CK_ATTRIBUTE(266, policy.cka_verify), new CK_ATTRIBUTE(262, policy.cka_wrap), new CK_ATTRIBUTE(263, policy.cka_unwrap), new CK_ATTRIBUTE(134, policy.cka_trusted), new CK_ATTRIBUTE(17, value), new CK_ATTRIBUTE(258, Utils.name2id(name))};
        key.create(slot, t);
        key.bitSize = value.length * 8;
        key.keyType = keyType;
        key.policy = policy;
        key.name = name;
        return key;
    }

    public static CKSecretKey find(Slot slot, int keyType, String name) {
        return (CKSecretKey)CKObject.find(slot, 4, keyType, name);
    }

    public static CKSecretKey find(Slot slot, String name) {
        return CKSecretKey.find(slot, -1, name);
    }

    public static CKSecretKey find(Slot slot, long uid) {
        return CKObject.find(slot, CKSecretKey.class, uid);
    }

    public static ArrayList<CKSecretKey> list(Slot slot, int keyType) {
        return CKObject.list(slot, CKSecretKey.class, 4, keyType);
    }

    public static ArrayList<CKSecretKey> list(Slot slot) {
        return CKSecretKey.list(slot, -1);
    }

    public byte[] hmacSha256(byte[] in) throws CKException {
        return this.sign(new CK_MECHANISM(593), in, 32);
    }

    public byte[] encryptFPE(int mode, char[] format, int maxLen, byte[] in) throws CKException {
        int outLen = 0;
        if (mode == 2 || mode == 3 || mode == 4) {
            outLen = format != null && format.length != 0 ? in.length : in.length;
        }
        return this.encrypt(new DYCK_FPE_PARAMS(mode, format, maxLen), in, outLen);
    }

    public byte[] decryptFPE(int mode, char[] format, byte[] in) throws CKException {
        int outLen = 0;
        if (mode == 2 || mode == 3 || mode == 4) {
            outLen = format != null && format.length != 0 ? in.length : in.length;
        }
        return this.decrypt(new DYCK_FPE_PARAMS(mode, format, 0), in, outLen);
    }

    public byte[] encryptSPE(byte[] in, int bits) throws CKException {
        return this.encrypt(new DYCK_SPE_PARAMS(bits), in, in.length);
    }

    public byte[] decryptSPE(byte[] in, int bits) throws CKException {
        return this.decrypt(new DYCK_SPE_PARAMS(bits), in, in.length);
    }

    public byte[] encryptOPE(byte[] in) throws CKException {
        return this.encrypt(new CK_MECHANISM(-2147451371), in, in.length + 4);
    }

    public byte[] decryptOPE(byte[] in) throws CKException {
        if (in.length < 5) {
            throw new CKException("decryptOPE", 65);
        }
        return this.decrypt(new CK_MECHANISM(-2147451371), in, in.length - 4);
    }

    public String encryptStringFPE(String in, String format) throws CKException {
        try {
            byte[] inBuf = in.getBytes("UTF-16BE");
            byte[] outBuf = this.encryptFPE(5, format.toCharArray(), 0, inBuf);
            return new String(outBuf, "UTF-16BE");
        }
        catch (UnsupportedEncodingException e) {
            throw new CKException("Unsupported encoding", 32);
        }
    }

    public String decryptStringFPE(String in, String format) throws CKException {
        try {
            byte[] inBuf = in.getBytes("UTF-16BE");
            byte[] outBuf = this.decryptFPE(5, format.toCharArray(), inBuf);
            return new String(outBuf, "UTF-16BE");
        }
        catch (UnsupportedEncodingException e) {
            throw new CKException("Unsupported encoding", 64);
        }
    }
}

