/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.pkcs11;

import com.dyadicsec.pkcs11.Utils;
import java.security.InvalidParameterException;

public final class CK_ATTRIBUTE {
    int type;
    byte[] value;
    int intValue;
    static final int[] boolAttrList = new int[]{1, 2, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 354, 355, 356, 357, 368, 134, -2147454454, -2147454400};
    static final int[] intAttrList = new int[]{0, 128, 135, 358, 256, 289, 353, -2147454448, -2147454447, -2147418142};

    public CK_ATTRIBUTE(int type) {
        this.type = type;
    }

    public CK_ATTRIBUTE(int type, byte[] value) {
        if (CK_ATTRIBUTE.isBool(type)) {
            throw new InvalidParameterException("This PKCS#11 parameter should be boolean");
        }
        if (CK_ATTRIBUTE.isInt(type)) {
            throw new InvalidParameterException("This PKCS#11 parameter should be integer");
        }
        this.type = type;
        this.value = value;
    }

    public CK_ATTRIBUTE(int type, long value) {
        if (CK_ATTRIBUTE.isBool(type)) {
            throw new InvalidParameterException("This PKCS#11 parameter should be boolean");
        }
        if (CK_ATTRIBUTE.isInt(type)) {
            throw new InvalidParameterException("This PKCS#11 parameter should be integer");
        }
        this.type = type;
        this.value = Utils.uidToBytes(value);
    }

    public CK_ATTRIBUTE(int type, int value) {
        if (CK_ATTRIBUTE.isBool(type)) {
            throw new InvalidParameterException("This PKCS#11 parameter should be boolean");
        }
        if (!CK_ATTRIBUTE.isInt(type)) {
            throw new InvalidParameterException("This PKCS#11 parameter should not be integer");
        }
        this.type = type;
        this.intValue = value;
    }

    public CK_ATTRIBUTE(int type, boolean value) {
        if (CK_ATTRIBUTE.isInt(type)) {
            throw new InvalidParameterException("This PKCS#11 parameter should be integer");
        }
        if (!CK_ATTRIBUTE.isBool(type)) {
            throw new InvalidParameterException("This PKCS#11 parameter should not be boolean");
        }
        this.type = type;
        this.intValue = value ? 1 : 0;
    }

    static boolean isBool(int type) {
        for (int t : boolAttrList) {
            if (t != type) continue;
            return true;
        }
        return false;
    }

    static boolean isInt(int type) {
        for (int t : intAttrList) {
            if (t != type) continue;
            return true;
        }
        return false;
    }

    public int toInt() {
        if (CK_ATTRIBUTE.isBool(this.type)) {
            throw new InvalidParameterException("This PKCS#11 parameter should be boolean");
        }
        if (!CK_ATTRIBUTE.isInt(this.type)) {
            throw new InvalidParameterException("This PKCS#11 parameter should not be integer");
        }
        return this.intValue;
    }

    public boolean toBool() {
        if (CK_ATTRIBUTE.isInt(this.type)) {
            throw new InvalidParameterException("This PKCS#11 parameter should be integer");
        }
        if (!CK_ATTRIBUTE.isBool(this.type)) {
            throw new InvalidParameterException("This PKCS#11 parameter should not be boolean");
        }
        return this.intValue != 0;
    }

    public byte[] getValue() {
        if (CK_ATTRIBUTE.isBool(this.type)) {
            throw new InvalidParameterException("This PKCS#11 parameter should be boolean");
        }
        if (CK_ATTRIBUTE.isInt(this.type)) {
            throw new InvalidParameterException("This PKCS#11 parameter should be integer");
        }
        return this.value;
    }

    public long toLong() {
        if (CK_ATTRIBUTE.isBool(this.type)) {
            throw new InvalidParameterException("This PKCS#11 parameter should be boolean");
        }
        if (CK_ATTRIBUTE.isInt(this.type)) {
            throw new InvalidParameterException("This PKCS#11 parameter should be integer");
        }
        if (this.value.length != 8) {
            return 0L;
        }
        return Utils.bytesToUID(this.value);
    }
}

