/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.pkcs11;

import com.dyadicsec.pkcs11.DER;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.util.Arrays;

public final class ECCurve {
    private ECParameterSpec spec;
    private String name;
    private int bits;
    private byte[] oidBin;
    private static final ECCurve[] curves = new ECCurve[]{new ECCurve("secp256r1", 256, new byte[]{6, 8, 42, -122, 72, -50, 61, 3, 1, 7}), new ECCurve("secp384r1", 384, new byte[]{6, 5, 43, -127, 4, 0, 34}), new ECCurve("secp521r1", 521, new byte[]{6, 5, 43, -127, 4, 0, 35}), new ECCurve("secp256k1", 256, new byte[]{6, 5, 43, -127, 4, 0, 10})};

    private ECCurve(String name, int bits, byte[] oidBin) {
        this.name = name;
        this.bits = bits;
        this.oidBin = oidBin;
        try {
            AlgorithmParameters parameters = AlgorithmParameters.getInstance("EC");
            parameters.init(new ECGenParameterSpec(name));
            this.spec = parameters.getParameterSpec(ECParameterSpec.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] getOidBin() {
        return this.oidBin;
    }

    public ECParameterSpec getSpec() {
        return this.spec;
    }

    public int getSize() {
        return (this.bits + 7) / 8;
    }

    public int getBits() {
        return this.bits;
    }

    public static ECCurve find(String name) {
        for (ECCurve curve : curves) {
            if (!curve.name.equals(name)) continue;
            return curve;
        }
        return null;
    }

    public static ECCurve find(ECParameterSpec spec) {
        for (ECCurve curve : curves) {
            if (curve.spec.equals(spec)) {
                return curve;
            }
            if (!spec.getOrder().equals(curve.getSpec().getOrder())) continue;
            return curve;
        }
        return null;
    }

    public static ECCurve find(int bits) {
        for (ECCurve curve : curves) {
            if (curve.getBits() != bits) continue;
            return curve;
        }
        return null;
    }

    public static ECCurve find(byte[] oidBin) {
        for (ECCurve curve : curves) {
            if (!Arrays.equals(oidBin, curve.oidBin)) continue;
            return curve;
        }
        return null;
    }

    public ECPoint derDecodePoint(byte[] data) throws IOException {
        int n;
        if ((data = DER.decode((byte)4, data)).length != 1 + (n = this.getSize()) * 2) {
            throw new IOException("Point does not match field size");
        }
        if (data[0] != 4) {
            throw new IOException("Only uncompressed point format supported");
        }
        byte[] xb = Arrays.copyOfRange(data, 1, 1 + n);
        byte[] yb = Arrays.copyOfRange(data, 1 + n, 1 + n * 2);
        return new ECPoint(new BigInteger(1, xb), new BigInteger(1, yb));
    }

    private static byte[] bigIntToByteArray(BigInteger value, int size) {
        int offset;
        byte[] bytes = value.toByteArray();
        for (offset = 0; offset < bytes.length && bytes[offset] == 0; ++offset) {
        }
        int count = bytes.length - offset;
        byte[] out = new byte[size];
        System.arraycopy(bytes, offset, out, size - count, count);
        return out;
    }

    public byte[] derEncodePoint(ECPoint point) {
        int s = this.getSize();
        return DER.encode((byte)4, DER.cat({4}, ECCurve.bigIntToByteArray(point.getAffineX(), s), ECCurve.bigIntToByteArray(point.getAffineY(), s)));
    }
}

