/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.pkcs11;

import com.dyadicsec.pkcs11.CKCertificate;
import com.dyadicsec.pkcs11.CKData;
import com.dyadicsec.pkcs11.CKECPrivateKey;
import com.dyadicsec.pkcs11.CKECPublicKey;
import com.dyadicsec.pkcs11.CKEDDSAPrivateKey;
import com.dyadicsec.pkcs11.CKEDDSAPublicKey;
import com.dyadicsec.pkcs11.CKException;
import com.dyadicsec.pkcs11.CKLIMAPrivateKey;
import com.dyadicsec.pkcs11.CKLIMAPublicKey;
import com.dyadicsec.pkcs11.CKObject;
import com.dyadicsec.pkcs11.CKPRFKey;
import com.dyadicsec.pkcs11.CKPasswordKey;
import com.dyadicsec.pkcs11.CKRSAPrivateKey;
import com.dyadicsec.pkcs11.CKRSAPublicKey;
import com.dyadicsec.pkcs11.CKSecretKey;
import com.dyadicsec.pkcs11.CK_ATTRIBUTE;
import com.dyadicsec.pkcs11.CK_MECHANISM;
import com.dyadicsec.pkcs11.CK_SLOT_INFO;
import com.dyadicsec.pkcs11.CK_TOKEN_INFO;
import com.dyadicsec.pkcs11.CK_ULONG_PTR;
import com.dyadicsec.pkcs11.Library;
import com.dyadicsec.pkcs11.Session;
import com.dyadicsec.pkcs11.Utils;
import java.security.ProviderException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;

public final class Slot {
    private static Map<String, Slot> slotsByName = null;
    private static Map<Integer, Slot> slotsById = null;
    int id = -1;
    private String name = null;
    private int knownAuthReq = -1;
    private Queue<Session> sessions = new LinkedList<Session>();
    Session persistentSession;

    public Session getPersistentSession() {
        return this.persistentSession;
    }

    private Slot(int id) {
        this.id = id;
        CK_SLOT_INFO si = new CK_SLOT_INFO();
        int rv = Library.C_GetSlotInfo(id, si);
        this.name = rv == 0 ? new String(si.slotDescription) : "";
        try {
            this.persistentSession = this.openSession();
        }
        catch (CKException e) {
            throw new ProviderException(e);
        }
    }

    private static CK_ATTRIBUTE[] buildFindTemplate(int clazz, int keyType, String name) {
        int count = 1;
        CK_ATTRIBUTE aToken = new CK_ATTRIBUTE(1, true);
        CK_ATTRIBUTE aClass = null;
        CK_ATTRIBUTE aPrivate = null;
        CK_ATTRIBUTE aKeyType = null;
        CK_ATTRIBUTE aID = null;
        if (keyType != -1) {
            aKeyType = new CK_ATTRIBUTE(256, keyType);
            ++count;
        }
        if (name != null) {
            aID = new CK_ATTRIBUTE(258, Utils.name2id(name));
            ++count;
        }
        if (clazz != -1) {
            aClass = new CK_ATTRIBUTE(0, clazz);
            ++count;
            boolean isPrivate = clazz == 4 || clazz == 3;
            aPrivate = new CK_ATTRIBUTE(2, isPrivate);
            ++count;
        }
        CK_ATTRIBUTE[] t = new CK_ATTRIBUTE[count];
        count = 0;
        t[count++] = aToken;
        if (aClass != null) {
            t[count++] = aClass;
        }
        if (aPrivate != null) {
            t[count++] = aPrivate;
        }
        if (aKeyType != null) {
            t[count++] = aKeyType;
        }
        if (aID != null) {
            t[count++] = aID;
        }
        return t;
    }

    public static Iterable<Slot> getList() {
        return slotsById.values();
    }

    public static Slot find(String name) {
        if (name == null) {
            return Slot.getDefault();
        }
        return slotsByName.get(name);
    }

    public static Slot find(int id) {
        return slotsById.get(id);
    }

    public static Slot getDefault() {
        return slotsById.get(0);
    }

    public String getName() {
        return this.name;
    }

    public boolean isUserLoginRequired() {
        if (this.knownAuthReq < 0) {
            CK_TOKEN_INFO ti = new CK_TOKEN_INFO();
            int rv = Library.C_GetTokenInfo(this.id, ti);
            this.knownAuthReq = rv == 0 && (ti.flags & 4) != 0 ? 1 : 0;
        }
        return this.knownAuthReq > 0;
    }

    public int getID() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getSession() throws CKException {
        Queue<Session> queue = this.sessions;
        synchronized (queue) {
            if (!this.sessions.isEmpty()) {
                return this.sessions.remove();
            }
        }
        return this.openSession();
    }

    public Session openSession() throws CKException {
        long rvLong = Library.C_OpenSession(this.id, 6);
        int rv = Library.rvErr(rvLong);
        if (rv != 0) {
            throw new ProviderException("Error opening PKCS#11 session: rv=" + rv);
        }
        return new Session(this, Library.rvValue(rvLong));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSession(Session session) {
        if (session == null) {
            return;
        }
        if (session.handle == 0) {
            return;
        }
        if (session.operationInProgress) {
            session.close();
            return;
        }
        Queue<Session> queue = this.sessions;
        synchronized (queue) {
            this.sessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findObjectHandle(CK_ATTRIBUTE[] template) {
        int handle = 0;
        Session session = null;
        boolean init = false;
        try {
            session = this.getSession();
            int rv = session.C_FindObjectsInit(template);
            if (rv != 0) {
                throw new CKException("C_FindObjectsInit", rv);
            }
            init = true;
            int[] buffer = new int[1];
            long rvLong = session.C_FindObjects(buffer);
            if (Library.rvErr(rvLong) == 0 && Library.rvValue(rvLong) > 0) {
                handle = buffer[0];
            }
        }
        catch (CKException cKException) {
        }
        finally {
            if (init) {
                session.C_FindObjectsFinal();
            }
            this.releaseSession(session);
        }
        return handle;
    }

    CKObject newObject(int handle, int clazz, int keyType) {
        if (handle == 0) {
            return null;
        }
        CKObject object = null;
        block2 : switch (clazz) {
            case 1: {
                object = new CKCertificate();
                break;
            }
            case 4: {
                object = new CKSecretKey();
                break;
            }
            case 0: {
                object = new CKData();
                break;
            }
            case 3: {
                if (keyType == -1) {
                    try {
                        keyType = this.getAttributeValueInt(handle, 256);
                    }
                    catch (CKException e) {
                        return null;
                    }
                }
                switch (keyType) {
                    case 0: {
                        object = new CKRSAPrivateKey();
                        break;
                    }
                    case 3: {
                        object = new CKECPrivateKey();
                        break;
                    }
                    case -2147454713: {
                        object = new CKLIMAPrivateKey();
                        break;
                    }
                    case -2147454719: {
                        object = new CKPasswordKey();
                        break;
                    }
                    case -2147454717: {
                        object = new CKPRFKey();
                        break;
                    }
                    case -2147454712: {
                        object = new CKEDDSAPrivateKey();
                    }
                }
                break;
            }
            case 2: {
                if (keyType == -1) {
                    try {
                        keyType = this.getAttributeValueInt(handle, 256);
                    }
                    catch (CKException e) {
                        return null;
                    }
                }
                switch (keyType) {
                    case 0: {
                        object = new CKRSAPublicKey();
                        break block2;
                    }
                    case 3: {
                        object = new CKECPublicKey();
                        break block2;
                    }
                    case -2147454713: {
                        object = new CKLIMAPublicKey();
                        break block2;
                    }
                    case -2147454712: {
                        object = new CKEDDSAPublicKey();
                    }
                }
            }
        }
        if (object != null) {
            object.handle = handle;
            object.slot = this;
        }
        return object;
    }

    <T extends CKObject> T newObject(Class<T> c, int handle) {
        if (handle == 0) {
            return null;
        }
        try {
            CKObject object = (CKObject)c.newInstance();
            object.handle = handle;
            object.slot = this;
            return (T)object;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private <T extends CKObject> ArrayList<T> newObjects(Class<T> c, ArrayList<Integer> handles) {
        ArrayList<T> list = new ArrayList<T>();
        list.ensureCapacity(handles.size());
        for (Integer handle : handles) {
            list.add(this.newObject(c, handle));
        }
        return list;
    }

    public int findObjectHandle(long uid) {
        return this.findObjectHandle(new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(-2147454463, uid)});
    }

    public int findObjectHandle(int clazz, int keyType, String name) {
        return this.findObjectHandle(Slot.buildFindTemplate(clazz, keyType, name));
    }

    public <T extends CKObject> T findObject(Class<T> c, CK_ATTRIBUTE[] template) {
        return this.newObject(c, this.findObjectHandle(template));
    }

    public <T extends CKObject> T findObject(Class<T> clazz, long uid) {
        return this.newObject(clazz, this.findObjectHandle(uid));
    }

    public CKObject findObject(int clazz, int keyType, String name) {
        return this.newObject(this.findObjectHandle(clazz, keyType, name), clazz, keyType);
    }

    public static <T extends CKObject> T findObjectInAllSlots(Class<T> c, CK_ATTRIBUTE[] template) {
        for (Slot slot : slotsById.values()) {
            T object = slot.findObject(c, template);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public static <T extends CKObject> T findObjectInAllSlots(Class<T> c, long uid) {
        return Slot.findObjectInAllSlots(c, new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(-2147454463, uid)});
    }

    public static CKObject findObjectInAllSlots(int clazz, int keyType, String name) {
        CK_ATTRIBUTE[] template = Slot.buildFindTemplate(clazz, keyType, name);
        for (Slot slot : slotsById.values()) {
            int handle = slot.findObjectHandle(template);
            if (handle == 0) continue;
            return slot.newObject(handle, clazz, keyType);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Integer> findObjectHandles(CK_ATTRIBUTE[] template) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        Session session = null;
        boolean init = false;
        try {
            long rvLong;
            session = this.getSession();
            int rv = session.C_FindObjectsInit(template);
            if (rv != 0) {
                throw new CKException("C_FindObjectsInit", rv);
            }
            init = true;
            int MAX_COUNT = 256;
            int[] buffer = new int[256];
            block5: while ((rv = Library.rvErr(rvLong = session.C_FindObjects(buffer))) == 0) {
                int count = Library.rvValue(rvLong);
                if (count == 0) {
                    break;
                }
                list.ensureCapacity(list.size() + count);
                int i = 0;
                while (true) {
                    if (i >= count) continue block5;
                    list.add(buffer[i]);
                    ++i;
                }
                break;
            }
        }
        catch (CKException cKException) {
        }
        finally {
            if (init) {
                session.C_FindObjectsFinal();
            }
            this.releaseSession(session);
        }
        return list;
    }

    private ArrayList<CKObject> newObjects(ArrayList<Integer> handles, int clazz, int keyType) {
        ArrayList<CKObject> list = new ArrayList<CKObject>();
        list.ensureCapacity(handles.size());
        for (Integer handle : handles) {
            CKObject object = this.newObject(handle, clazz, keyType);
            if (object == null) continue;
            list.add(object);
        }
        return list;
    }

    public <T extends CKObject> ArrayList<T> findObjects(Class<T> c, CK_ATTRIBUTE[] template) {
        return this.newObjects(c, this.findObjectHandles(template));
    }

    public ArrayList<CKObject> findObjects(int clazz, int keyType) {
        return this.newObjects(this.findObjectHandles(Slot.buildFindTemplate(clazz, keyType, null)), clazz, keyType);
    }

    public <T extends CKObject> ArrayList<T> findObjects(Class<T> c, int clazz, int keyType) {
        return this.newObjects(c, this.findObjectHandles(Slot.buildFindTemplate(clazz, keyType, null)));
    }

    public static <T extends CKObject> ArrayList<T> findObjectsInAllSlots(Class<T> c, CK_ATTRIBUTE[] template) {
        ArrayList<T> list = new ArrayList<T>();
        for (Slot slot : slotsById.values()) {
            ArrayList<Integer> handles = slot.findObjectHandles(template);
            list.ensureCapacity(list.size() + handles.size());
            for (Integer handle : handles) {
                list.add(slot.newObject(c, handle));
            }
        }
        return list;
    }

    public static ArrayList<CKObject> findObjectsInAllSlots(int clazz, int keyType) {
        CK_ATTRIBUTE[] template = Slot.buildFindTemplate(clazz, keyType, null);
        ArrayList<CKObject> list = new ArrayList<CKObject>();
        for (Slot slot : slotsById.values()) {
            ArrayList<Integer> handles = slot.findObjectHandles(template);
            list.ensureCapacity(list.size() + handles.size());
            for (Integer handle : handles) {
                CKObject object = slot.newObject(handle, clazz, keyType);
                if (object == null) continue;
                list.add(object);
            }
        }
        return list;
    }

    public static <T extends CKObject> ArrayList<T> findObjectsInAllSlots(Class<T> c, int clazz, int keyType) {
        CK_ATTRIBUTE[] template = Slot.buildFindTemplate(clazz, keyType, null);
        ArrayList<T> list = new ArrayList<T>();
        for (Slot slot : slotsById.values()) {
            ArrayList<Integer> handles = slot.findObjectHandles(template);
            list.ensureCapacity(list.size() + handles.size());
            for (Integer handle : handles) {
                T object = slot.newObject(c, handle);
                if (object == null) continue;
                list.add(object);
            }
        }
        return list;
    }

    public int login(int userType, char[] password) {
        if (password != null && password.length == 0) {
            password = null;
        }
        if (this.knownAuthReq == 0 && password == null) {
            return 0;
        }
        int rv = this.persistentSession.C_Login(userType, password);
        if (userType == 1 || userType == -2147454975) {
            if (rv == 0 && password != null) {
                this.knownAuthReq = 1;
            }
            if (rv == 0 && password == null) {
                this.knownAuthReq = 0;
            }
            if (rv != 0 && password == null) {
                this.knownAuthReq = 1;
            }
        }
        return rv;
    }

    public int login(char[] password) {
        return this.login(1, password);
    }

    public void logout() {
        if (this.knownAuthReq == 0) {
            return;
        }
        this.persistentSession.C_Logout();
    }

    public int createObject(CK_ATTRIBUTE[] template) throws CKException {
        long rvLong = this.persistentSession.C_CreateObject(template);
        int rv = Library.rvErr(rvLong);
        if (rv != 0) {
            throw new CKException("C_CreateObject", rv);
        }
        return Library.rvValue(rvLong);
    }

    public void destroyObject(int handle) throws CKException {
        int rv = this.persistentSession.C_DestroyObject(handle);
        if (rv != 0) {
            throw new CKException("C_DestroyObject", rv);
        }
    }

    public int generateKey(int mechType, CK_ATTRIBUTE[] template) throws CKException {
        long rvLong = this.persistentSession.C_GenerateKey(new CK_MECHANISM(mechType), template);
        int rv = Library.rvErr(rvLong);
        if (rv != 0) {
            throw new CKException("C_GenerateKey", rv);
        }
        return Library.rvValue(rvLong);
    }

    public int generateKeyPair(int mechType, CK_ATTRIBUTE[] pubTemplate, CK_ATTRIBUTE[] prvTemplate) throws CKException {
        long rvLong = this.persistentSession.C_GenerateKeyPair(new CK_MECHANISM(mechType), pubTemplate, prvTemplate, null);
        int rv = Library.rvErr(rvLong);
        if (rv != 0) {
            throw new CKException("C_GenerateKeyPair", rv);
        }
        return Library.rvValue(rvLong);
    }

    public void setAttributeValue(int object, CK_ATTRIBUTE[] template) throws CKException {
        int rv = this.persistentSession.C_SetAttributeValue(object, template);
        if (rv != 0) {
            throw new CKException("C_SetAttributeValue", rv);
        }
    }

    public int getAttributeSize(int object, int attribute) throws CKException {
        CK_ULONG_PTR pSize = new CK_ULONG_PTR();
        int rv = this.persistentSession.C_GetAttributeSize(object, attribute, pSize);
        if (rv != 0) {
            throw new CKException("C_GetAttributeSize", rv);
        }
        return pSize.value;
    }

    public void getAttributeValue(int object, CK_ATTRIBUTE[] template) throws CKException {
        int rv = this.persistentSession.C_GetAttributeValue(object, template);
        if (rv != 0) {
            throw new CKException("C_GetAttributeValue", rv);
        }
    }

    public int getAttributeValueInt(int object, int attribute) throws CKException {
        CK_ATTRIBUTE[] t = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(attribute)};
        this.getAttributeValue(object, t);
        return t[0].toInt();
    }

    public int deriveKey(CK_MECHANISM mechanism, int key, CK_ATTRIBUTE[] t) throws CKException {
        long rvLong = this.persistentSession.C_DeriveKey(mechanism, key, t);
        int rv = Library.rvErr(rvLong);
        if (rv != 0) {
            throw new CKException("C_DeriveKey", rv);
        }
        return Library.rvValue(rvLong);
    }

    public int unwrapKey(CK_MECHANISM mechanism, int unwrappingKey, byte[] in, int inOffset, int inLen, CK_ATTRIBUTE[] template) throws CKException {
        long rvLong = this.persistentSession.C_UnwrapKey(mechanism, unwrappingKey, in, inOffset, inLen, template);
        int rv = Library.rvErr(rvLong);
        if (rv != 0) {
            throw new CKException("C_UnwrapKey", rv);
        }
        return Library.rvValue(rvLong);
    }

    public void generateRandom(byte[] out, int outOffset, int outLen) throws CKException {
        int rv = this.persistentSession.C_GenerateRandom(out, outOffset, outLen);
        if (rv != 0) {
            throw new CKException("C_GenerateRandom", rv);
        }
    }

    public byte[] generateRandom(int outLen) throws CKException {
        byte[] out = new byte[outLen];
        this.generateRandom(out, 0, outLen);
        return out;
    }

    static {
        int rv = Library.C_Initialize();
        if (rv != 0) {
            throw new ProviderException("Can't initialize PKCS11 library");
        }
        long rvLen = Library.C_GetSlotList(true, null);
        rv = Library.rvErr(rvLen);
        int count = Library.rvValue(rvLen);
        if (rv != 0) {
            count = 0;
        }
        int[] list = new int[count];
        if (count > 0) {
            rvLen = Library.C_GetSlotList(true, list);
            rv = Library.rvErr(rvLen);
            count = rv != 0 ? 0 : Library.rvValue(rvLen);
        }
        slotsByName = new HashMap<String, Slot>();
        slotsById = new HashMap<Integer, Slot>();
        for (int i = 0; i < count; ++i) {
            Slot slot = new Slot(list[i]);
            slotsById.put(list[i], slot);
            if (slot.name.isEmpty()) continue;
            slotsByName.put(slot.name, slot);
        }
    }
}

