/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.pkcs11;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.Arrays;

public final class Utils {
    public static long id2uid(byte[] id) {
        if (id.length != 9) {
            return 0L;
        }
        if (id[0] != 0) {
            return 0L;
        }
        long uid = 0L;
        for (int i = 1; i < 9; ++i) {
            uid <<= 8;
            uid += (long)(id[i] & 0xFF);
        }
        return uid;
    }

    public static byte[] uid2id(long uid) {
        byte[] id = new byte[9];
        id[0] = 0;
        for (int i = 8; i > 1; --i) {
            id[i] = (byte)uid;
            uid >>= 8;
        }
        return id;
    }

    private static boolean isPrintableChar(char ch) {
        if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9') {
            return true;
        }
        switch (ch) {
            case ' ': 
            case '\'': 
            case '(': 
            case ')': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case '=': 
            case '?': {
                return true;
            }
        }
        return false;
    }

    private static char hex2Char(int x) {
        return (x &= 0xF) < 10 ? (char)(48 + x) : (char)(97 + x - 10);
    }

    public static String id2name(byte[] id) {
        if (id.length == 0) {
            return "0x000000000000000000";
        }
        boolean printable = true;
        for (int i = 0; printable && i < id.length; ++i) {
            printable = Utils.isPrintableChar((char)id[i]);
        }
        if (printable) {
            try {
                return new String(id, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return "0x000000000000000000";
            }
        }
        char[] name = new char[2 + id.length * 2];
        int o = 0;
        name[o++] = 48;
        name[o++] = 120;
        for (int i = 0; i < id.length; ++i) {
            name[o++] = Utils.hex2Char(id[i] >> 4);
            name[o++] = Utils.hex2Char(id[i]);
        }
        return String.valueOf(name);
    }

    private static byte char2Hex(char c) {
        if (c >= '0' && c <= '9') {
            return (byte)(c - 48);
        }
        if (c >= 'a' && c <= 'f') {
            return (byte)(c - 97 + 10);
        }
        if (c >= 'A' && c <= 'F') {
            return (byte)(c - 65 + 10);
        }
        return 0;
    }

    public static byte[] name2id(String name) {
        int nameSize;
        if (name == null) {
            return new byte[0];
        }
        int n = nameSize = name == null ? 0 : name.length();
        if (nameSize >= 4 && name.charAt(0) == '0' && name.charAt(1) == 'x') {
            int idSize = (nameSize - 2) / 2;
            byte[] id = new byte[idSize];
            int p = 2;
            for (int i = 0; i < idSize; ++i) {
                char hi = name.charAt(p++);
                char lo = name.charAt(p++);
                id[i] = (byte)((Utils.char2Hex(hi) << 4) + Utils.char2Hex(lo));
            }
            return id;
        }
        try {
            return name.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return new byte[0];
        }
    }

    public static byte[] bigInt2Bytes(BigInteger b, int size) {
        byte[] bytes = b.toByteArray();
        if (bytes == null) {
            return null;
        }
        if (size == 0) {
            if (bytes[0] == 0) {
                return Arrays.copyOfRange(bytes, 1, bytes.length);
            }
            return bytes;
        }
        if (bytes.length == size) {
            return bytes;
        }
        if (bytes.length == size + 1 && bytes[0] == 0) {
            return Arrays.copyOfRange(bytes, 1, size + 1);
        }
        if (size > bytes.length) {
            byte[] result = new byte[size];
            System.arraycopy(bytes, 0, result, size - bytes.length, bytes.length);
            return result;
        }
        return null;
    }

    public static int bigIntByteSize(BigInteger b) {
        return b.bitLength() / 8;
    }

    public static void uidToBytes(long uid, byte[] out, int outOffset) {
        out[outOffset + 0] = (byte)(uid >> 56);
        out[outOffset + 1] = (byte)(uid >> 48);
        out[outOffset + 2] = (byte)(uid >> 40);
        out[outOffset + 3] = (byte)(uid >> 32);
        out[outOffset + 4] = (byte)(uid >> 24);
        out[outOffset + 5] = (byte)(uid >> 16);
        out[outOffset + 6] = (byte)(uid >> 8);
        out[outOffset + 7] = (byte)uid;
    }

    public static byte[] uidToBytes(long uid) {
        byte[] out = new byte[8];
        Utils.uidToBytes(uid, out, 0);
        return out;
    }

    private static long byteToULong(byte b) {
        return (long)b & 0xFFL;
    }

    public static long bytesToUID(byte[] in, int inOffset) {
        return Utils.byteToULong(in[inOffset + 0]) << 56 | Utils.byteToULong(in[inOffset + 1]) << 48 | Utils.byteToULong(in[inOffset + 2]) << 40 | Utils.byteToULong(in[inOffset + 3]) << 32 | Utils.byteToULong(in[inOffset + 4]) << 24 | Utils.byteToULong(in[inOffset + 5]) << 16 | Utils.byteToULong(in[inOffset + 6]) << 8 | Utils.byteToULong(in[inOffset + 7]);
    }

    public static long bytesToUID(byte[] in) {
        return Utils.bytesToUID(in, 0);
    }
}

