/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.provider;

import com.dyadicsec.cryptoki.Native;
import com.dyadicsec.pkcs11.CKException;
import com.dyadicsec.pkcs11.CK_MECHANISM_INFO;
import com.dyadicsec.pkcs11.Library;
import com.dyadicsec.pkcs11.Session;
import com.dyadicsec.pkcs11.Slot;
import com.dyadicsec.provider.ECPrivateKey;
import com.dyadicsec.provider.KeyStore;
import com.dyadicsec.provider.RSAPrivateKey;
import com.unbound.provider.UBCryptoProvider;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.ProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;

public final class DYCryptoProvider
extends Provider {
    public static final String NAME = "DYADIC";
    private static final long serialVersionUID = 1L;
    static KeyStore defaultKeyStore = null;
    private static Map<String, KeyStore> stores = new HashMap<String, KeyStore>();
    Slot slot = null;
    private static CK_MECHANISM_INFO mechInfo;
    static boolean allowedPrivateKeyWithoutCertificate;

    public DYCryptoProvider() {
        this((String)null);
    }

    public static KeyStore getDefaultKeyStore() {
        return defaultKeyStore;
    }

    private static boolean isHwMech(int[] mechList, int mechType) {
        for (int i = 0; i < mechList.length; ++i) {
            if (mechList[i] != mechType) continue;
            return true;
        }
        return false;
    }

    private static void appendMode(StringBuffer buf, String a) {
        if (buf.length() > 0) {
            buf.append("|");
        }
        buf.append(a);
    }

    @Override
    public Provider configure(String configArg) {
        return new DYCryptoProvider(configArg);
    }

    public static void allowPrivateKeyWithoutCertificate(boolean allow) {
        allowedPrivateKeyWithoutCertificate = allow;
        UBCryptoProvider.allowPrivateKeyWithoutCertificate(allow);
    }

    public DYCryptoProvider(String arg) {
        super(NAME, 1.0, "DyadicSec EKM security provider");
        StringBuffer modes;
        if ("1".equals(System.getenv("UKC_NO_NATIVE")) || !Native.loaded) {
            Provider.Service[] services;
            UBCryptoProvider proxyProvider = UBCryptoProvider.proxy(this, arg);
            if (proxyProvider == null) {
                return;
            }
            for (Provider.Service service : services = proxyProvider.register(this)) {
                this.putService(service);
            }
            return;
        }
        if (arg == null || arg.isEmpty()) {
            arg = System.getProperty("ekm.partition");
        }
        if (arg == null || arg.isEmpty()) {
            arg = System.getenv().get("EKM_PARTITION");
        }
        this.slot = arg == null || arg.isEmpty() ? Slot.getDefault() : Slot.find(arg);
        if (this.slot == null) {
            throw new ProviderException(String.format("Partition %s not found", arg));
        }
        defaultKeyStore = DYCryptoProvider.getKeyStoreBySlot(this.slot);
        String prefix = this.getClass().getPackage().getName() + ".";
        long rvLen = Library.C_GetMechanismList(-1, null);
        int rv = Library.rvErr(rvLen);
        int mechCount = Library.rvValue(rvLen);
        if (rv != 0) {
            mechCount = 0;
        }
        int[] mechList = new int[mechCount];
        if (mechCount > 0) {
            Library.C_GetMechanismList(-1, mechList);
        }
        if (DYCryptoProvider.isHwMech(mechList, 0)) {
            String rsaKeyClasses = "java.security.interfaces.RSAPublicKey|java.security.interfaces.RSAPrivateKey";
            this.put("KeyFactory.RSA", prefix + "RSAKeyFactory");
            this.put("KeyPairGenerator.RSA", prefix + "RSAKeyPairGenerator");
            this.put("Alg.Alias.KeyPairGenerator.1.2.840.113549.1.1", "RSA");
            this.put("Alg.Alias.KeyPairGenerator.OID.1.2.840.113549.1.1", "RSA");
            boolean hwRsaPkcs1 = DYCryptoProvider.isHwMech(mechList, 1);
            StringBuffer modes2 = new StringBuffer();
            if (hwRsaPkcs1) {
                DYCryptoProvider.appendMode(modes2, "PKCS1PADDING");
            }
            if (DYCryptoProvider.isHwMech(mechList, 3)) {
                DYCryptoProvider.appendMode(modes2, "NOPADDING");
            }
            if (DYCryptoProvider.isHwMech(mechList, 9)) {
                DYCryptoProvider.appendMode(modes2, "OAEPPADDING|OAEPWITHSHA1ANDMGF1PADDING|OAEPWITHSHA-1ANDMGF1PADDING|OAEPWITHSHA-256ANDMGF1PADDING|OAEPWITHSHA-384ANDMGF1PADDING|OAEPWITHSHA-512ANDMGF1PADDING");
            }
            if (modes2.length() > 0) {
                this.put("Cipher.RSA", prefix + "RSACipher");
                this.put("Cipher.RSA SupportedModes", "ECB");
                this.put("Cipher.RSA SupportedKeyClasses", "java.security.interfaces.RSAPublicKey|java.security.interfaces.RSAPrivateKey");
                this.put("Cipher.RSA SupportedPaddings", modes2.toString());
            }
            if (hwRsaPkcs1) {
                this.put("Signature.NONEwithRSA SupportedKeyClasses", "java.security.interfaces.RSAPublicKey|java.security.interfaces.RSAPrivateKey");
                this.put("Signature.NONEwithRSA", prefix + "RSASignature$NONEwithRSA");
            }
            if (DYCryptoProvider.isHwMech(mechList, 6)) {
                this.put("Signature.SHA1withRSA SupportedKeyClasses", "java.security.interfaces.RSAPublicKey|java.security.interfaces.RSAPrivateKey");
                this.put("Signature.SHA1withRSA", prefix + "RSASignature$SHA1withRSA");
                this.put("Alg.Alias.Signature.1.2.840.113549.1.1.5", "SHA1withRSA");
                this.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.5", "SHA1withRSA");
                this.put("Alg.Alias.Signature.1.3.14.3.2.29", "SHA1withRSA");
            }
            if (DYCryptoProvider.isHwMech(mechList, 64)) {
                this.put("Signature.SHA256withRSA SupportedKeyClasses", "java.security.interfaces.RSAPublicKey|java.security.interfaces.RSAPrivateKey");
                this.put("Signature.SHA256withRSA", prefix + "RSASignature$SHA256withRSA");
                this.put("Alg.Alias.Signature.1.2.840.113549.1.1.11", "SHA256withRSA");
                this.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.11", "SHA256withRSA");
            }
            if (DYCryptoProvider.isHwMech(mechList, 65)) {
                this.put("Signature.SHA384withRSA SupportedKeyClasses", "java.security.interfaces.RSAPublicKey|java.security.interfaces.RSAPrivateKey");
                this.put("Signature.SHA384withRSA", prefix + "RSASignature$SHA384withRSA");
                this.put("Alg.Alias.Signature.1.2.840.113549.1.1.12", "SHA384withRSA");
                this.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.12", "SHA384withRSA");
            }
            if (DYCryptoProvider.isHwMech(mechList, 66)) {
                this.put("Signature.SHA512withRSA SupportedKeyClasses", "java.security.interfaces.RSAPublicKey|java.security.interfaces.RSAPrivateKey");
                this.put("Signature.SHA512withRSA", prefix + "RSASignature$SHA512withRSA");
                this.put("Alg.Alias.Signature.1.2.840.113549.1.1.13", "SHA512withRSA");
                this.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.13", "SHA512withRSA");
            }
            if (DYCryptoProvider.isHwMech(mechList, 13)) {
                this.put("Signature.RSASSA-PSS", prefix + "RSASignature$PSS");
                this.put("Signature.RSASSA-PSS SupportedKeyClasses", "java.security.interfaces.RSAPublicKey|java.security.interfaces.RSAPrivateKey");
                this.put("Alg.Alias.Signature.1.2.840.113549.1.1.10", "RSASSA-PSS");
                this.put("Alg.Alias.Signature.OID.1.2.840.113549.1.1.10", "RSASSA-PSS");
            }
        }
        if (DYCryptoProvider.isHwMech(mechList, 4160)) {
            String ecKeyClasses = "java.security.interfaces.ECPublicKey|java.security.interfaces.ECPrivateKey";
            this.put("KeyFactory.EC", prefix + "ECKeyFactory");
            this.put("Alg.Alias.KeyFactory.EllipticCurve", "EC");
            this.put("KeyPairGenerator.EC", prefix + "ECKeyPairGenerator");
            if (DYCryptoProvider.isHwMech(mechList, 4161)) {
                this.put("Signature.NONEwithECDSA", prefix + "ECDSASignature$Raw");
                this.put("Signature.NONEwithECDSA SupportedKeyClasses", ecKeyClasses);
            }
            if (DYCryptoProvider.isHwMech(mechList, 4162)) {
                this.put("Signature.SHA1withECDSA", prefix + "ECDSASignature$SHA1");
                this.put("Signature.SHA1withECDSA SupportedKeyClasses", ecKeyClasses);
            }
            if (DYCryptoProvider.isHwMech(mechList, 4164)) {
                this.put("Signature.SHA256withECDSA", prefix + "ECDSASignature$SHA256");
                this.put("Signature.SHA256withECDSA SupportedKeyClasses", ecKeyClasses);
            }
            if (DYCryptoProvider.isHwMech(mechList, 4165)) {
                this.put("Signature.SHA384withECDSA", prefix + "ECDSASignature$SHA384");
                this.put("Signature.SHA384withECDSA SupportedKeyClasses", ecKeyClasses);
            }
            if (DYCryptoProvider.isHwMech(mechList, 4166)) {
                this.put("Signature.SHA512withECDSA", prefix + "ECDSASignature$SHA512");
                this.put("Signature.SHA512withECDSA SupportedKeyClasses", ecKeyClasses);
            }
            if (DYCryptoProvider.isHwMech(mechList, 4176)) {
                this.put("KeyAgreement.ECDH", prefix + "ECDHKeyAgreement");
                this.put("KeyAgreement.ECDH SupportedKeyClasses", ecKeyClasses);
            }
            if (DYCryptoProvider.isHwMech(mechList, -2147451248)) {
                this.put("Signature.Schnorr", prefix + "SchnorrSignature");
                this.put("Signature.Schnorr SupportedKeyClasses", ecKeyClasses);
            }
        }
        if (DYCryptoProvider.isHwMech(mechList, 4224)) {
            this.put("KeyGenerator.AES", prefix + "SecretKeyGenerator$AES");
            this.put("SecretKeyFactory.AES", prefix + "SecretKeyFactory$AES");
            modes = new StringBuffer();
            if (DYCryptoProvider.isHwMech(mechList, 4225)) {
                DYCryptoProvider.appendMode(modes, "ECB");
            }
            if (DYCryptoProvider.isHwMech(mechList, 4226)) {
                DYCryptoProvider.appendMode(modes, "CBC");
            }
            if (DYCryptoProvider.isHwMech(mechList, 8452)) {
                DYCryptoProvider.appendMode(modes, "OFB128");
            }
            if (DYCryptoProvider.isHwMech(mechList, 8455)) {
                DYCryptoProvider.appendMode(modes, "CFB128");
            }
            if (DYCryptoProvider.isHwMech(mechList, 4230)) {
                DYCryptoProvider.appendMode(modes, "CTR");
            }
            if (DYCryptoProvider.isHwMech(mechList, 4231)) {
                DYCryptoProvider.appendMode(modes, "GCM");
            }
            if (DYCryptoProvider.isHwMech(mechList, 4232)) {
                DYCryptoProvider.appendMode(modes, "CCM");
            }
            if (DYCryptoProvider.isHwMech(mechList, 8457)) {
                DYCryptoProvider.appendMode(modes, "WRAP");
            }
            if (modes.length() > 0) {
                this.put("Cipher.AES", prefix + "SecretKeyCipher$AES");
                this.put("Cipher.AES SupportedModes", modes.toString());
                this.put("Cipher.AES SupportedPaddings", "NOPADDING|PKCS5PADDING");
                this.put("Cipher.AES SupportedKeyFormats", "RAW");
            }
            if (DYCryptoProvider.isHwMech(mechList, 4234)) {
                this.put("Mac.CMAC", prefix + "Mac$CMAC");
            }
            if (DYCryptoProvider.isHwMech(mechList, 4238)) {
                this.put("Mac.GMAC", prefix + "Mac$GMAC");
            }
        }
        if (DYCryptoProvider.isHwMech(mechList, -2147451326)) {
            this.put("KeyGenerator.AESXTS", prefix + "SecretKeyGenerator$AESXTS");
            this.put("SecretKeyFactory.AESXTS", prefix + "SecretKeyFactory$AESXTS");
            if (DYCryptoProvider.isHwMech(mechList, -2147451327)) {
                this.put("Cipher.AESXTS", prefix + "SecretKeyCipher$AESXTS");
                this.put("Cipher.AESXTS SupportedModes", "XTS");
                this.put("Cipher.AESXTS SupportedPaddings", "NOPADDING");
                this.put("Cipher.AESXTS SupportedKeyFormats", "RAW");
            }
        }
        if (DYCryptoProvider.isHwMech(mechList, -2147451390)) {
            this.put("KeyGenerator.AESSIV", prefix + "SecretKeyGenerator$AESSIV");
            this.put("SecretKeyFactory.AESSIV", prefix + "SecretKeyFactory$AESSIV");
            if (DYCryptoProvider.isHwMech(mechList, -2147451391)) {
                this.put("Cipher.AESSIV", prefix + "SecretKeyCipher$AESSIV");
                this.put("Cipher.AESSIV SupportedModes", "SIV");
                this.put("Cipher.AESSIV SupportedPaddings", "NOPADDING");
                this.put("Cipher.AESSIV SupportedKeyFormats", "RAW");
            }
        }
        if (DYCryptoProvider.isHwMech(mechList, 305)) {
            this.put("KeyGenerator.DESede", prefix + "SecretKeyGenerator$DES3");
            this.put("SecretKeyFactory.DESede", prefix + "SecretKeyFactory$DES3");
            modes = new StringBuffer();
            if (DYCryptoProvider.isHwMech(mechList, 306)) {
                DYCryptoProvider.appendMode(modes, "ECB");
            }
            if (DYCryptoProvider.isHwMech(mechList, 307)) {
                DYCryptoProvider.appendMode(modes, "CBC");
            }
            if (DYCryptoProvider.isHwMech(mechList, 336)) {
                DYCryptoProvider.appendMode(modes, "OFB64");
            }
            if (DYCryptoProvider.isHwMech(mechList, 338)) {
                DYCryptoProvider.appendMode(modes, "CFB64");
            }
            if (modes.length() > 0) {
                this.put("Cipher.DESede", prefix + "SecretKeyCipher$DES3");
                this.put("Cipher.DESede SupportedModes", modes.toString());
                this.put("Cipher.DESede SupportedPaddings", "NOPADDING|PKCS5PADDING");
                this.put("Cipher.DESede SupportedKeyFormats", "RAW");
            }
        }
        if (DYCryptoProvider.isHwMech(mechList, 848)) {
            this.put("KeyGenerator.Hmac", prefix + "SecretKeyGenerator$Hmac");
            this.put("SecretKeyFactory.Hmac", prefix + "SecretKeyFactory$Hmac");
            this.put("Mac.Hmac SupportedKeyFormats", "RAW");
            if (DYCryptoProvider.isHwMech(mechList, 545)) {
                this.put("Mac.HmacSHA1", prefix + "Mac$HmacSHA1");
                this.put("Alg.Alias.Mac.OID.1.2.840.113549.2.7", "HmacSHA1");
                this.put("Alg.Alias.Mac.1.2.840.113549.2.7", "HmacSHA1");
            }
            if (DYCryptoProvider.isHwMech(mechList, 593)) {
                this.put("Mac.HmacSHA256", prefix + "Mac$HmacSHA256");
                this.put("Alg.Alias.Mac.OID.1.2.840.113549.2.9", "HmacSHA256");
                this.put("Alg.Alias.Mac.1.2.840.113549.2.9", "HmacSHA256");
            }
            if (DYCryptoProvider.isHwMech(mechList, 609)) {
                this.put("Mac.HmacSHA384", prefix + "Mac$HmacSHA384");
                this.put("Alg.Alias.Mac.OID.1.2.840.113549.2.10", "HmacSHA384");
                this.put("Alg.Alias.Mac.1.2.840.113549.2.10", "HmacSHA384");
            }
            if (DYCryptoProvider.isHwMech(mechList, 625)) {
                this.put("Mac.HmacSHA512", prefix + "Mac$HmacSHA512");
                this.put("Alg.Alias.Mac.OID.1.2.840.113549.2.11", "HmacSHA512");
                this.put("Alg.Alias.Mac.1.2.840.113549.2.11", "HmacSHA512");
            }
        }
        if (DYCryptoProvider.isHwMech(mechList, -2147451310)) {
            this.put("KeyPairGenerator.LIMA", prefix + "LIMAKeyPairGenerator");
            this.put("Alg.Alias.KeyPairGenerator.LIMA", "LIMA");
            this.put("Cipher.LIMA", prefix + "LIMACipher");
            this.put("Cipher.LIMA SupportedKeyClasses", "java.security.PublicKey|java.security.PrivateKey");
        }
        if (DYCryptoProvider.isHwMech(mechList, -2147451262)) {
            this.put("KeyPairGenerator.EDDSA", prefix + "EDDSAKeyPairGenerator");
            this.put("Alg.Alias.KeyPairGenerator.EDDSA", "EDDSA");
            if (DYCryptoProvider.isHwMech(mechList, -2147451263)) {
                this.put("Signature.NONEwithEDDSA", prefix + "EDDSASignature$Raw");
                this.put("Signature.NONEwithEDDSA SupportedKeyClasses", "java.security.PublicKey|java.security.PrivateKey");
            }
        }
        this.put("MessageDigest.SHA", prefix + "MessageDigest$SHA1");
        this.put("Alg.Alias.MessageDigest.SHA-1", "SHA");
        this.put("Alg.Alias.MessageDigest.SHA1", "SHA");
        this.put("MessageDigest.SHA-256", prefix + "MessageDigest$SHA256");
        this.put("MessageDigest.SHA-384", prefix + "MessageDigest$SHA384");
        this.put("MessageDigest.SHA-512", prefix + "MessageDigest$SHA512");
        this.putService(new KeyStoreService((Provider)this, prefix + "KeyStore", this.slot.getName()));
    }

    public static synchronized KeyStore getKeyStoreBySlot(Slot slot) {
        String name = slot.getName();
        KeyStore store = stores.get(name);
        if (store == null && (store = new KeyStore(Slot.find(name))) != null) {
            stores.put(name, store);
        }
        return store;
    }

    public X509Certificate SelfSign(PrivateKey key, String hashAlg, String subject, BigInteger serialNumber, int days) throws CertificateException {
        try {
            int hashMechansigm = 0;
            if (hashAlg == null || hashAlg.isEmpty()) {
                hashMechansigm = 592;
            } else if (hashAlg.equalsIgnoreCase("SHA1") || subject.equalsIgnoreCase("SHA-1")) {
                hashMechansigm = 544;
            } else if (hashAlg.equalsIgnoreCase("SHA256") || subject.equalsIgnoreCase("SHA-256")) {
                hashMechansigm = 592;
            } else if (hashAlg.equalsIgnoreCase("SHA384") || subject.equalsIgnoreCase("SHA-384")) {
                hashMechansigm = 608;
            } else if (hashAlg.equalsIgnoreCase("SHA512") || subject.equalsIgnoreCase("SHA-512")) {
                hashMechansigm = 624;
            } else {
                throw new IllegalArgumentException("Invalid hashAlg");
            }
            int privateHandle = 0;
            if (key instanceof ECPrivateKey) {
                ((ECPrivateKey)key).save(DYCryptoProvider.getKeyStoreBySlot(this.slot), null);
                privateHandle = ((ECPrivateKey)key).pkcs11Key.getHandle();
            } else if (key instanceof RSAPrivateKey) {
                ((RSAPrivateKey)key).save(DYCryptoProvider.getKeyStoreBySlot(this.slot), null);
                privateHandle = ((RSAPrivateKey)key).pkcs11Key.getHandle();
            } else {
                throw new IllegalArgumentException("Invalid key type");
            }
            char[] serialChars = subject.toCharArray();
            byte[] subjectBytes = serialNumber == null ? null : serialNumber.toByteArray();
            Session session = this.slot.getPersistentSession();
            byte[] bytes = session.DYC_SelfSignX509(privateHandle, hashMechansigm, serialChars, subjectBytes, days);
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            return (X509Certificate)certFactory.generateCertificate(in);
        }
        catch (CKException e) {
            throw new ProviderException(e);
        }
        catch (KeyStoreException e) {
            throw new ProviderException(e);
        }
    }

    static {
        if (Native.loaded) {
            Slot defaultSlot = Slot.getDefault();
            defaultKeyStore = new KeyStore(defaultSlot);
            stores.put(defaultSlot.getName(), defaultKeyStore);
        }
        mechInfo = new CK_MECHANISM_INFO();
        allowedPrivateKeyWithoutCertificate = false;
    }

    public static final class KeyEntry
    implements KeyStore.Entry {
        PrivateKey key;

        public KeyEntry(PrivateKey key) {
            this.key = key;
        }

        public PrivateKey getPrivateKey() {
            return this.key;
        }
    }

    final class KeyStoreService
    extends Provider.Service {
        private String slotName;
        private int slotID;

        public KeyStoreService(Provider provider, String className, String slotName) {
            super(provider, "KeyStore", "PKCS11", className, null, null);
            this.slotName = slotName;
        }

        public KeyStoreService(Provider provider, String className, int slotID) {
            super(provider, "KeyStore", "PKCS11", className, null, null);
            this.slotID = slotID;
        }

        @Override
        public boolean supportsParameter(Object param) {
            return false;
        }

        @Override
        public Object newInstance(Object param) {
            Slot slot;
            Slot slot2 = slot = this.slotName == null ? Slot.find(this.slotID) : Slot.find(this.slotName);
            if (slot == null) {
                return null;
            }
            return DYCryptoProvider.getKeyStoreBySlot(slot);
        }
    }
}

