/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.provider;

import com.dyadicsec.pkcs11.CKException;
import com.dyadicsec.provider.ECPrivateKey;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECPoint;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

public class ECDHKeyAgreement
extends KeyAgreementSpi {
    private ECPrivateKey prvKey = null;
    private ECPoint pub = null;

    @Override
    protected void engineInit(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (!(key instanceof ECPrivateKey)) {
            throw new InvalidKeyException("CKKey must be instance of CKECPrivateKey");
        }
        this.prvKey = (ECPrivateKey)key;
        try {
            this.prvKey.save();
        }
        catch (KeyStoreException e) {
            throw new InvalidKeyException(e);
        }
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("Parameters not supported");
        }
        if (!(key instanceof ECPrivateKey)) {
            throw new InvalidKeyException("CKKey must be instance of CKECPrivateKey");
        }
        this.prvKey = (ECPrivateKey)key;
        try {
            this.prvKey.save();
        }
        catch (KeyStoreException e) {
            throw new InvalidKeyException(e);
        }
    }

    @Override
    protected Key engineDoPhase(Key key, boolean lastPhase) throws InvalidKeyException, IllegalStateException {
        if (this.prvKey == null) {
            throw new IllegalStateException("Not initialized");
        }
        if (!lastPhase) {
            throw new IllegalStateException("Only two party agreement supported, lastPhase must be true");
        }
        if (this.pub != null) {
            throw new IllegalStateException("Phase already executed");
        }
        if (!(key instanceof ECPublicKey)) {
            throw new InvalidKeyException("CKKey must be a CKPublicKey with algorithm EC");
        }
        ECPublicKey pubKey = (ECPublicKey)key;
        if (!pubKey.getParams().equals(this.prvKey.getParams()) && !pubKey.getParams().getOrder().equals(this.prvKey.getParams().getOrder())) {
            throw new InvalidKeyException("EC curve doesn't match");
        }
        this.pub = pubKey.getW();
        return null;
    }

    @Override
    protected byte[] engineGenerateSecret() throws IllegalStateException {
        if (this.prvKey == null || this.pub == null) {
            throw new IllegalStateException("Not initialized correctly");
        }
        try {
            return this.prvKey.pkcs11Key.ecdh(this.pub);
        }
        catch (CKException e) {
            throw new ProviderException(e);
        }
    }

    @Override
    protected int engineGenerateSecret(byte[] out, int outOffset) throws IllegalStateException, ShortBufferException {
        int secretLen = this.prvKey.curve.getSize();
        if (outOffset + secretLen > out.length) {
            throw new ShortBufferException("Need " + secretLen + " bytes, only " + (out.length - outOffset) + " available");
        }
        byte[] secret = this.engineGenerateSecret();
        System.arraycopy(secret, 0, out, outOffset, secret.length);
        return secret.length;
    }

    @Override
    protected SecretKey engineGenerateSecret(String algorithm) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        if (algorithm == null) {
            throw new NoSuchAlgorithmException("Algorithm must not be null");
        }
        if (!algorithm.equals("TlsPremasterSecret")) {
            throw new NoSuchAlgorithmException("Only supported for algorithm TlsPremasterSecret");
        }
        return new SecretKeySpec(this.engineGenerateSecret(), "TlsPremasterSecret");
    }
}

