/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.provider;

import com.dyadicsec.pkcs11.CKECPrivateKey;
import com.dyadicsec.pkcs11.CKException;
import com.dyadicsec.pkcs11.CKPrivateKey;
import com.dyadicsec.pkcs11.CK_ATTRIBUTE;
import com.dyadicsec.pkcs11.ECCurve;
import com.dyadicsec.provider.DYKey;
import com.dyadicsec.provider.ECPublicKey;
import com.dyadicsec.provider.KeyParameters;
import com.dyadicsec.provider.KeyStore;
import com.dyadicsec.provider.UnwrapInfo;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.ProviderException;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;

public final class ECPrivateKey
extends DYKey
implements java.security.interfaces.ECPrivateKey {
    private static final long serialVersionUID = 1L;
    private java.security.interfaces.ECPrivateKey sw = null;
    private ECPublicKey genPublicKey = null;
    KeyParameters keyParams = null;
    ECCurve curve = null;
    CKECPrivateKey pkcs11Key = null;
    private UnwrapInfo unwrapInfo = null;

    ECPrivateKey() {
    }

    ECPrivateKey(CKECPrivateKey pkcs11Key) {
        this.pkcs11Key = pkcs11Key;
    }

    @Override
    protected CKPrivateKey getPkcs11Key() {
        return this.pkcs11Key;
    }

    ECPrivateKey initForUnwrap(UnwrapInfo unwrapInfo, KeyParameters keyParams) {
        this.keyParams = keyParams;
        this.unwrapInfo = unwrapInfo;
        return this;
    }

    ECPrivateKey initForImport(KeyParameters keyParams, KeySpec keySpec) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException, KeyStoreException {
        this.keyParams = keyParams;
        try {
            this.sw = (java.security.interfaces.ECPrivateKey)KeyFactory.getInstance("EC", "SunEC").generatePrivate(keySpec);
        }
        catch (NoSuchProviderException e) {
            this.sw = null;
        }
        catch (NoSuchAlgorithmException e) {
            this.sw = null;
        }
        if (this.sw == null) {
            this.sw = (java.security.interfaces.ECPrivateKey)KeyFactory.getInstance("EC", "IBMJCE").generatePrivate(keySpec);
        }
        this.curve = ECCurve.find(this.sw.getParams());
        if (this.curve == null) {
            throw new KeyStoreException("Unsupported EC curve");
        }
        return this;
    }

    ECPrivateKey initForImport(java.security.interfaces.ECPrivateKey key) throws KeyStoreException {
        this.sw = key;
        this.curve = ECCurve.find(this.sw.getParams());
        if (this.curve == null) {
            throw new KeyStoreException("Unsupported EC curve");
        }
        return this;
    }

    ECPrivateKey initForGenerate(KeyParameters keyParams, ECPublicKey genPublicKey, ECCurve curve) {
        this.keyParams = keyParams;
        this.curve = curve;
        this.genPublicKey = genPublicKey;
        genPublicKey.prvKey = this;
        return this;
    }

    private ECCurve getCurve() throws KeyStoreException {
        if (this.curve == null) {
            try {
                this.curve = this.pkcs11Key.getCurve();
            }
            catch (CKException e) {
                throw new KeyStoreException(e);
            }
        }
        return this.curve;
    }

    @Override
    protected void create(KeyStore store, String alias) throws KeyStoreException {
        try {
            this.pkcs11Key = CKECPrivateKey.create(store.slot, alias, KeyParameters.toPolicy(this.keyParams), this.curve, this.sw.getS());
        }
        catch (CKException e) {
            throw new KeyStoreException(e);
        }
    }

    @Override
    protected void generate(KeyStore store, String alias) throws KeyStoreException {
        try {
            this.pkcs11Key = CKECPrivateKey.generate(store.slot, alias, KeyParameters.toPolicy(this.keyParams), this.curve);
        }
        catch (CKException e) {
            throw new KeyStoreException(e);
        }
        if (this.genPublicKey != null) {
            try {
                this.genPublicKey.init(this.curve, this.pkcs11Key.getPoint());
            }
            catch (Throwable e) {
                throw new KeyStoreException(e);
            }
        }
    }

    @Override
    protected void unwrap(String alias) throws KeyStoreException {
        CK_ATTRIBUTE[] t = CKECPrivateKey.getUnwrapTemplate(alias, KeyParameters.toPolicy(this.keyParams));
        this.pkcs11Key = this.unwrapInfo.unwrap(CKECPrivateKey.class, t);
        this.unwrapInfo = null;
    }

    @Override
    protected boolean swKeyPresent() {
        return this.sw != null;
    }

    @Override
    protected boolean unwrapInfoPresent() {
        return this.unwrapInfo != null;
    }

    @Override
    public ECParameterSpec getParams() {
        try {
            return this.getCurve().getSpec();
        }
        catch (KeyStoreException e) {
            throw new ProviderException(e);
        }
    }

    @Override
    public String getAlgorithm() {
        return "EC";
    }

    @Override
    public String getFormat() {
        return this.sw != null ? this.sw.getFormat() : "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        return this.sw != null ? this.sw.getEncoded() : null;
    }

    @Override
    public BigInteger getS() {
        return null;
    }
}

