/*
 * Decompiled with CFR 0.152.
 */
package com.dyadicsec.provider;

import com.dyadicsec.pkcs11.ECCurve;
import com.dyadicsec.provider.ECPrivateKey;
import com.dyadicsec.provider.KeyParameters;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;

public final class ECPublicKey
implements java.security.interfaces.ECPublicKey {
    private static final long serialVersionUID = 1L;
    private java.security.interfaces.ECPublicKey sw = null;
    ECPrivateKey prvKey = null;

    ECPublicKey() {
    }

    private void init(KeySpec keySpec) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        KeyFactory kf;
        try {
            kf = KeyFactory.getInstance("EC", "SunEC");
        }
        catch (NoSuchProviderException e) {
            kf = null;
        }
        catch (NoSuchAlgorithmException e) {
            kf = null;
        }
        if (kf == null) {
            kf = KeyFactory.getInstance("EC", "IBMJCE");
        }
        this.sw = (java.security.interfaces.ECPublicKey)kf.generatePublic(keySpec);
    }

    ECPublicKey(KeySpec keySpec, KeyParameters keyParams) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        this.init(keySpec);
    }

    void init(ECCurve curve, ECPoint point) throws InvalidKeySpecException, NoSuchAlgorithmException, IOException, NoSuchProviderException {
        ECPublicKeySpec keySpec = new ECPublicKeySpec(point, curve.getSpec());
        this.init(keySpec);
    }

    ECPublicKey(java.security.interfaces.ECPublicKey key) {
        this.sw = key;
    }

    ECPublicKey(ECPoint w, ECParameterSpec params) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        this.init(new ECPublicKeySpec(w, params));
    }

    @Override
    public ECPoint getW() {
        return this.getSoftwareKey().getW();
    }

    @Override
    public ECParameterSpec getParams() {
        return this.getSoftwareKey().getParams();
    }

    @Override
    public String getAlgorithm() {
        return "EC";
    }

    @Override
    public String getFormat() {
        return this.getSoftwareKey().getFormat();
    }

    @Override
    public byte[] getEncoded() {
        return this.getSoftwareKey().getEncoded();
    }

    java.security.interfaces.ECPublicKey getSoftwareKey() {
        if (this.sw != null) {
            return this.sw;
        }
        if (this.prvKey != null) {
            try {
                this.prvKey.save();
            }
            catch (KeyStoreException e) {
                return null;
            }
        }
        return this.sw;
    }
}

